/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class ClientboundSetEntityMotionPacket
implements Packet<ClientGamePacketListener> {
    public static final StreamCodec<FriendlyByteBuf, ClientboundSetEntityMotionPacket> STREAM_CODEC = Packet.codec(ClientboundSetEntityMotionPacket::write, ClientboundSetEntityMotionPacket::new);
    private final int id;
    private final int xa;
    private final int ya;
    private final int za;

    public ClientboundSetEntityMotionPacket(Entity var0) {
        this(var0.getId(), var0.getDeltaMovement());
    }

    public ClientboundSetEntityMotionPacket(int var0, Vec3 var1) {
        this.id = var0;
        double var2 = 3.9;
        double var4 = Mth.clamp(var1.x, -3.9, 3.9);
        double var6 = Mth.clamp(var1.y, -3.9, 3.9);
        double var8 = Mth.clamp(var1.z, -3.9, 3.9);
        this.xa = (int)(var4 * 8000.0);
        this.ya = (int)(var6 * 8000.0);
        this.za = (int)(var8 * 8000.0);
    }

    private ClientboundSetEntityMotionPacket(FriendlyByteBuf var0) {
        this.id = var0.readVarInt();
        this.xa = var0.readShort();
        this.ya = var0.readShort();
        this.za = var0.readShort();
    }

    private void write(FriendlyByteBuf var0) {
        var0.writeVarInt(this.id);
        var0.writeShort(this.xa);
        var0.writeShort(this.ya);
        var0.writeShort(this.za);
    }

    @Override
    public PacketType<ClientboundSetEntityMotionPacket> type() {
        return GamePacketTypes.CLIENTBOUND_SET_ENTITY_MOTION;
    }

    @Override
    public void handle(ClientGamePacketListener var0) {
        var0.handleSetEntityMotion(this);
    }

    public int getId() {
        return this.id;
    }

    public double getXa() {
        return (double)this.xa / 8000.0;
    }

    public double getYa() {
        return (double)this.ya / 8000.0;
    }

    public double getZa() {
        return (double)this.za / 8000.0;
    }
}

