/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;

public class ClientboundSetEquipmentPacket
implements Packet<ClientGamePacketListener> {
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundSetEquipmentPacket> STREAM_CODEC = Packet.codec(ClientboundSetEquipmentPacket::write, ClientboundSetEquipmentPacket::new);
    private static final byte CONTINUE_MASK = -128;
    private final int entity;
    private final List<Pair<EquipmentSlot, ItemStack>> slots;

    public ClientboundSetEquipmentPacket(int var0, List<Pair<EquipmentSlot, ItemStack>> var1) {
        this.entity = var0;
        this.slots = var1;
    }

    private ClientboundSetEquipmentPacket(RegistryFriendlyByteBuf var0) {
        byte var1;
        this.entity = var0.readVarInt();
        this.slots = Lists.newArrayList();
        do {
            var1 = var0.readByte();
            EquipmentSlot var2 = EquipmentSlot.VALUES.get(var1 & 0x7F);
            ItemStack var3 = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode(var0);
            this.slots.add((Pair<EquipmentSlot, ItemStack>)Pair.of((Object)var2, (Object)var3));
        } while ((var1 & 0xFFFFFF80) != 0);
    }

    private void write(RegistryFriendlyByteBuf var0) {
        var0.writeVarInt(this.entity);
        int var1 = this.slots.size();
        for (int var2 = 0; var2 < var1; ++var2) {
            Pair<EquipmentSlot, ItemStack> var3 = this.slots.get(var2);
            EquipmentSlot var4 = (EquipmentSlot)var3.getFirst();
            boolean var5 = var2 != var1 - 1;
            int var6 = var4.ordinal();
            var0.writeByte(var5 ? var6 | 0xFFFFFF80 : var6);
            ItemStack.OPTIONAL_STREAM_CODEC.encode(var0, (ItemStack)var3.getSecond());
        }
    }

    @Override
    public PacketType<ClientboundSetEquipmentPacket> type() {
        return GamePacketTypes.CLIENTBOUND_SET_EQUIPMENT;
    }

    @Override
    public void handle(ClientGamePacketListener var0) {
        var0.handleSetEquipment(this);
    }

    public int getEntity() {
        return this.entity;
    }

    public List<Pair<EquipmentSlot, ItemStack>> getSlots() {
        return this.slots;
    }
}

