/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;

public record CommonPlayerSpawnInfo(Holder<DimensionType> dimensionType, ResourceKey<Level> dimension, long seed, GameType gameType, @Nullable GameType previousGameType, boolean isDebug, boolean isFlat, Optional<GlobalPos> lastDeathLocation, int portalCooldown, int seaLevel) {
    public CommonPlayerSpawnInfo(RegistryFriendlyByteBuf var0) {
        this((Holder)DimensionType.STREAM_CODEC.decode(var0), var0.readResourceKey(Registries.DIMENSION), var0.readLong(), GameType.byId(var0.readByte()), GameType.byNullableId(var0.readByte()), var0.readBoolean(), var0.readBoolean(), var0.readOptional(FriendlyByteBuf::readGlobalPos), var0.readVarInt(), var0.readVarInt());
    }

    public void write(RegistryFriendlyByteBuf var0) {
        DimensionType.STREAM_CODEC.encode(var0, this.dimensionType);
        var0.writeResourceKey(this.dimension);
        var0.writeLong(this.seed);
        var0.writeByte(this.gameType.getId());
        var0.writeByte(GameType.getNullableId(this.previousGameType));
        var0.writeBoolean(this.isDebug);
        var0.writeBoolean(this.isFlat);
        var0.writeOptional(this.lastDeathLocation, FriendlyByteBuf::writeGlobalPos);
        var0.writeVarInt(this.portalCooldown);
        var0.writeVarInt(this.seaLevel);
    }
}

