/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.time.Instant;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.LastSeenMessages;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.ServerGamePacketListener;

public record ServerboundChatPacket(String message, Instant timeStamp, long salt, @Nullable MessageSignature signature, LastSeenMessages.Update lastSeenMessages) implements Packet<ServerGamePacketListener>
{
    public static final StreamCodec<FriendlyByteBuf, ServerboundChatPacket> STREAM_CODEC = Packet.codec(ServerboundChatPacket::write, ServerboundChatPacket::new);

    private ServerboundChatPacket(FriendlyByteBuf var0) {
        this(var0.readUtf(256), var0.readInstant(), var0.readLong(), var0.readNullable(MessageSignature::read), new LastSeenMessages.Update(var0));
    }

    private void write(FriendlyByteBuf var0) {
        var0.writeUtf(this.message, 256);
        var0.writeInstant(this.timeStamp);
        var0.writeLong(this.salt);
        var0.writeNullable(this.signature, MessageSignature::write);
        this.lastSeenMessages.write(var0);
    }

    @Override
    public PacketType<ServerboundChatPacket> type() {
        return GamePacketTypes.SERVERBOUND_CHAT;
    }

    @Override
    public void handle(ServerGamePacketListener var0) {
        var0.handleChat(this);
    }
}

