/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.ServerGamePacketListener;

public class ServerboundPaddleBoatPacket
implements Packet<ServerGamePacketListener> {
    public static final StreamCodec<FriendlyByteBuf, ServerboundPaddleBoatPacket> STREAM_CODEC = Packet.codec(ServerboundPaddleBoatPacket::write, ServerboundPaddleBoatPacket::new);
    private final boolean left;
    private final boolean right;

    public ServerboundPaddleBoatPacket(boolean var0, boolean var1) {
        this.left = var0;
        this.right = var1;
    }

    private ServerboundPaddleBoatPacket(FriendlyByteBuf var0) {
        this.left = var0.readBoolean();
        this.right = var0.readBoolean();
    }

    private void write(FriendlyByteBuf var0) {
        var0.writeBoolean(this.left);
        var0.writeBoolean(this.right);
    }

    @Override
    public void handle(ServerGamePacketListener var0) {
        var0.handlePaddleBoat(this);
    }

    @Override
    public PacketType<ServerboundPaddleBoatPacket> type() {
        return GamePacketTypes.SERVERBOUND_PADDLE_BOAT;
    }

    public boolean getLeft() {
        return this.left;
    }

    public boolean getRight() {
        return this.right;
    }
}

