/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.properties.StructureMode;

public class ServerboundSetStructureBlockPacket
implements Packet<ServerGamePacketListener> {
    public static final StreamCodec<FriendlyByteBuf, ServerboundSetStructureBlockPacket> STREAM_CODEC = Packet.codec(ServerboundSetStructureBlockPacket::write, ServerboundSetStructureBlockPacket::new);
    private static final int FLAG_IGNORE_ENTITIES = 1;
    private static final int FLAG_SHOW_AIR = 2;
    private static final int FLAG_SHOW_BOUNDING_BOX = 4;
    private static final int FLAG_STRICT = 8;
    private final BlockPos pos;
    private final StructureBlockEntity.UpdateType updateType;
    private final StructureMode mode;
    private final String name;
    private final BlockPos offset;
    private final Vec3i size;
    private final Mirror mirror;
    private final Rotation rotation;
    private final String data;
    private final boolean ignoreEntities;
    private final boolean strict;
    private final boolean showAir;
    private final boolean showBoundingBox;
    private final float integrity;
    private final long seed;

    public ServerboundSetStructureBlockPacket(BlockPos var0, StructureBlockEntity.UpdateType var1, StructureMode var2, String var3, BlockPos var4, Vec3i var5, Mirror var6, Rotation var7, String var8, boolean var9, boolean var10, boolean var11, boolean var12, float var13, long var14) {
        this.pos = var0;
        this.updateType = var1;
        this.mode = var2;
        this.name = var3;
        this.offset = var4;
        this.size = var5;
        this.mirror = var6;
        this.rotation = var7;
        this.data = var8;
        this.ignoreEntities = var9;
        this.strict = var10;
        this.showAir = var11;
        this.showBoundingBox = var12;
        this.integrity = var13;
        this.seed = var14;
    }

    private ServerboundSetStructureBlockPacket(FriendlyByteBuf var0) {
        this.pos = var0.readBlockPos();
        this.updateType = var0.readEnum(StructureBlockEntity.UpdateType.class);
        this.mode = var0.readEnum(StructureMode.class);
        this.name = var0.readUtf();
        int var1 = 48;
        this.offset = new BlockPos(Mth.clamp(var0.readByte(), -48, 48), Mth.clamp(var0.readByte(), -48, 48), Mth.clamp(var0.readByte(), -48, 48));
        int var2 = 48;
        this.size = new Vec3i(Mth.clamp(var0.readByte(), 0, 48), Mth.clamp(var0.readByte(), 0, 48), Mth.clamp(var0.readByte(), 0, 48));
        this.mirror = var0.readEnum(Mirror.class);
        this.rotation = var0.readEnum(Rotation.class);
        this.data = var0.readUtf(128);
        this.integrity = Mth.clamp(var0.readFloat(), 0.0f, 1.0f);
        this.seed = var0.readVarLong();
        byte var3 = var0.readByte();
        this.ignoreEntities = (var3 & 1) != 0;
        this.strict = (var3 & 8) != 0;
        this.showAir = (var3 & 2) != 0;
        this.showBoundingBox = (var3 & 4) != 0;
    }

    private void write(FriendlyByteBuf var0) {
        var0.writeBlockPos(this.pos);
        var0.writeEnum(this.updateType);
        var0.writeEnum(this.mode);
        var0.writeUtf(this.name);
        var0.writeByte(this.offset.getX());
        var0.writeByte(this.offset.getY());
        var0.writeByte(this.offset.getZ());
        var0.writeByte(this.size.getX());
        var0.writeByte(this.size.getY());
        var0.writeByte(this.size.getZ());
        var0.writeEnum(this.mirror);
        var0.writeEnum(this.rotation);
        var0.writeUtf(this.data);
        var0.writeFloat(this.integrity);
        var0.writeVarLong(this.seed);
        int var1 = 0;
        if (this.ignoreEntities) {
            var1 |= 1;
        }
        if (this.showAir) {
            var1 |= 2;
        }
        if (this.showBoundingBox) {
            var1 |= 4;
        }
        if (this.strict) {
            var1 |= 8;
        }
        var0.writeByte(var1);
    }

    @Override
    public PacketType<ServerboundSetStructureBlockPacket> type() {
        return GamePacketTypes.SERVERBOUND_SET_STRUCTURE_BLOCK;
    }

    @Override
    public void handle(ServerGamePacketListener var0) {
        var0.handleSetStructureBlock(this);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public StructureBlockEntity.UpdateType getUpdateType() {
        return this.updateType;
    }

    public StructureMode getMode() {
        return this.mode;
    }

    public String getName() {
        return this.name;
    }

    public BlockPos getOffset() {
        return this.offset;
    }

    public Vec3i getSize() {
        return this.size;
    }

    public Mirror getMirror() {
        return this.mirror;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public String getData() {
        return this.data;
    }

    public boolean isIgnoreEntities() {
        return this.ignoreEntities;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public boolean isShowAir() {
        return this.showAir;
    }

    public boolean isShowBoundingBox() {
        return this.showBoundingBox;
    }

    public float getIntegrity() {
        return this.integrity;
    }

    public long getSeed() {
        return this.seed;
    }
}

