/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public final class RegistryFileCodec<E>
implements Codec<Holder<E>> {
    private final ResourceKey<? extends Registry<E>> registryKey;
    private final Codec<E> elementCodec;
    private final boolean allowInline;

    public static <E> RegistryFileCodec<E> create(ResourceKey<? extends Registry<E>> var0, Codec<E> var1) {
        return RegistryFileCodec.create(var0, var1, true);
    }

    public static <E> RegistryFileCodec<E> create(ResourceKey<? extends Registry<E>> var0, Codec<E> var1, boolean var2) {
        return new RegistryFileCodec<E>(var0, var1, var2);
    }

    private RegistryFileCodec(ResourceKey<? extends Registry<E>> var0, Codec<E> var1, boolean var2) {
        this.registryKey = var0;
        this.elementCodec = var1;
        this.allowInline = var2;
    }

    public <T> DataResult<T> encode(Holder<E> var0, DynamicOps<T> var1, T var22) {
        RegistryOps var3;
        Optional var4;
        if (var1 instanceof RegistryOps && (var4 = (var3 = (RegistryOps)var1).owner(this.registryKey)).isPresent()) {
            if (!var0.canSerializeIn(var4.get())) {
                return DataResult.error(() -> "Element " + String.valueOf(var0) + " is not valid in current registry set");
            }
            return (DataResult)var0.unwrap().map(var2 -> ResourceLocation.CODEC.encode((Object)var2.location(), var1, var22), var2 -> this.elementCodec.encode(var2, var1, var22));
        }
        return this.elementCodec.encode(var0.value(), var1, var22);
    }

    public <T> DataResult<Pair<Holder<E>, T>> decode(DynamicOps<T> var02, T var12) {
        if (var02 instanceof RegistryOps) {
            RegistryOps var2 = (RegistryOps)var02;
            Optional var3 = var2.getter(this.registryKey);
            if (var3.isEmpty()) {
                return DataResult.error(() -> "Registry does not exist: " + String.valueOf(this.registryKey));
            }
            HolderGetter var4 = var3.get();
            DataResult var5 = ResourceLocation.CODEC.decode(var02, var12);
            if (var5.result().isEmpty()) {
                if (!this.allowInline) {
                    return DataResult.error(() -> "Inline definitions not allowed here");
                }
                return this.elementCodec.decode(var02, var12).map(var0 -> var0.mapFirst(Holder::direct));
            }
            Pair var6 = (Pair)var5.result().get();
            ResourceKey var7 = ResourceKey.create(this.registryKey, (ResourceLocation)var6.getFirst());
            return var4.get(var7).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Failed to get element " + String.valueOf(var7))).map(var1 -> Pair.of((Object)var1, (Object)var6.getSecond())).setLifecycle(Lifecycle.stable());
        }
        return this.elementCodec.decode(var02, var12).map(var0 -> var0.mapFirst(Holder::direct));
    }

    public String toString() {
        return "RegistryFileCodec[" + String.valueOf(this.registryKey) + " " + String.valueOf(this.elementCodec) + "]";
    }

    public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
        return this.encode((Holder)object, dynamicOps, object2);
    }
}

