/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagLoader;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.slf4j.Logger;

public class ReloadableServerRegistries {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final RegistrationInfo DEFAULT_REGISTRATION_INFO = new RegistrationInfo(Optional.empty(), Lifecycle.experimental());

    public static CompletableFuture<LoadResult> reload(LayeredRegistryAccess<RegistryLayer> var0, List<Registry.PendingTags<?>> var1, ResourceManager var22, Executor var32) {
        List<HolderLookup.RegistryLookup<?>> var4 = TagLoader.buildUpdatedLookups(var0.getAccessForLoading(RegistryLayer.RELOADABLE), var1);
        HolderLookup.Provider var5 = HolderLookup.Provider.create(var4.stream());
        RegistryOps var6 = var5.createSerializationContext(JsonOps.INSTANCE);
        List<CompletableFuture> var7 = LootDataType.values().map(var3 -> ReloadableServerRegistries.scheduleRegistryLoad(var3, var6, var22, var32)).toList();
        CompletableFuture var8 = Util.sequence(var7);
        return var8.thenApplyAsync(var2 -> ReloadableServerRegistries.createAndValidateFullContext(var0, var5, var2), var32);
    }

    private static <T> CompletableFuture<WritableRegistry<?>> scheduleRegistryLoad(LootDataType<T> var0, RegistryOps<JsonElement> var1, ResourceManager var2, Executor var3) {
        return CompletableFuture.supplyAsync(() -> {
            MappedRegistry var32 = new MappedRegistry(var0.registryKey(), Lifecycle.experimental());
            HashMap<ResourceLocation, Object> var4 = new HashMap<ResourceLocation, Object>();
            SimpleJsonResourceReloadListener.scanDirectory(var2, var0.registryKey(), (DynamicOps<JsonElement>)var1, var0.codec(), var4);
            var4.forEach((var2, var3) -> var32.register(ResourceKey.create(var0.registryKey(), var2), var3, DEFAULT_REGISTRATION_INFO));
            TagLoader.loadTagsForRegistry(var2, var32);
            return var32;
        }, var3);
    }

    private static LoadResult createAndValidateFullContext(LayeredRegistryAccess<RegistryLayer> var0, HolderLookup.Provider var1, List<WritableRegistry<?>> var2) {
        LayeredRegistryAccess<RegistryLayer> var3 = ReloadableServerRegistries.createUpdatedRegistries(var0, var2);
        HolderLookup.Provider var4 = ReloadableServerRegistries.concatenateLookups(var1, var3.getLayer(RegistryLayer.RELOADABLE));
        ReloadableServerRegistries.validateLootRegistries(var4);
        return new LoadResult(var3, var4);
    }

    private static HolderLookup.Provider concatenateLookups(HolderLookup.Provider var0, HolderLookup.Provider var1) {
        return HolderLookup.Provider.create(Stream.concat(var0.listRegistries(), var1.listRegistries()));
    }

    private static void validateLootRegistries(HolderLookup.Provider var02) {
        ProblemReporter.Collector var12 = new ProblemReporter.Collector();
        ValidationContext var22 = new ValidationContext(var12, LootContextParamSets.ALL_PARAMS, var02);
        LootDataType.values().forEach(var2 -> ReloadableServerRegistries.validateRegistry(var22, var2, var02));
        var12.forEach((var0, var1) -> LOGGER.warn("Found loot table element validation problem in {}: {}", var0, (Object)var1.description()));
    }

    private static LayeredRegistryAccess<RegistryLayer> createUpdatedRegistries(LayeredRegistryAccess<RegistryLayer> var0, List<WritableRegistry<?>> var1) {
        return var0.replaceFrom(RegistryLayer.RELOADABLE, new RegistryAccess.ImmutableRegistryAccess(var1).freeze());
    }

    private static <T> void validateRegistry(ValidationContext var0, LootDataType<T> var1, HolderLookup.Provider var22) {
        HolderGetter var3 = var22.lookupOrThrow(var1.registryKey());
        var3.listElements().forEach(var2 -> var1.runValidation(var0, var2.key(), var2.value()));
    }

    public record LoadResult(LayeredRegistryAccess<RegistryLayer> layers, HolderLookup.Provider lookupWithUpdatedTags) {
    }

    public static class Holder {
        private final HolderLookup.Provider registries;

        public Holder(HolderLookup.Provider var0) {
            this.registries = var0;
        }

        public HolderLookup.Provider lookup() {
            return this.registries;
        }

        public LootTable getLootTable(ResourceKey<LootTable> var0) {
            return this.registries.lookup(Registries.LOOT_TABLE).flatMap(var1 -> var1.get(var0)).map(net.minecraft.core.Holder::value).orElse(LootTable.EMPTY);
        }
    }
}

