/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.advancements;

import it.unimi.dsi.fastutil.Stack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.DisplayInfo;

public class AdvancementVisibilityEvaluator {
    private static final int VISIBILITY_DEPTH = 2;

    private static VisibilityRule evaluateVisibilityRule(Advancement var0, boolean var1) {
        Optional<DisplayInfo> var2 = var0.display();
        if (var2.isEmpty()) {
            return VisibilityRule.HIDE;
        }
        if (var1) {
            return VisibilityRule.SHOW;
        }
        if (var2.get().isHidden()) {
            return VisibilityRule.HIDE;
        }
        return VisibilityRule.NO_CHANGE;
    }

    private static boolean evaluateVisiblityForUnfinishedNode(Stack<VisibilityRule> var0) {
        for (int var1 = 0; var1 <= 2; ++var1) {
            VisibilityRule var2 = (VisibilityRule)((Object)var0.peek(var1));
            if (var2 == VisibilityRule.SHOW) {
                return true;
            }
            if (var2 != VisibilityRule.HIDE) continue;
            return false;
        }
        return false;
    }

    private static boolean evaluateVisibility(AdvancementNode var0, Stack<VisibilityRule> var1, Predicate<AdvancementNode> var2, Output var3) {
        boolean var4 = var2.test(var0);
        VisibilityRule var5 = AdvancementVisibilityEvaluator.evaluateVisibilityRule(var0.advancement(), var4);
        boolean var6 = var4;
        var1.push((Object)var5);
        for (AdvancementNode var8 : var0.children()) {
            var6 |= AdvancementVisibilityEvaluator.evaluateVisibility(var8, var1, var2, var3);
        }
        boolean var7 = var6 || AdvancementVisibilityEvaluator.evaluateVisiblityForUnfinishedNode(var1);
        var1.pop();
        var3.accept(var0, var7);
        return var6;
    }

    public static void evaluateVisibility(AdvancementNode var0, Predicate<AdvancementNode> var1, Output var2) {
        AdvancementNode var3 = var0.root();
        ObjectArrayList var4 = new ObjectArrayList();
        for (int var5 = 0; var5 <= 2; ++var5) {
            var4.push((Object)VisibilityRule.NO_CHANGE);
        }
        AdvancementVisibilityEvaluator.evaluateVisibility(var3, (Stack<VisibilityRule>)var4, var1, var2);
    }

    static enum VisibilityRule {
        SHOW,
        HIDE,
        NO_CHANGE;

    }

    @FunctionalInterface
    public static interface Output {
        public void accept(AdvancementNode var1, boolean var2);
    }
}

