/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.bossevents;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.craftbukkit.v1_21_R5.boss.CraftKeyedBossbar;

public class CustomBossEvent
extends ServerBossEvent {
    private static final int DEFAULT_MAX = 100;
    private final ResourceLocation id;
    private final Set<UUID> players = Sets.newHashSet();
    private int value;
    private int max = 100;
    private KeyedBossBar bossBar;

    public KeyedBossBar getBukkitEntity() {
        if (this.bossBar == null) {
            this.bossBar = new CraftKeyedBossbar(this);
        }
        return this.bossBar;
    }

    public CustomBossEvent(ResourceLocation minecraftkey, Component ichatbasecomponent) {
        super(ichatbasecomponent, BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.PROGRESS);
        this.id = minecraftkey;
        this.setProgress(0.0f);
    }

    public ResourceLocation getTextId() {
        return this.id;
    }

    @Override
    public void addPlayer(ServerPlayer entityplayer) {
        super.addPlayer(entityplayer);
        this.players.add(entityplayer.getUUID());
    }

    public void addOfflinePlayer(UUID uuid) {
        this.players.add(uuid);
    }

    @Override
    public void removePlayer(ServerPlayer entityplayer) {
        super.removePlayer(entityplayer);
        this.players.remove(entityplayer.getUUID());
    }

    @Override
    public void removeAllPlayers() {
        super.removeAllPlayers();
        this.players.clear();
    }

    public int getValue() {
        return this.value;
    }

    public int getMax() {
        return this.max;
    }

    public void setValue(int i) {
        this.value = i;
        this.setProgress(Mth.clamp((float)i / (float)this.max, 0.0f, 1.0f));
    }

    public void setMax(int i) {
        this.max = i;
        this.setProgress(Mth.clamp((float)this.value / (float)i, 0.0f, 1.0f));
    }

    public final Component getDisplayName() {
        return ComponentUtils.wrapInSquareBrackets(this.getName()).withStyle(chatmodifier -> chatmodifier.withColor(this.getColor().getFormatting()).withHoverEvent(new HoverEvent.ShowText(Component.literal(this.getTextId().toString()))).withInsertion(this.getTextId().toString()));
    }

    public boolean setPlayers(Collection<ServerPlayer> collection) {
        HashSet set = Sets.newHashSet();
        HashSet set1 = Sets.newHashSet();
        for (UUID uuid : this.players) {
            boolean flag = false;
            for (ServerPlayer entityplayer : collection) {
                if (!entityplayer.getUUID().equals(uuid)) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            set.add(uuid);
        }
        for (ServerPlayer entityplayer1 : collection) {
            boolean flag1 = false;
            for (UUID uuid1 : this.players) {
                if (!entityplayer1.getUUID().equals(uuid1)) continue;
                flag1 = true;
                break;
            }
            if (flag1) continue;
            set1.add(entityplayer1);
        }
        for (UUID uuid2 : set) {
            for (ServerPlayer entityplayer2 : this.getPlayers()) {
                if (!entityplayer2.getUUID().equals(uuid2)) continue;
                this.removePlayer(entityplayer2);
                break;
            }
            this.players.remove(uuid2);
        }
        for (ServerPlayer entityplayer3 : set1) {
            this.addPlayer(entityplayer3);
        }
        return !set.isEmpty() || !set1.isEmpty();
    }

    public static CustomBossEvent load(ResourceLocation minecraftkey, Packed bossbattlecustom_a) {
        CustomBossEvent bossbattlecustom = new CustomBossEvent(minecraftkey, bossbattlecustom_a.name);
        bossbattlecustom.setVisible(bossbattlecustom_a.visible);
        bossbattlecustom.setValue(bossbattlecustom_a.value);
        bossbattlecustom.setMax(bossbattlecustom_a.max);
        bossbattlecustom.setColor(bossbattlecustom_a.color);
        bossbattlecustom.setOverlay(bossbattlecustom_a.overlay);
        bossbattlecustom.setDarkenScreen(bossbattlecustom_a.darkenScreen);
        bossbattlecustom.setPlayBossMusic(bossbattlecustom_a.playBossMusic);
        bossbattlecustom.setCreateWorldFog(bossbattlecustom_a.createWorldFog);
        Set<UUID> set = bossbattlecustom_a.players;
        Objects.requireNonNull(bossbattlecustom);
        set.forEach(bossbattlecustom::addOfflinePlayer);
        return bossbattlecustom;
    }

    public Packed pack() {
        return new Packed(this.getName(), this.isVisible(), this.getValue(), this.getMax(), this.getColor(), this.getOverlay(), this.shouldDarkenScreen(), this.shouldPlayBossMusic(), this.shouldCreateWorldFog(), Set.copyOf(this.players));
    }

    public void onPlayerConnect(ServerPlayer entityplayer) {
        if (this.players.contains(entityplayer.getUUID())) {
            this.addPlayer(entityplayer);
        }
    }

    public void onPlayerDisconnect(ServerPlayer entityplayer) {
        super.removePlayer(entityplayer);
    }

    public record Packed(Component name, boolean visible, int value, int max, BossEvent.BossBarColor color, BossEvent.BossBarOverlay overlay, boolean darkenScreen, boolean playBossMusic, boolean createWorldFog, Set<UUID> players) {
        public static final Codec<Packed> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ComponentSerialization.CODEC.fieldOf("Name").forGetter(Packed::name), (App)Codec.BOOL.optionalFieldOf("Visible", (Object)false).forGetter(Packed::visible), (App)Codec.INT.optionalFieldOf("Value", (Object)0).forGetter(Packed::value), (App)Codec.INT.optionalFieldOf("Max", (Object)100).forGetter(Packed::max), (App)BossEvent.BossBarColor.CODEC.optionalFieldOf("Color", (Object)BossEvent.BossBarColor.WHITE).forGetter(Packed::color), (App)BossEvent.BossBarOverlay.CODEC.optionalFieldOf("Overlay", (Object)BossEvent.BossBarOverlay.PROGRESS).forGetter(Packed::overlay), (App)Codec.BOOL.optionalFieldOf("DarkenScreen", (Object)false).forGetter(Packed::darkenScreen), (App)Codec.BOOL.optionalFieldOf("PlayBossMusic", (Object)false).forGetter(Packed::playBossMusic), (App)Codec.BOOL.optionalFieldOf("CreateWorldFog", (Object)false).forGetter(Packed::createWorldFog), (App)UUIDUtil.CODEC_SET.optionalFieldOf("Players", Set.of()).forGetter(Packed::players)).apply((Applicative)instance, Packed::new));
    }
}

