/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.AdvancementTree;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class AdvancementCommands {
    private static final DynamicCommandExceptionType ERROR_NO_ACTION_PERFORMED = new DynamicCommandExceptionType(var0 -> (Component)var0);
    private static final Dynamic2CommandExceptionType ERROR_CRITERION_NOT_FOUND = new Dynamic2CommandExceptionType((var0, var1) -> Component.translatableEscape("commands.advancement.criterionNotFound", var0, var1));

    public static void register(CommandDispatcher<CommandSourceStack> var02) {
        var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("advancement").requires(Commands.hasPermission(2))).then(Commands.literal("grant").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("targets", EntityArgument.players()).then(Commands.literal("only").then(((RequiredArgumentBuilder)Commands.argument("advancement", ResourceKeyArgument.key(Registries.ADVANCEMENT)).executes(var0 -> AdvancementCommands.perform((CommandSourceStack)var0.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)var0, "targets"), Action.GRANT, AdvancementCommands.getAdvancements((CommandContext<CommandSourceStack>)var0, ResourceKeyArgument.getAdvancement((CommandContext<CommandSourceStack>)var0, "advancement"), Mode.ONLY)))).then(Commands.argument("criterion", StringArgumentType.greedyString()).suggests((var0, var1) -> SharedSuggestionProvider.suggest(ResourceKeyArgument.getAdvancement((CommandContext<CommandSourceStack>)var0, "advancement").value().criteria().keySet(), var1)).executes(var0 -> AdvancementCommands.performCriterion((CommandSourceStack)var0.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)var0, "targets"), Action.GRANT, ResourceKeyArgument.getAdvancement((CommandContext<CommandSourceStack>)var0, "advancement"), StringArgumentType.getString((CommandContext)var0, (String)"criterion"))))))).then(Commands.literal("from").then(Commands.argument("advancement", ResourceKeyArgument.key(Registries.ADVANCEMENT)).executes(var0 -> AdvancementCommands.perform((CommandSourceStack)var0.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)var0, "targets"), Action.GRANT, AdvancementCommands.getAdvancements((CommandContext<CommandSourceStack>)var0, ResourceKeyArgument.getAdvancement((CommandContext<CommandSourceStack>)var0, "advancement"), Mode.FROM)))))).then(Commands.literal("until").then(Commands.argument("advancement", ResourceKeyArgument.key(Registries.ADVANCEMENT)).executes(var0 -> AdvancementCommands.perform((CommandSourceStack)var0.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)var0, "targets"), Action.GRANT, AdvancementCommands.getAdvancements((CommandContext<CommandSourceStack>)var0, ResourceKeyArgument.getAdvancement((CommandContext<CommandSourceStack>)var0, "advancement"), Mode.UNTIL)))))).then(Commands.literal("through").then(Commands.argument("advancement", ResourceKeyArgument.key(Registries.ADVANCEMENT)).executes(var0 -> AdvancementCommands.perform((CommandSourceStack)var0.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)var0, "targets"), Action.GRANT, AdvancementCommands.getAdvancements((CommandContext<CommandSourceStack>)var0, ResourceKeyArgument.getAdvancement((CommandContext<CommandSourceStack>)var0, "advancement"), Mode.THROUGH)))))).then(Commands.literal("everything").executes(var0 -> AdvancementCommands.perform((CommandSourceStack)var0.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)var0, "targets"), Action.GRANT, ((CommandSourceStack)var0.getSource()).getServer().getAdvancements().getAllAdvancements(), false)))))).then(Commands.literal("revoke").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("targets", EntityArgument.players()).then(Commands.literal("only").then(((RequiredArgumentBuilder)Commands.argument("advancement", ResourceKeyArgument.key(Registries.ADVANCEMENT)).executes(var0 -> AdvancementCommands.perform((CommandSourceStack)var0.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)var0, "targets"), Action.REVOKE, AdvancementCommands.getAdvancements((CommandContext<CommandSourceStack>)var0, ResourceKeyArgument.getAdvancement((CommandContext<CommandSourceStack>)var0, "advancement"), Mode.ONLY)))).then(Commands.argument("criterion", StringArgumentType.greedyString()).suggests((var0, var1) -> SharedSuggestionProvider.suggest(ResourceKeyArgument.getAdvancement((CommandContext<CommandSourceStack>)var0, "advancement").value().criteria().keySet(), var1)).executes(var0 -> AdvancementCommands.performCriterion((CommandSourceStack)var0.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)var0, "targets"), Action.REVOKE, ResourceKeyArgument.getAdvancement((CommandContext<CommandSourceStack>)var0, "advancement"), StringArgumentType.getString((CommandContext)var0, (String)"criterion"))))))).then(Commands.literal("from").then(Commands.argument("advancement", ResourceKeyArgument.key(Registries.ADVANCEMENT)).executes(var0 -> AdvancementCommands.perform((CommandSourceStack)var0.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)var0, "targets"), Action.REVOKE, AdvancementCommands.getAdvancements((CommandContext<CommandSourceStack>)var0, ResourceKeyArgument.getAdvancement((CommandContext<CommandSourceStack>)var0, "advancement"), Mode.FROM)))))).then(Commands.literal("until").then(Commands.argument("advancement", ResourceKeyArgument.key(Registries.ADVANCEMENT)).executes(var0 -> AdvancementCommands.perform((CommandSourceStack)var0.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)var0, "targets"), Action.REVOKE, AdvancementCommands.getAdvancements((CommandContext<CommandSourceStack>)var0, ResourceKeyArgument.getAdvancement((CommandContext<CommandSourceStack>)var0, "advancement"), Mode.UNTIL)))))).then(Commands.literal("through").then(Commands.argument("advancement", ResourceKeyArgument.key(Registries.ADVANCEMENT)).executes(var0 -> AdvancementCommands.perform((CommandSourceStack)var0.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)var0, "targets"), Action.REVOKE, AdvancementCommands.getAdvancements((CommandContext<CommandSourceStack>)var0, ResourceKeyArgument.getAdvancement((CommandContext<CommandSourceStack>)var0, "advancement"), Mode.THROUGH)))))).then(Commands.literal("everything").executes(var0 -> AdvancementCommands.perform((CommandSourceStack)var0.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)var0, "targets"), Action.REVOKE, ((CommandSourceStack)var0.getSource()).getServer().getAdvancements().getAllAdvancements())))))));
    }

    private static int perform(CommandSourceStack var0, Collection<ServerPlayer> var1, Action var2, Collection<AdvancementHolder> var3) throws CommandSyntaxException {
        return AdvancementCommands.perform(var0, var1, var2, var3, true);
    }

    private static int perform(CommandSourceStack var0, Collection<ServerPlayer> var1, Action var2, Collection<AdvancementHolder> var3, boolean var4) throws CommandSyntaxException {
        int var5 = 0;
        for (ServerPlayer var7 : var1) {
            var5 += var2.perform(var7, var3, var4);
        }
        if (var5 == 0) {
            if (var3.size() == 1) {
                if (var1.size() == 1) {
                    throw ERROR_NO_ACTION_PERFORMED.create((Object)Component.translatable(var2.getKey() + ".one.to.one.failure", Advancement.name(var3.iterator().next()), var1.iterator().next().getDisplayName()));
                }
                throw ERROR_NO_ACTION_PERFORMED.create((Object)Component.translatable(var2.getKey() + ".one.to.many.failure", Advancement.name(var3.iterator().next()), var1.size()));
            }
            if (var1.size() == 1) {
                throw ERROR_NO_ACTION_PERFORMED.create((Object)Component.translatable(var2.getKey() + ".many.to.one.failure", var3.size(), var1.iterator().next().getDisplayName()));
            }
            throw ERROR_NO_ACTION_PERFORMED.create((Object)Component.translatable(var2.getKey() + ".many.to.many.failure", var3.size(), var1.size()));
        }
        if (var3.size() == 1) {
            if (var1.size() == 1) {
                var0.sendSuccess(() -> Component.translatable(var2.getKey() + ".one.to.one.success", Advancement.name((AdvancementHolder)var3.iterator().next()), ((ServerPlayer)var1.iterator().next()).getDisplayName()), true);
            } else {
                var0.sendSuccess(() -> Component.translatable(var2.getKey() + ".one.to.many.success", Advancement.name((AdvancementHolder)var3.iterator().next()), var1.size()), true);
            }
        } else if (var1.size() == 1) {
            var0.sendSuccess(() -> Component.translatable(var2.getKey() + ".many.to.one.success", var3.size(), ((ServerPlayer)var1.iterator().next()).getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> Component.translatable(var2.getKey() + ".many.to.many.success", var3.size(), var1.size()), true);
        }
        return var5;
    }

    private static int performCriterion(CommandSourceStack var0, Collection<ServerPlayer> var1, Action var2, AdvancementHolder var3, String var4) throws CommandSyntaxException {
        int var5 = 0;
        Advancement var6 = var3.value();
        if (!var6.criteria().containsKey(var4)) {
            throw ERROR_CRITERION_NOT_FOUND.create((Object)Advancement.name(var3), (Object)var4);
        }
        for (ServerPlayer var8 : var1) {
            if (!var2.performCriterion(var8, var3, var4)) continue;
            ++var5;
        }
        if (var5 == 0) {
            if (var1.size() == 1) {
                throw ERROR_NO_ACTION_PERFORMED.create((Object)Component.translatable(var2.getKey() + ".criterion.to.one.failure", var4, Advancement.name(var3), var1.iterator().next().getDisplayName()));
            }
            throw ERROR_NO_ACTION_PERFORMED.create((Object)Component.translatable(var2.getKey() + ".criterion.to.many.failure", var4, Advancement.name(var3), var1.size()));
        }
        if (var1.size() == 1) {
            var0.sendSuccess(() -> Component.translatable(var2.getKey() + ".criterion.to.one.success", var4, Advancement.name(var3), ((ServerPlayer)var1.iterator().next()).getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> Component.translatable(var2.getKey() + ".criterion.to.many.success", var4, Advancement.name(var3), var1.size()), true);
        }
        return var5;
    }

    private static List<AdvancementHolder> getAdvancements(CommandContext<CommandSourceStack> var0, AdvancementHolder var1, Mode var2) {
        AdvancementTree var3 = ((CommandSourceStack)var0.getSource()).getServer().getAdvancements().tree();
        AdvancementNode var4 = var3.get(var1);
        if (var4 == null) {
            return List.of(var1);
        }
        ArrayList<AdvancementHolder> var5 = new ArrayList<AdvancementHolder>();
        if (var2.parents) {
            for (AdvancementNode var6 = var4.parent(); var6 != null; var6 = var6.parent()) {
                var5.add(var6.holder());
            }
        }
        var5.add(var1);
        if (var2.children) {
            AdvancementCommands.addChildren(var4, var5);
        }
        return var5;
    }

    private static void addChildren(AdvancementNode var0, List<AdvancementHolder> var1) {
        for (AdvancementNode var3 : var0.children()) {
            var1.add(var3.holder());
            AdvancementCommands.addChildren(var3, var1);
        }
    }

    static enum Action {
        GRANT("grant"){

            @Override
            protected boolean perform(ServerPlayer var0, AdvancementHolder var1) {
                AdvancementProgress var2 = var0.getAdvancements().getOrStartProgress(var1);
                if (var2.isDone()) {
                    return false;
                }
                for (String var4 : var2.getRemainingCriteria()) {
                    var0.getAdvancements().award(var1, var4);
                }
                return true;
            }

            @Override
            protected boolean performCriterion(ServerPlayer var0, AdvancementHolder var1, String var2) {
                return var0.getAdvancements().award(var1, var2);
            }
        }
        ,
        REVOKE("revoke"){

            @Override
            protected boolean perform(ServerPlayer var0, AdvancementHolder var1) {
                AdvancementProgress var2 = var0.getAdvancements().getOrStartProgress(var1);
                if (!var2.hasProgress()) {
                    return false;
                }
                for (String var4 : var2.getCompletedCriteria()) {
                    var0.getAdvancements().revoke(var1, var4);
                }
                return true;
            }

            @Override
            protected boolean performCriterion(ServerPlayer var0, AdvancementHolder var1, String var2) {
                return var0.getAdvancements().revoke(var1, var2);
            }
        };

        private final String key;

        Action(String var2) {
            this.key = "commands.advancement." + var2;
        }

        public int perform(ServerPlayer var0, Iterable<AdvancementHolder> var1, boolean var2) {
            int var3 = 0;
            if (!var2) {
                var0.getAdvancements().flushDirty(var0, true);
            }
            for (AdvancementHolder var5 : var1) {
                if (!this.perform(var0, var5)) continue;
                ++var3;
            }
            if (!var2) {
                var0.getAdvancements().flushDirty(var0, false);
            }
            return var3;
        }

        protected abstract boolean perform(ServerPlayer var1, AdvancementHolder var2);

        protected abstract boolean performCriterion(ServerPlayer var1, AdvancementHolder var2, String var3);

        protected String getKey() {
            return this.key;
        }
    }

    static enum Mode {
        ONLY(false, false),
        THROUGH(true, true),
        FROM(false, true),
        UNTIL(true, false),
        EVERYTHING(true, true);

        final boolean parents;
        final boolean children;

        private Mode(boolean var2, boolean var3) {
            this.parents = var2;
            this.children = var3;
        }
    }
}

