/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.UserBanList;
import net.minecraft.server.players.UserBanListEntry;

public class BanPlayerCommands {
    private static final SimpleCommandExceptionType ERROR_ALREADY_BANNED = new SimpleCommandExceptionType((Message)Component.translatable("commands.ban.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> var02) {
        var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("ban").requires(Commands.hasPermission(3))).then(((RequiredArgumentBuilder)Commands.argument("targets", GameProfileArgument.gameProfile()).executes(var0 -> BanPlayerCommands.banPlayers((CommandSourceStack)var0.getSource(), GameProfileArgument.getGameProfiles((CommandContext<CommandSourceStack>)var0, "targets"), null))).then(Commands.argument("reason", MessageArgument.message()).executes(var0 -> BanPlayerCommands.banPlayers((CommandSourceStack)var0.getSource(), GameProfileArgument.getGameProfiles((CommandContext<CommandSourceStack>)var0, "targets"), MessageArgument.getMessage((CommandContext<CommandSourceStack>)var0, "reason")))))));
    }

    private static int banPlayers(CommandSourceStack var0, Collection<GameProfile> var1, @Nullable Component var2) throws CommandSyntaxException {
        UserBanList var3 = var0.getServer().getPlayerList().getBans();
        int var4 = 0;
        for (GameProfile var6 : var1) {
            if (var3.isBanned(var6)) continue;
            UserBanListEntry var7 = new UserBanListEntry(var6, null, var0.getTextName(), null, var2 == null ? null : var2.getString());
            var3.add(var7);
            ++var4;
            var0.sendSuccess(() -> Component.translatable("commands.ban.success", Component.literal(var6.getName()), var7.getReason()), true);
            ServerPlayer var8 = var0.getServer().getPlayerList().getPlayer(var6.getId());
            if (var8 == null) continue;
            var8.connection.disconnect(Component.translatable("multiplayer.disconnect.banned"));
        }
        if (var4 == 0) {
            throw ERROR_ALREADY_BANNED.create();
        }
        return var4;
    }
}

