/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.item.ItemPredicateArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class ClearInventoryCommands {
    private static final DynamicCommandExceptionType ERROR_SINGLE = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("clear.failed.single", var0));
    private static final DynamicCommandExceptionType ERROR_MULTIPLE = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("clear.failed.multiple", var0));

    public static void register(CommandDispatcher<CommandSourceStack> var03, CommandBuildContext var1) {
        var03.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("clear").requires(Commands.hasPermission(2))).executes(var02 -> ClearInventoryCommands.clearUnlimited((CommandSourceStack)var02.getSource(), Collections.singleton(((CommandSourceStack)var02.getSource()).getPlayerOrException()), var0 -> true))).then(((RequiredArgumentBuilder)Commands.argument("targets", EntityArgument.players()).executes(var02 -> ClearInventoryCommands.clearUnlimited((CommandSourceStack)var02.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)var02, "targets"), var0 -> true))).then(((RequiredArgumentBuilder)Commands.argument("item", ItemPredicateArgument.itemPredicate(var1)).executes(var0 -> ClearInventoryCommands.clearUnlimited((CommandSourceStack)var0.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)var0, "targets"), ItemPredicateArgument.getItemPredicate((CommandContext<CommandSourceStack>)var0, "item")))).then(Commands.argument("maxCount", IntegerArgumentType.integer((int)0)).executes(var0 -> ClearInventoryCommands.clearInventory((CommandSourceStack)var0.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)var0, "targets"), ItemPredicateArgument.getItemPredicate((CommandContext<CommandSourceStack>)var0, "item"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"maxCount"))))))));
    }

    private static int clearUnlimited(CommandSourceStack var0, Collection<ServerPlayer> var1, Predicate<ItemStack> var2) throws CommandSyntaxException {
        return ClearInventoryCommands.clearInventory(var0, var1, var2, -1);
    }

    private static int clearInventory(CommandSourceStack var0, Collection<ServerPlayer> var1, Predicate<ItemStack> var2, int var3) throws CommandSyntaxException {
        int var4 = 0;
        for (ServerPlayer var6 : var1) {
            var4 += var6.getInventory().clearOrCountMatchingItems(var2, var3, var6.inventoryMenu.getCraftSlots());
            var6.containerMenu.broadcastChanges();
            var6.inventoryMenu.slotsChanged(var6.getInventory());
        }
        if (var4 == 0) {
            if (var1.size() == 1) {
                throw ERROR_SINGLE.create((Object)var1.iterator().next().getName());
            }
            throw ERROR_MULTIPLE.create((Object)var1.size());
        }
        int var5 = var4;
        if (var3 == 0) {
            if (var1.size() == 1) {
                var0.sendSuccess(() -> Component.translatable("commands.clear.test.single", var5, ((ServerPlayer)var1.iterator().next()).getDisplayName()), true);
            } else {
                var0.sendSuccess(() -> Component.translatable("commands.clear.test.multiple", var5, var1.size()), true);
            }
        } else if (var1.size() == 1) {
            var0.sendSuccess(() -> Component.translatable("commands.clear.success.single", var5, ((ServerPlayer)var1.iterator().next()).getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> Component.translatable("commands.clear.success.multiple", var5, var1.size()), true);
        }
        return var4;
    }
}

