/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.players.PlayerList;

public class OpCommand {
    private static final SimpleCommandExceptionType ERROR_ALREADY_OP = new SimpleCommandExceptionType((Message)Component.translatable("commands.op.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> var03) {
        var03.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("op").requires(Commands.hasPermission(3))).then(Commands.argument("targets", GameProfileArgument.gameProfile()).suggests((var02, var12) -> {
            PlayerList var2 = ((CommandSourceStack)var02.getSource()).getServer().getPlayerList();
            return SharedSuggestionProvider.suggest(var2.getPlayers().stream().filter(var1 -> !var2.isOp(var1.getGameProfile())).map(var0 -> var0.getGameProfile().getName()), var12);
        }).executes(var0 -> OpCommand.opPlayers((CommandSourceStack)var0.getSource(), GameProfileArgument.getGameProfiles((CommandContext<CommandSourceStack>)var0, "targets"))))));
    }

    private static int opPlayers(CommandSourceStack var0, Collection<GameProfile> var1) throws CommandSyntaxException {
        PlayerList var2 = var0.getServer().getPlayerList();
        int var3 = 0;
        for (GameProfile var5 : var1) {
            if (var2.isOp(var5)) continue;
            var2.op(var5);
            ++var3;
            var0.sendSuccess(() -> Component.translatable("commands.op.success", var5.getName()), true);
        }
        if (var3 == 0) {
            throw ERROR_ALREADY_OP.create();
        }
        return var3;
    }
}

