/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.RangeArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.RandomSequences;

public class RandomCommand {
    private static final SimpleCommandExceptionType ERROR_RANGE_TOO_LARGE = new SimpleCommandExceptionType((Message)Component.translatable("commands.random.error.range_too_large"));
    private static final SimpleCommandExceptionType ERROR_RANGE_TOO_SMALL = new SimpleCommandExceptionType((Message)Component.translatable("commands.random.error.range_too_small"));

    public static void register(CommandDispatcher<CommandSourceStack> var02) {
        var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("random").then(RandomCommand.drawRandomValueTree("value", false))).then(RandomCommand.drawRandomValueTree("roll", true))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("reset").requires(Commands.hasPermission(2))).then(((LiteralArgumentBuilder)Commands.literal("*").executes(var0 -> RandomCommand.resetAllSequences((CommandSourceStack)var0.getSource()))).then(((RequiredArgumentBuilder)Commands.argument("seed", IntegerArgumentType.integer()).executes(var0 -> RandomCommand.resetAllSequencesAndSetNewDefaults((CommandSourceStack)var0.getSource(), IntegerArgumentType.getInteger((CommandContext)var0, (String)"seed"), true, true))).then(((RequiredArgumentBuilder)Commands.argument("includeWorldSeed", BoolArgumentType.bool()).executes(var0 -> RandomCommand.resetAllSequencesAndSetNewDefaults((CommandSourceStack)var0.getSource(), IntegerArgumentType.getInteger((CommandContext)var0, (String)"seed"), BoolArgumentType.getBool((CommandContext)var0, (String)"includeWorldSeed"), true))).then(Commands.argument("includeSequenceId", BoolArgumentType.bool()).executes(var0 -> RandomCommand.resetAllSequencesAndSetNewDefaults((CommandSourceStack)var0.getSource(), IntegerArgumentType.getInteger((CommandContext)var0, (String)"seed"), BoolArgumentType.getBool((CommandContext)var0, (String)"includeWorldSeed"), BoolArgumentType.getBool((CommandContext)var0, (String)"includeSequenceId")))))))).then(((RequiredArgumentBuilder)Commands.argument("sequence", ResourceLocationArgument.id()).suggests(RandomCommand::suggestRandomSequence).executes(var0 -> RandomCommand.resetSequence((CommandSourceStack)var0.getSource(), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)var0, "sequence")))).then(((RequiredArgumentBuilder)Commands.argument("seed", IntegerArgumentType.integer()).executes(var0 -> RandomCommand.resetSequence((CommandSourceStack)var0.getSource(), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)var0, "sequence"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"seed"), true, true))).then(((RequiredArgumentBuilder)Commands.argument("includeWorldSeed", BoolArgumentType.bool()).executes(var0 -> RandomCommand.resetSequence((CommandSourceStack)var0.getSource(), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)var0, "sequence"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"seed"), BoolArgumentType.getBool((CommandContext)var0, (String)"includeWorldSeed"), true))).then(Commands.argument("includeSequenceId", BoolArgumentType.bool()).executes(var0 -> RandomCommand.resetSequence((CommandSourceStack)var0.getSource(), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)var0, "sequence"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"seed"), BoolArgumentType.getBool((CommandContext)var0, (String)"includeWorldSeed"), BoolArgumentType.getBool((CommandContext)var0, (String)"includeSequenceId"))))))))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> drawRandomValueTree(String var0, boolean var12) {
        return (LiteralArgumentBuilder)Commands.literal(var0).then(((RequiredArgumentBuilder)Commands.argument("range", RangeArgument.intRange()).executes(var1 -> RandomCommand.randomSample((CommandSourceStack)var1.getSource(), RangeArgument.Ints.getRange((CommandContext<CommandSourceStack>)var1, "range"), null, var12))).then(((RequiredArgumentBuilder)Commands.argument("sequence", ResourceLocationArgument.id()).suggests(RandomCommand::suggestRandomSequence).requires(Commands.hasPermission(2))).executes(var1 -> RandomCommand.randomSample((CommandSourceStack)var1.getSource(), RangeArgument.Ints.getRange((CommandContext<CommandSourceStack>)var1, "range"), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)var1, "sequence"), var12))));
    }

    private static CompletableFuture<Suggestions> suggestRandomSequence(CommandContext<CommandSourceStack> var0, SuggestionsBuilder var12) {
        ArrayList var22 = Lists.newArrayList();
        ((CommandSourceStack)var0.getSource()).getLevel().getRandomSequences().forAllSequences((var1, var2) -> var22.add(var1.toString()));
        return SharedSuggestionProvider.suggest(var22, var12);
    }

    private static int randomSample(CommandSourceStack var0, MinMaxBounds.Ints var1, @Nullable ResourceLocation var2, boolean var3) throws CommandSyntaxException {
        RandomSource var4 = var2 != null ? var0.getLevel().getRandomSequence(var2) : var0.getLevel().getRandom();
        int var5 = var1.min().orElse(Integer.MIN_VALUE);
        int var6 = var1.max().orElse(Integer.MAX_VALUE);
        long var7 = (long)var6 - (long)var5;
        if (var7 == 0L) {
            throw ERROR_RANGE_TOO_SMALL.create();
        }
        if (var7 >= Integer.MAX_VALUE) {
            throw ERROR_RANGE_TOO_LARGE.create();
        }
        int var9 = Mth.randomBetweenInclusive(var4, var5, var6);
        if (var3) {
            var0.getServer().getPlayerList().broadcastSystemMessage(Component.translatable("commands.random.roll", var0.getDisplayName(), var9, var5, var6), false);
        } else {
            var0.sendSuccess(() -> Component.translatable("commands.random.sample.success", var9), false);
        }
        return var9;
    }

    private static int resetSequence(CommandSourceStack var0, ResourceLocation var1) throws CommandSyntaxException {
        var0.getLevel().getRandomSequences().reset(var1);
        var0.sendSuccess(() -> Component.translatable("commands.random.reset.success", Component.translationArg(var1)), false);
        return 1;
    }

    private static int resetSequence(CommandSourceStack var0, ResourceLocation var1, int var2, boolean var3, boolean var4) throws CommandSyntaxException {
        var0.getLevel().getRandomSequences().reset(var1, var2, var3, var4);
        var0.sendSuccess(() -> Component.translatable("commands.random.reset.success", Component.translationArg(var1)), false);
        return 1;
    }

    private static int resetAllSequences(CommandSourceStack var0) {
        int var1 = var0.getLevel().getRandomSequences().clear();
        var0.sendSuccess(() -> Component.translatable("commands.random.reset.all.success", var1), false);
        return var1;
    }

    private static int resetAllSequencesAndSetNewDefaults(CommandSourceStack var0, int var1, boolean var2, boolean var3) {
        RandomSequences var4 = var0.getLevel().getRandomSequences();
        var4.setSeedDefaults(var1, var2, var3);
        int var5 = var4.clear();
        var0.sendSuccess(() -> Component.translatable("commands.random.reset.all.success", var5), false);
        return var5;
    }
}

