/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.world.level.storage.WorldData;
import org.slf4j.Logger;

public class ReloadCommand {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void reloadPacks(Collection<String> collection, CommandSourceStack commandlistenerwrapper) {
        commandlistenerwrapper.getServer().reloadResources(collection).exceptionally(throwable -> {
            LOGGER.warn("Failed to execute reload", throwable);
            commandlistenerwrapper.sendFailure(Component.translatable("commands.reload.failure"));
            return null;
        });
    }

    private static Collection<String> discoverNewPacks(PackRepository resourcepackrepository, WorldData savedata, Collection<String> collection) {
        resourcepackrepository.reload();
        ArrayList collection1 = Lists.newArrayList(collection);
        List<String> collection2 = savedata.getDataConfiguration().dataPacks().getDisabled();
        for (String s : resourcepackrepository.getAvailableIds()) {
            if (collection2.contains(s) || collection1.contains(s)) continue;
            collection1.add(s);
        }
        return collection1;
    }

    public static void reload(MinecraftServer minecraftserver) {
        PackRepository resourcepackrepository = minecraftserver.getPackRepository();
        WorldData savedata = minecraftserver.getWorldData();
        Collection<String> collection = resourcepackrepository.getSelectedIds();
        Collection<String> collection1 = ReloadCommand.discoverNewPacks(resourcepackrepository, savedata, collection);
        minecraftserver.reloadResources(collection1);
    }

    public static void register(CommandDispatcher<CommandSourceStack> commanddispatcher) {
        commanddispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("reload").requires(Commands.hasPermission(2))).executes(commandcontext -> {
            CommandSourceStack commandlistenerwrapper = (CommandSourceStack)commandcontext.getSource();
            MinecraftServer minecraftserver = commandlistenerwrapper.getServer();
            PackRepository resourcepackrepository = minecraftserver.getPackRepository();
            WorldData savedata = minecraftserver.getWorldData();
            Collection<String> collection = resourcepackrepository.getSelectedIds();
            Collection<String> collection1 = ReloadCommand.discoverNewPacks(resourcepackrepository, savedata, collection);
            commandlistenerwrapper.sendSuccess(() -> Component.translatable("commands.reload.success"), true);
            ReloadCommand.reloadPacks(collection1, commandlistenerwrapper);
            return 0;
        })));
    }
}

