/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundResourcePackPopPacket;
import net.minecraft.network.protocol.common.ClientboundResourcePackPushPacket;

public class ServerPackCommand {
    public static void register(CommandDispatcher<CommandSourceStack> var02) {
        var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("serverpack").requires(Commands.hasPermission(2))).then(Commands.literal("push").then(((RequiredArgumentBuilder)Commands.argument("url", StringArgumentType.string()).then(((RequiredArgumentBuilder)Commands.argument("uuid", UuidArgument.uuid()).then(Commands.argument("hash", StringArgumentType.word()).executes(var0 -> ServerPackCommand.pushPack((CommandSourceStack)var0.getSource(), StringArgumentType.getString((CommandContext)var0, (String)"url"), Optional.of(UuidArgument.getUuid((CommandContext<CommandSourceStack>)var0, "uuid")), Optional.of(StringArgumentType.getString((CommandContext)var0, (String)"hash")))))).executes(var0 -> ServerPackCommand.pushPack((CommandSourceStack)var0.getSource(), StringArgumentType.getString((CommandContext)var0, (String)"url"), Optional.of(UuidArgument.getUuid((CommandContext<CommandSourceStack>)var0, "uuid")), Optional.empty())))).executes(var0 -> ServerPackCommand.pushPack((CommandSourceStack)var0.getSource(), StringArgumentType.getString((CommandContext)var0, (String)"url"), Optional.empty(), Optional.empty()))))).then(Commands.literal("pop").then(Commands.argument("uuid", UuidArgument.uuid()).executes(var0 -> ServerPackCommand.popPack((CommandSourceStack)var0.getSource(), UuidArgument.getUuid((CommandContext<CommandSourceStack>)var0, "uuid")))))));
    }

    private static void sendToAllConnections(CommandSourceStack var0, Packet<?> var12) {
        var0.getServer().getConnection().getConnections().forEach(var1 -> var1.send(var12));
    }

    private static int pushPack(CommandSourceStack var0, String var1, Optional<UUID> var2, Optional<String> var3) {
        UUID var4 = var2.orElseGet(() -> UUID.nameUUIDFromBytes(var1.getBytes(StandardCharsets.UTF_8)));
        String var5 = var3.orElse("");
        ClientboundResourcePackPushPacket var6 = new ClientboundResourcePackPushPacket(var4, var1, var5, false, null);
        ServerPackCommand.sendToAllConnections(var0, var6);
        return 0;
    }

    private static int popPack(CommandSourceStack var0, UUID var1) {
        ClientboundResourcePackPopPacket var2 = new ClientboundResourcePackPopPacket(Optional.of(var1));
        ServerPackCommand.sendToAllConnections(var0, var2);
        return 0;
    }
}

