/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.AngleArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import org.bukkit.event.player.PlayerSpawnChangeEvent;

public class SetSpawnCommand {
    public static void register(CommandDispatcher<CommandSourceStack> commanddispatcher) {
        commanddispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("spawnpoint").requires(Commands.hasPermission(2))).executes(commandcontext -> SetSpawnCommand.setSpawn((CommandSourceStack)commandcontext.getSource(), Collections.singleton(((CommandSourceStack)commandcontext.getSource()).getPlayerOrException()), BlockPos.containing(((CommandSourceStack)commandcontext.getSource()).getPosition()), 0.0f))).then(((RequiredArgumentBuilder)Commands.argument("targets", EntityArgument.players()).executes(commandcontext -> SetSpawnCommand.setSpawn((CommandSourceStack)commandcontext.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)commandcontext, "targets"), BlockPos.containing(((CommandSourceStack)commandcontext.getSource()).getPosition()), 0.0f))).then(((RequiredArgumentBuilder)Commands.argument("pos", BlockPosArgument.blockPos()).executes(commandcontext -> SetSpawnCommand.setSpawn((CommandSourceStack)commandcontext.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)commandcontext, "targets"), BlockPosArgument.getSpawnablePos((CommandContext<CommandSourceStack>)commandcontext, "pos"), 0.0f))).then(Commands.argument("angle", AngleArgument.angle()).executes(commandcontext -> SetSpawnCommand.setSpawn((CommandSourceStack)commandcontext.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)commandcontext, "targets"), BlockPosArgument.getSpawnablePos((CommandContext<CommandSourceStack>)commandcontext, "pos"), AngleArgument.getAngle((CommandContext<CommandSourceStack>)commandcontext, "angle"))))))));
    }

    private static int setSpawn(CommandSourceStack commandlistenerwrapper, Collection<ServerPlayer> collection, BlockPos blockposition, float f) {
        ResourceKey<Level> resourcekey = commandlistenerwrapper.getLevel().dimension();
        for (ServerPlayer entityplayer : collection) {
            entityplayer.setRespawnPosition(new ServerPlayer.RespawnConfig(resourcekey, blockposition, f, true), false, PlayerSpawnChangeEvent.Cause.COMMAND);
        }
        String s = resourcekey.location().toString();
        if (collection.size() == 1) {
            commandlistenerwrapper.sendSuccess(() -> Component.translatable("commands.spawnpoint.success.single", blockposition.getX(), blockposition.getY(), blockposition.getZ(), Float.valueOf(f), s, ((ServerPlayer)collection.iterator().next()).getDisplayName()), true);
        } else {
            commandlistenerwrapper.sendSuccess(() -> Component.translatable("commands.spawnpoint.success.multiple", blockposition.getX(), blockposition.getY(), blockposition.getZ(), Float.valueOf(f), s, collection.size()), true);
        }
        return collection.size();
    }
}

