/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.AngleArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;

public class SetWorldSpawnCommand {
    public static void register(CommandDispatcher<CommandSourceStack> commanddispatcher) {
        commanddispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("setworldspawn").requires(Commands.hasPermission(2))).executes(commandcontext -> SetWorldSpawnCommand.setSpawn((CommandSourceStack)commandcontext.getSource(), BlockPos.containing(((CommandSourceStack)commandcontext.getSource()).getPosition()), 0.0f))).then(((RequiredArgumentBuilder)Commands.argument("pos", BlockPosArgument.blockPos()).executes(commandcontext -> SetWorldSpawnCommand.setSpawn((CommandSourceStack)commandcontext.getSource(), BlockPosArgument.getSpawnablePos((CommandContext<CommandSourceStack>)commandcontext, "pos"), 0.0f))).then(Commands.argument("angle", AngleArgument.angle()).executes(commandcontext -> SetWorldSpawnCommand.setSpawn((CommandSourceStack)commandcontext.getSource(), BlockPosArgument.getSpawnablePos((CommandContext<CommandSourceStack>)commandcontext, "pos"), AngleArgument.getAngle((CommandContext<CommandSourceStack>)commandcontext, "angle")))))));
    }

    private static int setSpawn(CommandSourceStack commandlistenerwrapper, BlockPos blockposition, float f) {
        ServerLevel worldserver = commandlistenerwrapper.getLevel();
        worldserver.setDefaultSpawnPos(blockposition, f);
        commandlistenerwrapper.sendSuccess(() -> Component.translatable("commands.setworldspawn.success", blockposition.getX(), blockposition.getY(), blockposition.getZ(), Float.valueOf(f)), true);
        return 1;
    }
}

