/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic4CommandExceptionType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.Vec2Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.scores.PlayerTeam;
import org.bukkit.event.player.PlayerTeleportEvent;

public class SpreadPlayersCommand {
    private static final int MAX_ITERATION_COUNT = 10000;
    private static final Dynamic4CommandExceptionType ERROR_FAILED_TO_SPREAD_TEAMS = new Dynamic4CommandExceptionType((object, object1, object2, object3) -> Component.translatableEscape("commands.spreadplayers.failed.teams", object, object1, object2, object3));
    private static final Dynamic4CommandExceptionType ERROR_FAILED_TO_SPREAD_ENTITIES = new Dynamic4CommandExceptionType((object, object1, object2, object3) -> Component.translatableEscape("commands.spreadplayers.failed.entities", object, object1, object2, object3));
    private static final Dynamic2CommandExceptionType ERROR_INVALID_MAX_HEIGHT = new Dynamic2CommandExceptionType((object, object1) -> Component.translatableEscape("commands.spreadplayers.failed.invalid.height", object, object1));

    public static void register(CommandDispatcher<CommandSourceStack> commanddispatcher) {
        commanddispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("spreadplayers").requires(Commands.hasPermission(2))).then(Commands.argument("center", Vec2Argument.vec2()).then(Commands.argument("spreadDistance", FloatArgumentType.floatArg((float)0.0f)).then(((RequiredArgumentBuilder)Commands.argument("maxRange", FloatArgumentType.floatArg((float)1.0f)).then(Commands.argument("respectTeams", BoolArgumentType.bool()).then(Commands.argument("targets", EntityArgument.entities()).executes(commandcontext -> SpreadPlayersCommand.spreadPlayers((CommandSourceStack)commandcontext.getSource(), Vec2Argument.getVec2((CommandContext<CommandSourceStack>)commandcontext, "center"), FloatArgumentType.getFloat((CommandContext)commandcontext, (String)"spreadDistance"), FloatArgumentType.getFloat((CommandContext)commandcontext, (String)"maxRange"), ((CommandSourceStack)commandcontext.getSource()).getLevel().getMaxY() + 1, BoolArgumentType.getBool((CommandContext)commandcontext, (String)"respectTeams"), EntityArgument.getEntities((CommandContext<CommandSourceStack>)commandcontext, "targets")))))).then(Commands.literal("under").then(Commands.argument("maxHeight", IntegerArgumentType.integer()).then(Commands.argument("respectTeams", BoolArgumentType.bool()).then(Commands.argument("targets", EntityArgument.entities()).executes(commandcontext -> SpreadPlayersCommand.spreadPlayers((CommandSourceStack)commandcontext.getSource(), Vec2Argument.getVec2((CommandContext<CommandSourceStack>)commandcontext, "center"), FloatArgumentType.getFloat((CommandContext)commandcontext, (String)"spreadDistance"), FloatArgumentType.getFloat((CommandContext)commandcontext, (String)"maxRange"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"maxHeight"), BoolArgumentType.getBool((CommandContext)commandcontext, (String)"respectTeams"), EntityArgument.getEntities((CommandContext<CommandSourceStack>)commandcontext, "targets"))))))))))));
    }

    private static int spreadPlayers(CommandSourceStack commandlistenerwrapper, Vec2 vec2f, float f, float f1, int i, boolean flag, Collection<? extends Entity> collection) throws CommandSyntaxException {
        ServerLevel worldserver = commandlistenerwrapper.getLevel();
        int j = worldserver.getMinY();
        if (i < j) {
            throw ERROR_INVALID_MAX_HEIGHT.create((Object)i, (Object)j);
        }
        RandomSource randomsource = RandomSource.create();
        double d0 = vec2f.x - f1;
        double d1 = vec2f.y - f1;
        double d2 = vec2f.x + f1;
        double d3 = vec2f.y + f1;
        Position[] acommandspreadplayers_a = SpreadPlayersCommand.createInitialPositions(randomsource, flag ? SpreadPlayersCommand.getNumberOfTeams(collection) : collection.size(), d0, d1, d2, d3);
        SpreadPlayersCommand.spreadPositions(vec2f, f, worldserver, randomsource, d0, d1, d2, d3, i, acommandspreadplayers_a, flag);
        double d4 = SpreadPlayersCommand.setPlayerPositions(collection, worldserver, acommandspreadplayers_a, i, flag);
        commandlistenerwrapper.sendSuccess(() -> Component.translatable("commands.spreadplayers.success." + (flag ? "teams" : "entities"), acommandspreadplayers_a.length, Float.valueOf(vec2f.x), Float.valueOf(vec2f.y), String.format(Locale.ROOT, "%.2f", d4)), true);
        return acommandspreadplayers_a.length;
    }

    private static int getNumberOfTeams(Collection<? extends Entity> collection) {
        HashSet set = Sets.newHashSet();
        for (Entity entity : collection) {
            if (entity instanceof Player) {
                set.add(entity.getTeam());
                continue;
            }
            set.add(null);
        }
        return set.size();
    }

    private static void spreadPositions(Vec2 vec2f, double d0, ServerLevel worldserver, RandomSource randomsource, double d1, double d2, double d3, double d4, int i, Position[] acommandspreadplayers_a, boolean flag) throws CommandSyntaxException {
        int j;
        boolean flag1 = true;
        double d5 = 3.4028234663852886E38;
        for (j = 0; j < 10000 && flag1; ++j) {
            flag1 = false;
            d5 = 3.4028234663852886E38;
            for (int k = 0; k < acommandspreadplayers_a.length; ++k) {
                Position commandspreadplayers_a = acommandspreadplayers_a[k];
                int l = 0;
                Position commandspreadplayers_a1 = new Position();
                for (int i1 = 0; i1 < acommandspreadplayers_a.length; ++i1) {
                    if (k == i1) continue;
                    Position commandspreadplayers_a2 = acommandspreadplayers_a[i1];
                    double d6 = commandspreadplayers_a.dist(commandspreadplayers_a2);
                    d5 = Math.min(d6, d5);
                    if (!(d6 < d0)) continue;
                    ++l;
                    commandspreadplayers_a1.x += commandspreadplayers_a2.x - commandspreadplayers_a.x;
                    commandspreadplayers_a1.z += commandspreadplayers_a2.z - commandspreadplayers_a.z;
                }
                if (l > 0) {
                    commandspreadplayers_a1.x /= (double)l;
                    commandspreadplayers_a1.z /= (double)l;
                    double d7 = commandspreadplayers_a1.getLength();
                    if (d7 > 0.0) {
                        commandspreadplayers_a1.normalize();
                        commandspreadplayers_a.moveAway(commandspreadplayers_a1);
                    } else {
                        commandspreadplayers_a.randomize(randomsource, d1, d2, d3, d4);
                    }
                    flag1 = true;
                }
                if (!commandspreadplayers_a.clamp(d1, d2, d3, d4)) continue;
                flag1 = true;
            }
            if (flag1) continue;
            for (Position commandspreadplayers_a3 : acommandspreadplayers_a) {
                if (commandspreadplayers_a3.isSafe(worldserver, i)) continue;
                commandspreadplayers_a3.randomize(randomsource, d1, d2, d3, d4);
                flag1 = true;
            }
        }
        if (d5 == 3.4028234663852886E38) {
            d5 = 0.0;
        }
        if (j >= 10000) {
            if (flag) {
                throw ERROR_FAILED_TO_SPREAD_TEAMS.create((Object)acommandspreadplayers_a.length, (Object)Float.valueOf(vec2f.x), (Object)Float.valueOf(vec2f.y), (Object)String.format(Locale.ROOT, "%.2f", d5));
            }
            throw ERROR_FAILED_TO_SPREAD_ENTITIES.create((Object)acommandspreadplayers_a.length, (Object)Float.valueOf(vec2f.x), (Object)Float.valueOf(vec2f.y), (Object)String.format(Locale.ROOT, "%.2f", d5));
        }
    }

    private static double setPlayerPositions(Collection<? extends Entity> collection, ServerLevel worldserver, Position[] acommandspreadplayers_a, int i, boolean flag) {
        double d0 = 0.0;
        int j = 0;
        HashMap map = Maps.newHashMap();
        for (Entity entity : collection) {
            Position commandspreadplayers_a;
            if (flag) {
                PlayerTeam scoreboardteambase;
                PlayerTeam playerTeam = scoreboardteambase = entity instanceof Player ? entity.getTeam() : null;
                if (!map.containsKey(scoreboardteambase)) {
                    map.put(scoreboardteambase, acommandspreadplayers_a[j++]);
                }
                commandspreadplayers_a = (Position)map.get(scoreboardteambase);
            } else {
                commandspreadplayers_a = acommandspreadplayers_a[j++];
            }
            entity.teleportTo(worldserver, (double)Mth.floor(commandspreadplayers_a.x) + 0.5, commandspreadplayers_a.getSpawnY(worldserver, i), (double)Mth.floor(commandspreadplayers_a.z) + 0.5, Set.of(), entity.getYRot(), entity.getXRot(), true, PlayerTeleportEvent.TeleportCause.COMMAND);
            double d1 = Double.MAX_VALUE;
            for (Position commandspreadplayers_a1 : acommandspreadplayers_a) {
                if (commandspreadplayers_a == commandspreadplayers_a1) continue;
                double d2 = commandspreadplayers_a.dist(commandspreadplayers_a1);
                d1 = Math.min(d2, d1);
            }
            d0 += d1;
        }
        if (collection.size() < 2) {
            return 0.0;
        }
        return d0 /= (double)collection.size();
    }

    private static Position[] createInitialPositions(RandomSource randomsource, int i, double d0, double d1, double d2, double d3) {
        Position[] acommandspreadplayers_a = new Position[i];
        for (int j = 0; j < acommandspreadplayers_a.length; ++j) {
            Position commandspreadplayers_a = new Position();
            commandspreadplayers_a.randomize(randomsource, d0, d1, d2, d3);
            acommandspreadplayers_a[j] = commandspreadplayers_a;
        }
        return acommandspreadplayers_a;
    }

    private static class Position {
        double x;
        double z;

        Position() {
        }

        double dist(Position commandspreadplayers_a) {
            double d0 = this.x - commandspreadplayers_a.x;
            double d1 = this.z - commandspreadplayers_a.z;
            return Math.sqrt(d0 * d0 + d1 * d1);
        }

        void normalize() {
            double d0 = this.getLength();
            this.x /= d0;
            this.z /= d0;
        }

        double getLength() {
            return Math.sqrt(this.x * this.x + this.z * this.z);
        }

        public void moveAway(Position commandspreadplayers_a) {
            this.x -= commandspreadplayers_a.x;
            this.z -= commandspreadplayers_a.z;
        }

        public boolean clamp(double d0, double d1, double d2, double d3) {
            boolean flag = false;
            if (this.x < d0) {
                this.x = d0;
                flag = true;
            } else if (this.x > d2) {
                this.x = d2;
                flag = true;
            }
            if (this.z < d1) {
                this.z = d1;
                flag = true;
            } else if (this.z > d3) {
                this.z = d3;
                flag = true;
            }
            return flag;
        }

        public int getSpawnY(BlockGetter iblockaccess, int i) {
            BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos(this.x, (double)(i + 1), this.z);
            boolean flag = iblockaccess.getBlockState(blockposition_mutableblockposition).isAir();
            blockposition_mutableblockposition.move(Direction.DOWN);
            boolean flag2 = iblockaccess.getBlockState(blockposition_mutableblockposition).isAir();
            while (blockposition_mutableblockposition.getY() > iblockaccess.getMinY()) {
                blockposition_mutableblockposition.move(Direction.DOWN);
                boolean flag1 = iblockaccess.getBlockState(blockposition_mutableblockposition).isAir();
                if (!flag1 && flag2 && flag) {
                    return blockposition_mutableblockposition.getY() + 1;
                }
                flag = flag2;
                flag2 = flag1;
            }
            return i + 1;
        }

        public boolean isSafe(BlockGetter iblockaccess, int i) {
            BlockPos blockposition = BlockPos.containing(this.x, this.getSpawnY(iblockaccess, i) - 1, this.z);
            BlockState iblockdata = iblockaccess.getBlockState(blockposition);
            return blockposition.getY() < i && !iblockdata.liquid() && !iblockdata.is(BlockTags.FIRE);
        }

        public void randomize(RandomSource randomsource, double d0, double d1, double d2, double d3) {
            this.x = Mth.nextDouble(randomsource, d0, d2);
            this.z = Mth.nextDouble(randomsource, d1, d3);
        }
    }
}

