/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.UserWhiteList;
import net.minecraft.server.players.UserWhiteListEntry;

public class WhitelistCommand {
    private static final SimpleCommandExceptionType ERROR_ALREADY_ENABLED = new SimpleCommandExceptionType((Message)Component.translatable("commands.whitelist.alreadyOn"));
    private static final SimpleCommandExceptionType ERROR_ALREADY_DISABLED = new SimpleCommandExceptionType((Message)Component.translatable("commands.whitelist.alreadyOff"));
    private static final SimpleCommandExceptionType ERROR_ALREADY_WHITELISTED = new SimpleCommandExceptionType((Message)Component.translatable("commands.whitelist.add.failed"));
    private static final SimpleCommandExceptionType ERROR_NOT_WHITELISTED = new SimpleCommandExceptionType((Message)Component.translatable("commands.whitelist.remove.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> var03) {
        var03.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("whitelist").requires(Commands.hasPermission(3))).then(Commands.literal("on").executes(var0 -> WhitelistCommand.enableWhitelist((CommandSourceStack)var0.getSource())))).then(Commands.literal("off").executes(var0 -> WhitelistCommand.disableWhitelist((CommandSourceStack)var0.getSource())))).then(Commands.literal("list").executes(var0 -> WhitelistCommand.showList((CommandSourceStack)var0.getSource())))).then(Commands.literal("add").then(Commands.argument("targets", GameProfileArgument.gameProfile()).suggests((var02, var12) -> {
            PlayerList var2 = ((CommandSourceStack)var02.getSource()).getServer().getPlayerList();
            return SharedSuggestionProvider.suggest(var2.getPlayers().stream().filter(var1 -> !var2.getWhiteList().isWhiteListed(var1.getGameProfile())).map(var0 -> var0.getGameProfile().getName()), var12);
        }).executes(var0 -> WhitelistCommand.addPlayers((CommandSourceStack)var0.getSource(), GameProfileArgument.getGameProfiles((CommandContext<CommandSourceStack>)var0, "targets")))))).then(Commands.literal("remove").then(Commands.argument("targets", GameProfileArgument.gameProfile()).suggests((var0, var1) -> SharedSuggestionProvider.suggest(((CommandSourceStack)var0.getSource()).getServer().getPlayerList().getWhiteListNames(), var1)).executes(var0 -> WhitelistCommand.removePlayers((CommandSourceStack)var0.getSource(), GameProfileArgument.getGameProfiles((CommandContext<CommandSourceStack>)var0, "targets")))))).then(Commands.literal("reload").executes(var0 -> WhitelistCommand.reload((CommandSourceStack)var0.getSource())))));
    }

    private static int reload(CommandSourceStack var0) {
        var0.getServer().getPlayerList().reloadWhiteList();
        var0.sendSuccess(() -> Component.translatable("commands.whitelist.reloaded"), true);
        var0.getServer().kickUnlistedPlayers(var0);
        return 1;
    }

    private static int addPlayers(CommandSourceStack var0, Collection<GameProfile> var1) throws CommandSyntaxException {
        UserWhiteList var2 = var0.getServer().getPlayerList().getWhiteList();
        int var3 = 0;
        for (GameProfile var5 : var1) {
            if (var2.isWhiteListed(var5)) continue;
            UserWhiteListEntry var6 = new UserWhiteListEntry(var5);
            var2.add(var6);
            var0.sendSuccess(() -> Component.translatable("commands.whitelist.add.success", Component.literal(var5.getName())), true);
            ++var3;
        }
        if (var3 == 0) {
            throw ERROR_ALREADY_WHITELISTED.create();
        }
        return var3;
    }

    private static int removePlayers(CommandSourceStack var0, Collection<GameProfile> var1) throws CommandSyntaxException {
        UserWhiteList var2 = var0.getServer().getPlayerList().getWhiteList();
        int var3 = 0;
        for (GameProfile var5 : var1) {
            if (!var2.isWhiteListed(var5)) continue;
            UserWhiteListEntry var6 = new UserWhiteListEntry(var5);
            var2.remove(var6);
            var0.sendSuccess(() -> Component.translatable("commands.whitelist.remove.success", Component.literal(var5.getName())), true);
            ++var3;
        }
        if (var3 == 0) {
            throw ERROR_NOT_WHITELISTED.create();
        }
        var0.getServer().kickUnlistedPlayers(var0);
        return var3;
    }

    private static int enableWhitelist(CommandSourceStack var0) throws CommandSyntaxException {
        PlayerList var1 = var0.getServer().getPlayerList();
        if (var1.isUsingWhitelist()) {
            throw ERROR_ALREADY_ENABLED.create();
        }
        var1.setUsingWhiteList(true);
        var0.sendSuccess(() -> Component.translatable("commands.whitelist.enabled"), true);
        var0.getServer().kickUnlistedPlayers(var0);
        return 1;
    }

    private static int disableWhitelist(CommandSourceStack var0) throws CommandSyntaxException {
        PlayerList var1 = var0.getServer().getPlayerList();
        if (!var1.isUsingWhitelist()) {
            throw ERROR_ALREADY_DISABLED.create();
        }
        var1.setUsingWhiteList(false);
        var0.sendSuccess(() -> Component.translatable("commands.whitelist.disabled"), true);
        return 1;
    }

    private static int showList(CommandSourceStack var0) {
        String[] var1 = var0.getServer().getPlayerList().getWhiteListNames();
        if (var1.length == 0) {
            var0.sendSuccess(() -> Component.translatable("commands.whitelist.none"), false);
        } else {
            var0.sendSuccess(() -> Component.translatable("commands.whitelist.list", var1.length, String.join((CharSequence)", ", var1)), false);
        }
        return var1.length;
    }
}

