/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import com.google.common.collect.Streams;
import com.mojang.logging.LogUtils;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportType;
import net.minecraft.Util;
import net.minecraft.server.Bootstrap;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.util.TimeUtil;
import net.minecraft.world.level.GameRules;
import org.slf4j.Logger;

public class ServerWatchdog
implements Runnable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final long MAX_SHUTDOWN_TIME = 10000L;
    private static final int SHUTDOWN_STATUS = 1;
    private final DedicatedServer server;
    private final long maxTickTimeNanos;

    public ServerWatchdog(DedicatedServer var0) {
        this.server = var0;
        this.maxTickTimeNanos = var0.getMaxTickLength() * TimeUtil.NANOSECONDS_PER_MILLISECOND;
    }

    @Override
    public void run() {
        while (this.server.isRunning()) {
            long var0 = this.server.getNextTickTime();
            long var2 = Util.getNanos();
            long var4 = var2 - var0;
            if (var4 > this.maxTickTimeNanos) {
                LOGGER.error(LogUtils.FATAL_MARKER, "A single server tick took {} seconds (should be max {})", (Object)String.format(Locale.ROOT, "%.2f", Float.valueOf((float)var4 / (float)TimeUtil.NANOSECONDS_PER_SECOND)), (Object)String.format(Locale.ROOT, "%.2f", Float.valueOf(this.server.tickRateManager().millisecondsPerTick() / (float)TimeUtil.MILLISECONDS_PER_SECOND)));
                LOGGER.error(LogUtils.FATAL_MARKER, "Considering it to be crashed, server will forcibly shutdown.");
                CrashReport var6 = ServerWatchdog.createWatchdogCrashReport("Watching Server", this.server.getRunningThread().threadId());
                this.server.fillSystemReport(var6.getSystemReport());
                CrashReportCategory var7 = var6.addCategory("Performance stats");
                var7.setDetail("Random tick rate", () -> this.server.getWorldData().getGameRules().getRule(GameRules.RULE_RANDOMTICKING).toString());
                var7.setDetail("Level stats", () -> Streams.stream(this.server.getAllLevels()).map(var0 -> String.valueOf(var0.dimension().location()) + ": " + var0.getWatchdogStats()).collect(Collectors.joining(",\n")));
                Bootstrap.realStdoutPrintln("Crash report:\n" + var6.getFriendlyReport(ReportType.CRASH));
                Path var8 = this.server.getServerDirectory().resolve("crash-reports").resolve("crash-" + Util.getFilenameFormattedDateTime() + "-server.txt");
                if (var6.saveToFile(var8, ReportType.CRASH)) {
                    LOGGER.error("This crash report has been saved to: {}", (Object)var8.toAbsolutePath());
                } else {
                    LOGGER.error("We were unable to save this crash report to disk.");
                }
                this.exit();
            }
            try {
                Thread.sleep((var0 + this.maxTickTimeNanos - var2) / TimeUtil.NANOSECONDS_PER_MILLISECOND);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static CrashReport createWatchdogCrashReport(String var0, long var1) {
        ThreadMXBean var3 = ManagementFactory.getThreadMXBean();
        ThreadInfo[] var4 = var3.dumpAllThreads(true, true);
        StringBuilder var5 = new StringBuilder();
        Error var6 = new Error("Watchdog");
        for (ThreadInfo var10 : var4) {
            if (var10.getThreadId() == var1) {
                var6.setStackTrace(var10.getStackTrace());
            }
            var5.append(var10);
            var5.append("\n");
        }
        CrashReport var7 = new CrashReport(var0, var6);
        CrashReportCategory var8 = var7.addCategory("Thread Dump");
        var8.setDetail("Threads", var5);
        return var7;
    }

    private void exit() {
        try {
            Timer var0 = new Timer();
            var0.schedule(new TimerTask(this){

                @Override
                public void run() {
                    Runtime.getRuntime().halt(1);
                }
            }, 10000L);
            System.exit(1);
        }
        catch (Throwable var0) {
            Runtime.getRuntime().halt(1);
        }
    }
}

