/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.GeneratingChunkMap;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.util.StaticCache2D;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.Zone;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkDependencies;
import net.minecraft.world.level.chunk.status.ChunkPyramid;
import net.minecraft.world.level.chunk.status.ChunkStatus;

public class ChunkGenerationTask {
    private final GeneratingChunkMap chunkMap;
    private final ChunkPos pos;
    @Nullable
    private ChunkStatus scheduledStatus = null;
    public final ChunkStatus targetStatus;
    private volatile boolean markedForCancellation;
    private final List<CompletableFuture<ChunkResult<ChunkAccess>>> scheduledLayer = new ArrayList<CompletableFuture<ChunkResult<ChunkAccess>>>();
    private final StaticCache2D<GenerationChunkHolder> cache;
    private boolean needsGeneration;

    private ChunkGenerationTask(GeneratingChunkMap var0, ChunkStatus var1, ChunkPos var2, StaticCache2D<GenerationChunkHolder> var3) {
        this.chunkMap = var0;
        this.targetStatus = var1;
        this.pos = var2;
        this.cache = var3;
    }

    public static ChunkGenerationTask create(GeneratingChunkMap var0, ChunkStatus var12, ChunkPos var22) {
        int var3 = ChunkPyramid.GENERATION_PYRAMID.getStepTo(var12).getAccumulatedRadiusOf(ChunkStatus.EMPTY);
        StaticCache2D<GenerationChunkHolder> var4 = StaticCache2D.create(var22.x, var22.z, var3, (var1, var2) -> var0.acquireGeneration(ChunkPos.asLong(var1, var2)));
        return new ChunkGenerationTask(var0, var12, var22, var4);
    }

    @Nullable
    public CompletableFuture<?> runUntilWait() {
        CompletableFuture<?> var0;
        while ((var0 = this.waitForScheduledLayer()) == null) {
            if (this.markedForCancellation || this.scheduledStatus == this.targetStatus) {
                this.releaseClaim();
                return null;
            }
            this.scheduleNextLayer();
        }
        return var0;
    }

    private void scheduleNextLayer() {
        ChunkStatus var0;
        if (this.scheduledStatus == null) {
            var0 = ChunkStatus.EMPTY;
        } else if (!this.needsGeneration && this.scheduledStatus == ChunkStatus.EMPTY && !this.canLoadWithoutGeneration()) {
            this.needsGeneration = true;
            var0 = ChunkStatus.EMPTY;
        } else {
            var0 = ChunkStatus.getStatusList().get(this.scheduledStatus.getIndex() + 1);
        }
        this.scheduleLayer(var0, this.needsGeneration);
        this.scheduledStatus = var0;
    }

    public void markForCancellation() {
        this.markedForCancellation = true;
    }

    private void releaseClaim() {
        GenerationChunkHolder var0 = this.cache.get(this.pos.x, this.pos.z);
        var0.removeTask(this);
        this.cache.forEach(this.chunkMap::releaseGeneration);
    }

    private boolean canLoadWithoutGeneration() {
        if (this.targetStatus == ChunkStatus.EMPTY) {
            return true;
        }
        ChunkStatus var0 = this.cache.get(this.pos.x, this.pos.z).getPersistedStatus();
        if (var0 == null || var0.isBefore(this.targetStatus)) {
            return false;
        }
        ChunkDependencies var1 = ChunkPyramid.LOADING_PYRAMID.getStepTo(this.targetStatus).accumulatedDependencies();
        int var2 = var1.getRadius();
        for (int var3 = this.pos.x - var2; var3 <= this.pos.x + var2; ++var3) {
            for (int var4 = this.pos.z - var2; var4 <= this.pos.z + var2; ++var4) {
                int var5 = this.pos.getChessboardDistance(var3, var4);
                ChunkStatus var6 = var1.get(var5);
                ChunkStatus var7 = this.cache.get(var3, var4).getPersistedStatus();
                if (var7 != null && !var7.isBefore(var6)) continue;
                return false;
            }
        }
        return true;
    }

    public GenerationChunkHolder getCenter() {
        return this.cache.get(this.pos.x, this.pos.z);
    }

    private void scheduleLayer(ChunkStatus var0, boolean var1) {
        try (Zone var2 = Profiler.get().zone("scheduleLayer");){
            var2.addText(var0::getName);
            int var3 = this.getRadiusForLayer(var0, var1);
            for (int var4 = this.pos.x - var3; var4 <= this.pos.x + var3; ++var4) {
                for (int var5 = this.pos.z - var3; var5 <= this.pos.z + var3; ++var5) {
                    GenerationChunkHolder var6 = this.cache.get(var4, var5);
                    if (!this.markedForCancellation && this.scheduleChunkInLayer(var0, var1, var6)) continue;
                    return;
                }
            }
        }
    }

    private int getRadiusForLayer(ChunkStatus var0, boolean var1) {
        ChunkPyramid var2 = var1 ? ChunkPyramid.GENERATION_PYRAMID : ChunkPyramid.LOADING_PYRAMID;
        return var2.getStepTo(this.targetStatus).getAccumulatedRadiusOf(var0);
    }

    private boolean scheduleChunkInLayer(ChunkStatus var0, boolean var1, GenerationChunkHolder var2) {
        ChunkPyramid var5;
        ChunkStatus var3 = var2.getPersistedStatus();
        boolean var4 = var3 != null && var0.isAfter(var3);
        ChunkPyramid chunkPyramid = var5 = var4 ? ChunkPyramid.GENERATION_PYRAMID : ChunkPyramid.LOADING_PYRAMID;
        if (var4 && !var1) {
            throw new IllegalStateException("Can't load chunk, but didn't expect to need to generate");
        }
        CompletableFuture<ChunkResult<ChunkAccess>> var6 = var2.applyStep(var5.getStepTo(var0), this.chunkMap, this.cache);
        ChunkResult var7 = var6.getNow(null);
        if (var7 == null) {
            this.scheduledLayer.add(var6);
            return true;
        }
        if (var7.isSuccess()) {
            return true;
        }
        this.markForCancellation();
        return false;
    }

    @Nullable
    private CompletableFuture<?> waitForScheduledLayer() {
        while (!this.scheduledLayer.isEmpty()) {
            CompletableFuture<ChunkResult<ChunkAccess>> var0 = this.scheduledLayer.getLast();
            ChunkResult var1 = var0.getNow(null);
            if (var1 == null) {
                return var0;
            }
            this.scheduledLayer.removeLast();
            if (var1.isSuccess()) continue;
            this.markForCancellation();
        }
        return null;
    }
}

