/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtException;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundChunksBiomesPacket;
import net.minecraft.network.protocol.game.ClientboundSetChunkCacheCenterPacket;
import net.minecraft.server.level.ChunkGenerationTask;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.ChunkTaskDispatcher;
import net.minecraft.server.level.ChunkTaskPriorityQueue;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.GeneratingChunkMap;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.PlayerMap;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.CsvOutput;
import net.minecraft.util.Mth;
import net.minecraft.util.StaticCache2D;
import net.minecraft.util.TriState;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.util.thread.ConsecutiveExecutor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.TicketStorage;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkStep;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.chunk.status.WorldGenContext;
import net.minecraft.world.level.chunk.storage.ChunkStorage;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SerializableChunkData;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.bukkit.craftbukkit.v1_21_R5.generator.CustomChunkGenerator;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.TrackingRange;

public class ChunkMap
extends ChunkStorage
implements ChunkHolder.PlayerProvider,
GeneratingChunkMap {
    private static final ChunkResult<List<ChunkAccess>> UNLOADED_CHUNK_LIST_RESULT = ChunkResult.error("Unloaded chunks found in range");
    private static final CompletableFuture<ChunkResult<List<ChunkAccess>>> UNLOADED_CHUNK_LIST_FUTURE = CompletableFuture.completedFuture(UNLOADED_CHUNK_LIST_RESULT);
    private static final byte CHUNK_TYPE_REPLACEABLE = -1;
    private static final byte CHUNK_TYPE_UNKNOWN = 0;
    private static final byte CHUNK_TYPE_FULL = 1;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int CHUNK_SAVED_PER_TICK = 200;
    private static final int CHUNK_SAVED_EAGERLY_PER_TICK = 20;
    private static final int EAGER_CHUNK_SAVE_COOLDOWN_IN_MILLIS = 10000;
    private static final int MAX_ACTIVE_CHUNK_WRITES = 128;
    public static final int MIN_VIEW_DISTANCE = 2;
    public static final int MAX_VIEW_DISTANCE = 32;
    public static final int FORCED_TICKET_LEVEL = ChunkLevel.byStatus(FullChunkStatus.ENTITY_TICKING);
    public final Long2ObjectLinkedOpenHashMap<ChunkHolder> updatingChunkMap = new Long2ObjectLinkedOpenHashMap();
    public volatile Long2ObjectLinkedOpenHashMap<ChunkHolder> visibleChunkMap;
    private final Long2ObjectLinkedOpenHashMap<ChunkHolder> pendingUnloads;
    private final List<ChunkGenerationTask> pendingGenerationTasks;
    public final ServerLevel level;
    private final ThreadedLevelLightEngine lightEngine;
    private final BlockableEventLoop<Runnable> mainThreadExecutor;
    private final RandomState randomState;
    private final ChunkGeneratorStructureState chunkGeneratorState;
    private final Supplier<DimensionDataStorage> overworldDataStorage;
    private final TicketStorage ticketStorage;
    private final PoiManager poiManager;
    public final LongSet toDrop;
    private boolean modified;
    private final ChunkTaskDispatcher worldgenTaskDispatcher;
    private final ChunkTaskDispatcher lightTaskDispatcher;
    public final ChunkProgressListener progressListener;
    private final ChunkStatusUpdateListener chunkStatusListener;
    public final DistanceManager distanceManager;
    private final AtomicInteger tickingGenerated;
    private final String storageName;
    private final PlayerMap playerMap;
    public final Int2ObjectMap<TrackedEntity> entityMap;
    private final Long2ByteMap chunkTypeCache;
    private final Long2LongMap nextChunkSaveTime;
    private final LongSet chunksToEagerlySave;
    private final Queue<Runnable> unloadQueue;
    private final AtomicInteger activeChunkWrites;
    public int serverViewDistance;
    private final WorldGenContext worldGenContext;
    public final CallbackExecutor callbackExecutor = new CallbackExecutor();

    public ChunkMap(ServerLevel worldserver, LevelStorageSource.LevelStorageAccess convertable_conversionsession, DataFixer datafixer, StructureTemplateManager structuretemplatemanager, Executor executor, BlockableEventLoop<Runnable> iasynctaskhandler, LightChunkGetter ilightaccess, ChunkGenerator chunkgenerator, ChunkProgressListener worldloadlistener, ChunkStatusUpdateListener chunkstatusupdatelistener, Supplier<DimensionDataStorage> supplier, TicketStorage ticketstorage, int i, boolean flag) {
        super(new RegionStorageInfo(convertable_conversionsession.getLevelId(), worldserver.dimension(), "chunk"), convertable_conversionsession.getDimensionPath(worldserver.dimension()).resolve("region"), datafixer, flag);
        this.visibleChunkMap = this.updatingChunkMap.clone();
        this.pendingUnloads = new Long2ObjectLinkedOpenHashMap();
        this.pendingGenerationTasks = new ArrayList<ChunkGenerationTask>();
        this.toDrop = new LongOpenHashSet();
        this.tickingGenerated = new AtomicInteger();
        this.playerMap = new PlayerMap();
        this.entityMap = new Int2ObjectOpenHashMap();
        this.chunkTypeCache = new Long2ByteOpenHashMap();
        this.nextChunkSaveTime = new Long2LongOpenHashMap();
        this.chunksToEagerlySave = new LongLinkedOpenHashSet();
        this.unloadQueue = Queues.newConcurrentLinkedQueue();
        this.activeChunkWrites = new AtomicInteger();
        Path path = convertable_conversionsession.getDimensionPath(worldserver.dimension());
        this.storageName = path.getFileName().toString();
        this.level = worldserver;
        RegistryAccess iregistrycustom = worldserver.registryAccess();
        long j = worldserver.getSeed();
        ChunkGenerator randomGenerator = chunkgenerator;
        if (randomGenerator instanceof CustomChunkGenerator) {
            CustomChunkGenerator customChunkGenerator = (CustomChunkGenerator)randomGenerator;
            randomGenerator = customChunkGenerator.getDelegate();
        }
        if (randomGenerator instanceof NoiseBasedChunkGenerator) {
            NoiseBasedChunkGenerator chunkgeneratorabstract = (NoiseBasedChunkGenerator)randomGenerator;
            this.randomState = RandomState.create(chunkgeneratorabstract.generatorSettings().value(), iregistrycustom.lookupOrThrow(Registries.NOISE), j);
        } else {
            this.randomState = RandomState.create(NoiseGeneratorSettings.dummy(), iregistrycustom.lookupOrThrow(Registries.NOISE), j);
        }
        this.chunkGeneratorState = chunkgenerator.createState(iregistrycustom.lookupOrThrow(Registries.STRUCTURE_SET), this.randomState, j, worldserver.spigotConfig);
        this.mainThreadExecutor = iasynctaskhandler;
        ConsecutiveExecutor consecutiveexecutor = new ConsecutiveExecutor(executor, "worldgen");
        this.progressListener = worldloadlistener;
        this.chunkStatusListener = chunkstatusupdatelistener;
        ConsecutiveExecutor consecutiveexecutor1 = new ConsecutiveExecutor(executor, "light");
        this.worldgenTaskDispatcher = new ChunkTaskDispatcher(consecutiveexecutor, executor);
        this.lightTaskDispatcher = new ChunkTaskDispatcher(consecutiveexecutor1, executor);
        this.lightEngine = new ThreadedLevelLightEngine(ilightaccess, this, this.level.dimensionType().hasSkyLight(), consecutiveexecutor1, this.lightTaskDispatcher);
        this.distanceManager = new DistanceManager(ticketstorage, executor, iasynctaskhandler);
        this.overworldDataStorage = supplier;
        this.ticketStorage = ticketstorage;
        this.poiManager = new PoiManager(new RegionStorageInfo(convertable_conversionsession.getLevelId(), worldserver.dimension(), "poi"), path.resolve("poi"), datafixer, flag, iregistrycustom, worldserver.getServer(), worldserver);
        this.setServerViewDistance(i);
        this.worldGenContext = new WorldGenContext(worldserver, chunkgenerator, structuretemplatemanager, this.lightEngine, iasynctaskhandler, this::setChunkUnsaved);
    }

    private void setChunkUnsaved(ChunkPos chunkcoordintpair) {
        this.chunksToEagerlySave.add(chunkcoordintpair.toLong());
    }

    protected ChunkGenerator generator() {
        return this.worldGenContext.generator();
    }

    protected ChunkGeneratorStructureState generatorState() {
        return this.chunkGeneratorState;
    }

    protected RandomState randomState() {
        return this.randomState;
    }

    boolean isChunkTracked(ServerPlayer entityplayer, int i, int j) {
        return entityplayer.getChunkTrackingView().contains(i, j) && !entityplayer.connection.chunkSender.isPending(ChunkPos.asLong(i, j));
    }

    private boolean isChunkOnTrackedBorder(ServerPlayer entityplayer, int i, int j) {
        if (!this.isChunkTracked(entityplayer, i, j)) {
            return false;
        }
        for (int k = -1; k <= 1; ++k) {
            for (int l = -1; l <= 1; ++l) {
                if (k == 0 && l == 0 || this.isChunkTracked(entityplayer, i + k, j + l)) continue;
                return true;
            }
        }
        return false;
    }

    protected ThreadedLevelLightEngine getLightEngine() {
        return this.lightEngine;
    }

    @Nullable
    public ChunkHolder getUpdatingChunkIfPresent(long i) {
        return (ChunkHolder)this.updatingChunkMap.get(i);
    }

    @Nullable
    protected ChunkHolder getVisibleChunkIfPresent(long i) {
        return (ChunkHolder)this.visibleChunkMap.get(i);
    }

    protected IntSupplier getChunkQueueLevel(long i) {
        return () -> {
            ChunkHolder playerchunk = this.getVisibleChunkIfPresent(i);
            return playerchunk == null ? ChunkTaskPriorityQueue.PRIORITY_LEVEL_COUNT - 1 : Math.min(playerchunk.getQueueLevel(), ChunkTaskPriorityQueue.PRIORITY_LEVEL_COUNT - 1);
        };
    }

    public String getChunkDebugData(ChunkPos chunkcoordintpair) {
        ChunkHolder playerchunk = this.getVisibleChunkIfPresent(chunkcoordintpair.toLong());
        if (playerchunk == null) {
            return "null";
        }
        String s = playerchunk.getTicketLevel() + "\n";
        ChunkStatus chunkstatus = playerchunk.getLatestStatus();
        ChunkAccess ichunkaccess = playerchunk.getLatestChunk();
        if (chunkstatus != null) {
            s = s + "St: \u00a7" + chunkstatus.getIndex() + String.valueOf(chunkstatus) + "\u00a7r\n";
        }
        if (ichunkaccess != null) {
            s = s + "Ch: \u00a7" + ichunkaccess.getPersistedStatus().getIndex() + String.valueOf(ichunkaccess.getPersistedStatus()) + "\u00a7r\n";
        }
        FullChunkStatus fullchunkstatus = playerchunk.getFullStatus();
        s = s + String.valueOf('\u00a7') + fullchunkstatus.ordinal() + String.valueOf((Object)fullchunkstatus);
        return s + "\u00a7r";
    }

    private CompletableFuture<ChunkResult<List<ChunkAccess>>> getChunkRangeFuture(ChunkHolder playerchunk, int i, IntFunction<ChunkStatus> intfunction) {
        if (i == 0) {
            ChunkStatus chunkstatus = intfunction.apply(0);
            return playerchunk.scheduleChunkGenerationTask(chunkstatus, this).thenApply(chunkresult -> chunkresult.map(List::of));
        }
        int j = Mth.square(i * 2 + 1);
        ArrayList<CompletableFuture<ChunkResult<ChunkAccess>>> list = new ArrayList<CompletableFuture<ChunkResult<ChunkAccess>>>(j);
        ChunkPos chunkcoordintpair = playerchunk.getPos();
        for (int k = -i; k <= i; ++k) {
            for (int l = -i; l <= i; ++l) {
                int i1 = Math.max(Math.abs(l), Math.abs(k));
                long j1 = ChunkPos.asLong(chunkcoordintpair.x + l, chunkcoordintpair.z + k);
                ChunkHolder playerchunk1 = this.getUpdatingChunkIfPresent(j1);
                if (playerchunk1 == null) {
                    return UNLOADED_CHUNK_LIST_FUTURE;
                }
                ChunkStatus chunkstatus1 = intfunction.apply(i1);
                list.add(playerchunk1.scheduleChunkGenerationTask(chunkstatus1, this));
            }
        }
        return Util.sequence(list).thenApply(list1 -> {
            ArrayList<ChunkAccess> list2 = new ArrayList<ChunkAccess>(list1.size());
            for (ChunkResult chunkresult : list1) {
                if (chunkresult == null) {
                    throw this.debugFuturesAndCreateReportedException(new IllegalStateException("At least one of the chunk futures were null"), "n/a");
                }
                ChunkAccess ichunkaccess = chunkresult.orElse(null);
                if (ichunkaccess == null) {
                    return UNLOADED_CHUNK_LIST_RESULT;
                }
                list2.add(ichunkaccess);
            }
            return ChunkResult.of(list2);
        });
    }

    public ReportedException debugFuturesAndCreateReportedException(IllegalStateException illegalstateexception, String s) {
        StringBuilder stringbuilder = new StringBuilder();
        Consumer<ChunkHolder> consumer = playerchunk -> playerchunk.getAllFutures().forEach(pair -> {
            ChunkStatus chunkstatus = (ChunkStatus)pair.getFirst();
            CompletableFuture completablefuture = (CompletableFuture)pair.getSecond();
            if (completablefuture != null && completablefuture.isDone() && completablefuture.join() == null) {
                stringbuilder.append(playerchunk.getPos()).append(" - status: ").append(chunkstatus).append(" future: ").append(completablefuture).append(System.lineSeparator());
            }
        });
        stringbuilder.append("Updating:").append(System.lineSeparator());
        this.updatingChunkMap.values().forEach(consumer);
        stringbuilder.append("Visible:").append(System.lineSeparator());
        this.visibleChunkMap.values().forEach(consumer);
        CrashReport crashreport = CrashReport.forThrowable(illegalstateexception, "Chunk loading");
        CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Chunk loading");
        crashreportsystemdetails.setDetail("Details", s);
        crashreportsystemdetails.setDetail("Futures", stringbuilder);
        return new ReportedException(crashreport);
    }

    public CompletableFuture<ChunkResult<LevelChunk>> prepareEntityTickingChunk(ChunkHolder playerchunk) {
        return this.getChunkRangeFuture(playerchunk, 2, i -> ChunkStatus.FULL).thenApply(chunkresult -> chunkresult.map(list -> (LevelChunk)list.get(list.size() / 2)));
    }

    @Nullable
    ChunkHolder updateChunkScheduling(long i, int j, @Nullable ChunkHolder playerchunk, int k) {
        if (!ChunkLevel.isLoaded(k) && !ChunkLevel.isLoaded(j)) {
            return playerchunk;
        }
        if (playerchunk != null) {
            playerchunk.setTicketLevel(j);
        }
        if (playerchunk != null) {
            if (!ChunkLevel.isLoaded(j)) {
                this.toDrop.add(i);
            } else {
                this.toDrop.remove(i);
            }
        }
        if (ChunkLevel.isLoaded(j) && playerchunk == null) {
            playerchunk = (ChunkHolder)this.pendingUnloads.remove(i);
            if (playerchunk != null) {
                playerchunk.setTicketLevel(j);
            } else {
                playerchunk = new ChunkHolder(new ChunkPos(i), j, this.level, this.lightEngine, this::onLevelChange, this);
            }
            this.updatingChunkMap.put(i, (Object)playerchunk);
            this.modified = true;
        }
        return playerchunk;
    }

    private void onLevelChange(ChunkPos chunkcoordintpair, IntSupplier intsupplier, int i, IntConsumer intconsumer) {
        this.worldgenTaskDispatcher.onLevelChange(chunkcoordintpair, intsupplier, i, intconsumer);
        this.lightTaskDispatcher.onLevelChange(chunkcoordintpair, intsupplier, i, intconsumer);
    }

    @Override
    public void close() throws IOException {
        try {
            this.worldgenTaskDispatcher.close();
            this.lightTaskDispatcher.close();
            this.poiManager.close();
        }
        finally {
            super.close();
        }
    }

    protected void saveAllChunks(boolean flag) {
        if (flag) {
            List<ChunkHolder> list = this.visibleChunkMap.values().stream().filter(ChunkHolder::wasAccessibleSinceLastSave).peek(ChunkHolder::refreshAccessibility).toList();
            MutableBoolean mutableboolean = new MutableBoolean();
            do {
                mutableboolean.setFalse();
                list.stream().map(playerchunk -> {
                    BlockableEventLoop<Runnable> iasynctaskhandler = this.mainThreadExecutor;
                    Objects.requireNonNull(playerchunk);
                    iasynctaskhandler.managedBlock(playerchunk::isReadyForSaving);
                    return playerchunk.getLatestChunk();
                }).filter(ichunkaccess -> ichunkaccess instanceof ImposterProtoChunk || ichunkaccess instanceof LevelChunk).filter(this::save).forEach(ichunkaccess -> mutableboolean.setTrue());
            } while (mutableboolean.isTrue());
            this.poiManager.flushAll();
            this.processUnloads(() -> true);
            this.flushWorker();
        } else {
            this.nextChunkSaveTime.clear();
            long i = Util.getMillis();
            for (ChunkHolder playerchunk2 : this.visibleChunkMap.values()) {
                this.saveChunkIfNeeded(playerchunk2, i);
            }
        }
    }

    protected void tick(BooleanSupplier booleansupplier) {
        ProfilerFiller gameprofilerfiller = Profiler.get();
        gameprofilerfiller.push("poi");
        this.poiManager.tick(booleansupplier);
        gameprofilerfiller.popPush("chunk_unload");
        if (!this.level.noSave()) {
            this.processUnloads(booleansupplier);
        }
        gameprofilerfiller.pop();
    }

    public boolean hasWork() {
        return this.lightEngine.hasLightWork() || !this.pendingUnloads.isEmpty() || !this.updatingChunkMap.isEmpty() || this.poiManager.hasWork() || !this.toDrop.isEmpty() || !this.unloadQueue.isEmpty() || this.worldgenTaskDispatcher.hasWork() || this.lightTaskDispatcher.hasWork() || this.distanceManager.hasTickets();
    }

    private void processUnloads(BooleanSupplier booleansupplier) {
        Runnable runnable;
        LongIterator longiterator = this.toDrop.iterator();
        while (longiterator.hasNext()) {
            long i = longiterator.nextLong();
            ChunkHolder playerchunk = (ChunkHolder)this.updatingChunkMap.get(i);
            if (playerchunk != null) {
                this.updatingChunkMap.remove(i);
                this.pendingUnloads.put(i, (Object)playerchunk);
                this.modified = true;
                this.scheduleUnload(i, playerchunk);
            }
            longiterator.remove();
        }
        for (int j = Math.max(0, this.unloadQueue.size() - 2000); (j > 0 || booleansupplier.getAsBoolean()) && (runnable = this.unloadQueue.poll()) != null; --j) {
            runnable.run();
        }
        this.saveChunksEagerly(booleansupplier);
    }

    private void saveChunksEagerly(BooleanSupplier booleansupplier) {
        long i = Util.getMillis();
        int j = 0;
        LongIterator longiterator = this.chunksToEagerlySave.iterator();
        while (j < 20 && this.activeChunkWrites.get() < 128 && booleansupplier.getAsBoolean() && longiterator.hasNext()) {
            ChunkAccess ichunkaccess;
            long k = longiterator.nextLong();
            ChunkHolder playerchunk = (ChunkHolder)this.visibleChunkMap.get(k);
            ChunkAccess chunkAccess = ichunkaccess = playerchunk != null ? playerchunk.getLatestChunk() : null;
            if (ichunkaccess != null && ichunkaccess.isUnsaved()) {
                if (!this.saveChunkIfNeeded(playerchunk, i)) continue;
                ++j;
                longiterator.remove();
                continue;
            }
            longiterator.remove();
        }
    }

    private void scheduleUnload(long i, ChunkHolder playerchunk) {
        CompletableFuture<?> completablefuture = playerchunk.getSaveSyncFuture();
        Runnable runnable = () -> {
            CompletableFuture<?> completablefuture1 = playerchunk.getSaveSyncFuture();
            if (completablefuture1 != completablefuture) {
                this.scheduleUnload(i, playerchunk);
            } else {
                ChunkAccess ichunkaccess = playerchunk.getLatestChunk();
                if (this.pendingUnloads.remove(i, (Object)playerchunk) && ichunkaccess != null) {
                    if (ichunkaccess instanceof LevelChunk) {
                        LevelChunk chunk = (LevelChunk)ichunkaccess;
                        chunk.setLoaded(false);
                    }
                    this.save(ichunkaccess);
                    if (ichunkaccess instanceof LevelChunk) {
                        LevelChunk chunk1 = (LevelChunk)ichunkaccess;
                        this.level.unload(chunk1);
                    }
                    this.lightEngine.updateChunkStatus(ichunkaccess.getPos());
                    this.lightEngine.tryScheduleUpdate();
                    this.progressListener.onStatusChange(ichunkaccess.getPos(), null);
                    this.nextChunkSaveTime.remove(ichunkaccess.getPos().toLong());
                }
            }
        };
        Queue<Runnable> queue = this.unloadQueue;
        Objects.requireNonNull(this.unloadQueue);
        ((CompletableFuture)completablefuture.thenRunAsync(runnable, queue::add)).whenComplete((ovoid, throwable) -> {
            if (throwable != null) {
                LOGGER.error("Failed to save chunk {}", (Object)playerchunk.getPos(), throwable);
            }
        });
    }

    protected boolean promoteChunkMap() {
        if (!this.modified) {
            return false;
        }
        this.visibleChunkMap = this.updatingChunkMap.clone();
        this.modified = false;
        return true;
    }

    private CompletableFuture<ChunkAccess> scheduleChunkLoad(ChunkPos chunkcoordintpair) {
        CompletionStage completablefuture = this.readChunk(chunkcoordintpair).thenApplyAsync(optional -> optional.map(nbttagcompound -> {
            SerializableChunkData serializablechunkdata = SerializableChunkData.parse(this.level, this.level.registryAccess(), nbttagcompound);
            if (serializablechunkdata == null) {
                LOGGER.error("Chunk file at {} is missing level data, skipping", (Object)chunkcoordintpair);
            }
            return serializablechunkdata;
        }), Util.backgroundExecutor().forName("parseChunk"));
        CompletableFuture<?> completablefuture1 = this.poiManager.prefetch(chunkcoordintpair);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)completablefuture).thenCombine(completablefuture1, (optional, object) -> optional)).thenApplyAsync(optional -> {
            Profiler.get().incrementCounter("chunkLoad");
            if (optional.isPresent()) {
                ProtoChunk ichunkaccess = ((SerializableChunkData)optional.get()).read(this.level, this.poiManager, this.storageInfo(), chunkcoordintpair);
                this.markPosition(chunkcoordintpair, ((ChunkAccess)ichunkaccess).getPersistedStatus().getChunkType());
                return ichunkaccess;
            }
            return this.createEmptyChunk(chunkcoordintpair);
        }, (Executor)this.mainThreadExecutor)).exceptionallyAsync(throwable -> this.handleChunkLoadFailure((Throwable)throwable, chunkcoordintpair), (Executor)this.mainThreadExecutor);
    }

    private ChunkAccess handleChunkLoadFailure(Throwable throwable, ChunkPos chunkcoordintpair) {
        boolean flag1;
        Throwable throwable1;
        if (throwable instanceof CompletionException) {
            CompletionException completionexception = (CompletionException)throwable;
            throwable1 = completionexception.getCause();
        } else {
            throwable1 = throwable;
        }
        Throwable throwable2 = throwable1;
        if (throwable2 instanceof ReportedException) {
            ReportedException reportedexception = (ReportedException)throwable2;
            throwable1 = reportedexception.getCause();
        } else {
            throwable1 = throwable2;
        }
        Throwable throwable3 = throwable1;
        boolean flag = throwable3 instanceof Error;
        boolean bl = flag1 = throwable3 instanceof IOException || throwable3 instanceof NbtException;
        if (!flag) {
            if (!flag1) {
                // empty if block
            }
            this.level.getServer().reportChunkLoadFailure(throwable3, this.storageInfo(), chunkcoordintpair);
            return this.createEmptyChunk(chunkcoordintpair);
        }
        CrashReport crashreport = CrashReport.forThrowable(throwable, "Exception loading chunk");
        CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Chunk being loaded");
        crashreportsystemdetails.setDetail("pos", chunkcoordintpair);
        this.markPositionReplaceable(chunkcoordintpair);
        throw new ReportedException(crashreport);
    }

    private ChunkAccess createEmptyChunk(ChunkPos chunkcoordintpair) {
        this.markPositionReplaceable(chunkcoordintpair);
        return new ProtoChunk(chunkcoordintpair, UpgradeData.EMPTY, this.level, (Registry<Biome>)this.level.registryAccess().lookupOrThrow(Registries.BIOME), null);
    }

    private void markPositionReplaceable(ChunkPos chunkcoordintpair) {
        this.chunkTypeCache.put(chunkcoordintpair.toLong(), (byte)-1);
    }

    private byte markPosition(ChunkPos chunkcoordintpair, ChunkType chunktype) {
        return this.chunkTypeCache.put(chunkcoordintpair.toLong(), (byte)(chunktype == ChunkType.PROTOCHUNK ? -1 : 1));
    }

    @Override
    public GenerationChunkHolder acquireGeneration(long i) {
        ChunkHolder playerchunk = (ChunkHolder)this.updatingChunkMap.get(i);
        playerchunk.increaseGenerationRefCount();
        return playerchunk;
    }

    @Override
    public void releaseGeneration(GenerationChunkHolder generationchunkholder) {
        generationchunkholder.decreaseGenerationRefCount();
    }

    @Override
    public CompletableFuture<ChunkAccess> applyStep(GenerationChunkHolder generationchunkholder, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d) {
        ChunkPos chunkcoordintpair = generationchunkholder.getPos();
        if (chunkstep.targetStatus() == ChunkStatus.EMPTY) {
            return this.scheduleChunkLoad(chunkcoordintpair);
        }
        try {
            GenerationChunkHolder generationchunkholder1 = staticcache2d.get(chunkcoordintpair.x, chunkcoordintpair.z);
            ChunkAccess ichunkaccess = generationchunkholder1.getChunkIfPresentUnchecked(chunkstep.targetStatus().getParent());
            if (ichunkaccess == null) {
                throw new IllegalStateException("Parent chunk missing");
            }
            CompletableFuture<ChunkAccess> completablefuture = chunkstep.apply(this.worldGenContext, staticcache2d, ichunkaccess);
            this.progressListener.onStatusChange(chunkcoordintpair, chunkstep.targetStatus());
            return completablefuture;
        }
        catch (Exception exception) {
            exception.getStackTrace();
            CrashReport crashreport = CrashReport.forThrowable(exception, "Exception generating new chunk");
            CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Chunk to be generated");
            crashreportsystemdetails.setDetail("Status being generated", () -> chunkstep.targetStatus().getName());
            crashreportsystemdetails.setDetail("Location", String.format(Locale.ROOT, "%d,%d", chunkcoordintpair.x, chunkcoordintpair.z));
            crashreportsystemdetails.setDetail("Position hash", ChunkPos.asLong(chunkcoordintpair.x, chunkcoordintpair.z));
            crashreportsystemdetails.setDetail("Generator", this.generator());
            this.mainThreadExecutor.execute(() -> {
                throw new ReportedException(crashreport);
            });
            throw new ReportedException(crashreport);
        }
    }

    @Override
    public ChunkGenerationTask scheduleGenerationTask(ChunkStatus chunkstatus, ChunkPos chunkcoordintpair) {
        ChunkGenerationTask chunkgenerationtask = ChunkGenerationTask.create(this, chunkstatus, chunkcoordintpair);
        this.pendingGenerationTasks.add(chunkgenerationtask);
        return chunkgenerationtask;
    }

    private void runGenerationTask(ChunkGenerationTask chunkgenerationtask) {
        GenerationChunkHolder generationchunkholder = chunkgenerationtask.getCenter();
        ChunkTaskDispatcher chunktaskdispatcher = this.worldgenTaskDispatcher;
        Runnable runnable = () -> {
            CompletableFuture<?> completablefuture = chunkgenerationtask.runUntilWait();
            if (completablefuture != null) {
                completablefuture.thenRun(() -> this.runGenerationTask(chunkgenerationtask));
            }
        };
        long i = generationchunkholder.getPos().toLong();
        Objects.requireNonNull(generationchunkholder);
        chunktaskdispatcher.submit(runnable, i, generationchunkholder::getQueueLevel);
    }

    @Override
    public void runGenerationTasks() {
        this.pendingGenerationTasks.forEach(this::runGenerationTask);
        this.pendingGenerationTasks.clear();
    }

    public CompletableFuture<ChunkResult<LevelChunk>> prepareTickingChunk(ChunkHolder playerchunk) {
        CompletableFuture<ChunkResult<List<ChunkAccess>>> completablefuture = this.getChunkRangeFuture(playerchunk, 1, i -> ChunkStatus.FULL);
        CompletionStage completablefuture1 = completablefuture.thenApplyAsync(chunkresult -> chunkresult.map(list -> {
            LevelChunk chunk = (LevelChunk)list.get(list.size() / 2);
            chunk.postProcessGeneration(this.level);
            this.level.startTickingChunk(chunk);
            CompletableFuture<?> completablefuture2 = playerchunk.getSendSyncFuture();
            if (completablefuture2.isDone()) {
                this.onChunkReadyToSend(playerchunk, chunk);
            } else {
                completablefuture2.thenAcceptAsync(object -> this.onChunkReadyToSend(playerchunk, chunk), (Executor)this.mainThreadExecutor);
            }
            return chunk;
        }), (Executor)this.mainThreadExecutor);
        ((CompletableFuture)completablefuture1).handle((chunkresult, throwable) -> {
            this.tickingGenerated.getAndIncrement();
            return null;
        });
        return completablefuture1;
    }

    private void onChunkReadyToSend(ChunkHolder playerchunk, LevelChunk chunk) {
        ChunkPos chunkcoordintpair = chunk.getPos();
        for (ServerPlayer entityplayer : this.playerMap.getAllPlayers()) {
            if (!entityplayer.getChunkTrackingView().contains(chunkcoordintpair)) continue;
            ChunkMap.markChunkPendingToSend(entityplayer, chunk);
        }
        this.level.getChunkSource().onChunkReadyToSend(playerchunk);
    }

    public CompletableFuture<ChunkResult<LevelChunk>> prepareAccessibleChunk(ChunkHolder playerchunk) {
        return this.getChunkRangeFuture(playerchunk, 1, ChunkLevel::getStatusAroundFullChunk).thenApply(chunkresult -> chunkresult.map(list -> (LevelChunk)list.get(list.size() / 2)));
    }

    public int getTickingGenerated() {
        return this.tickingGenerated.get();
    }

    private boolean saveChunkIfNeeded(ChunkHolder playerchunk, long i) {
        if (playerchunk.wasAccessibleSinceLastSave() && playerchunk.isReadyForSaving()) {
            ChunkAccess ichunkaccess = playerchunk.getLatestChunk();
            if (!(ichunkaccess instanceof ImposterProtoChunk) && !(ichunkaccess instanceof LevelChunk)) {
                return false;
            }
            if (!ichunkaccess.isUnsaved()) {
                return false;
            }
            long j = ichunkaccess.getPos().toLong();
            long k = this.nextChunkSaveTime.getOrDefault(j, -1L);
            if (i < k) {
                return false;
            }
            boolean flag = this.save(ichunkaccess);
            playerchunk.refreshAccessibility();
            if (flag) {
                this.nextChunkSaveTime.put(j, i + 10000L);
            }
            return flag;
        }
        return false;
    }

    public boolean save(ChunkAccess ichunkaccess) {
        this.poiManager.flush(ichunkaccess.getPos());
        if (!ichunkaccess.tryMarkSaved()) {
            return false;
        }
        ChunkPos chunkcoordintpair = ichunkaccess.getPos();
        try {
            ChunkStatus chunkstatus = ichunkaccess.getPersistedStatus();
            if (chunkstatus.getChunkType() != ChunkType.LEVELCHUNK) {
                if (this.isExistingChunkFull(chunkcoordintpair)) {
                    return false;
                }
                if (chunkstatus == ChunkStatus.EMPTY && ichunkaccess.getAllStarts().values().stream().noneMatch(StructureStart::isValid)) {
                    return false;
                }
            }
            Profiler.get().incrementCounter("chunkSave");
            this.activeChunkWrites.incrementAndGet();
            SerializableChunkData serializablechunkdata = SerializableChunkData.copyOf(this.level, ichunkaccess);
            Objects.requireNonNull(serializablechunkdata);
            CompletableFuture<CompoundTag> completablefuture = CompletableFuture.supplyAsync(serializablechunkdata::write, Util.backgroundExecutor());
            Objects.requireNonNull(completablefuture);
            this.write(chunkcoordintpair, completablefuture::join).handle((ovoid, throwable) -> {
                if (throwable != null) {
                    this.level.getServer().reportChunkSaveFailure((Throwable)throwable, this.storageInfo(), chunkcoordintpair);
                }
                this.activeChunkWrites.decrementAndGet();
                return null;
            });
            this.markPosition(chunkcoordintpair, chunkstatus.getChunkType());
            return true;
        }
        catch (Exception exception) {
            this.level.getServer().reportChunkSaveFailure(exception, this.storageInfo(), chunkcoordintpair);
            return false;
        }
    }

    private boolean isExistingChunkFull(ChunkPos chunkcoordintpair) {
        CompoundTag nbttagcompound;
        byte b0 = this.chunkTypeCache.get(chunkcoordintpair.toLong());
        if (b0 != 0) {
            return b0 == 1;
        }
        try {
            nbttagcompound = this.readChunk(chunkcoordintpair).join().orElse(null);
            if (nbttagcompound == null) {
                this.markPositionReplaceable(chunkcoordintpair);
                return false;
            }
        }
        catch (Exception exception) {
            LOGGER.error("Failed to read chunk {}", (Object)chunkcoordintpair, (Object)exception);
            this.markPositionReplaceable(chunkcoordintpair);
            return false;
        }
        ChunkType chunktype = SerializableChunkData.getChunkStatusFromTag(nbttagcompound).getChunkType();
        return this.markPosition(chunkcoordintpair, chunktype) == 1;
    }

    protected void setServerViewDistance(int i) {
        int j = Mth.clamp(i, 2, 32);
        if (j != this.serverViewDistance) {
            this.serverViewDistance = j;
            this.distanceManager.updatePlayerTickets(this.serverViewDistance);
            for (ServerPlayer entityplayer : this.playerMap.getAllPlayers()) {
                this.updateChunkTracking(entityplayer);
            }
        }
    }

    int getPlayerViewDistance(ServerPlayer entityplayer) {
        return Mth.clamp(entityplayer.requestedViewDistance(), 2, this.serverViewDistance);
    }

    private void markChunkPendingToSend(ServerPlayer entityplayer, ChunkPos chunkcoordintpair) {
        LevelChunk chunk = this.getChunkToSend(chunkcoordintpair.toLong());
        if (chunk != null) {
            ChunkMap.markChunkPendingToSend(entityplayer, chunk);
        }
    }

    private static void markChunkPendingToSend(ServerPlayer entityplayer, LevelChunk chunk) {
        entityplayer.connection.chunkSender.markChunkPendingToSend(chunk);
    }

    private static void dropChunk(ServerPlayer entityplayer, ChunkPos chunkcoordintpair) {
        entityplayer.connection.chunkSender.dropChunk(entityplayer, chunkcoordintpair);
    }

    @Nullable
    public LevelChunk getChunkToSend(long i) {
        ChunkHolder playerchunk = this.getVisibleChunkIfPresent(i);
        return playerchunk == null ? null : playerchunk.getChunkToSend();
    }

    public int size() {
        return this.visibleChunkMap.size();
    }

    public net.minecraft.server.level.DistanceManager getDistanceManager() {
        return this.distanceManager;
    }

    protected Iterable<ChunkHolder> getChunks() {
        return Iterables.unmodifiableIterable((Iterable)this.visibleChunkMap.values());
    }

    void dumpChunks(Writer writer) throws IOException {
        CsvOutput csvwriter = CsvOutput.builder().addColumn("x").addColumn("z").addColumn("level").addColumn("in_memory").addColumn("status").addColumn("full_status").addColumn("accessible_ready").addColumn("ticking_ready").addColumn("entity_ticking_ready").addColumn("ticket").addColumn("spawning").addColumn("block_entity_count").addColumn("ticking_ticket").addColumn("ticking_level").addColumn("block_ticks").addColumn("fluid_ticks").build(writer);
        for (Long2ObjectMap.Entry long2objectmap_entry : this.visibleChunkMap.long2ObjectEntrySet()) {
            long i = long2objectmap_entry.getLongKey();
            ChunkPos chunkcoordintpair = new ChunkPos(i);
            ChunkHolder playerchunk = (ChunkHolder)long2objectmap_entry.getValue();
            Optional<ChunkAccess> optional = Optional.ofNullable(playerchunk.getLatestChunk());
            Optional<Object> optional1 = optional.flatMap(ichunkaccess -> ichunkaccess instanceof LevelChunk ? Optional.of((LevelChunk)ichunkaccess) : Optional.empty());
            csvwriter.writeRow(chunkcoordintpair.x, chunkcoordintpair.z, playerchunk.getTicketLevel(), optional.isPresent(), optional.map(ChunkAccess::getPersistedStatus).orElse(null), optional1.map(LevelChunk::getFullStatus).orElse(null), ChunkMap.printFuture(playerchunk.getFullChunkFuture()), ChunkMap.printFuture(playerchunk.getTickingChunkFuture()), ChunkMap.printFuture(playerchunk.getEntityTickingChunkFuture()), this.ticketStorage.getTicketDebugString(i, false), this.anyPlayerCloseEnoughForSpawning(chunkcoordintpair), optional1.map(chunk -> chunk.getBlockEntities().size()).orElse(0), this.ticketStorage.getTicketDebugString(i, true), this.distanceManager.getChunkLevel(i, true), optional1.map(chunk -> chunk.getBlockTicks().count()).orElse(0), optional1.map(chunk -> chunk.getFluidTicks().count()).orElse(0));
        }
    }

    private static String printFuture(CompletableFuture<ChunkResult<LevelChunk>> completablefuture) {
        try {
            ChunkResult chunkresult = completablefuture.getNow(null);
            return chunkresult != null ? (chunkresult.isSuccess() ? "done" : "unloaded") : "not completed";
        }
        catch (CompletionException completionexception) {
            return "failed " + completionexception.getCause().getMessage();
        }
        catch (CancellationException cancellationexception) {
            return "cancelled";
        }
    }

    private CompletableFuture<Optional<CompoundTag>> readChunk(ChunkPos chunkcoordintpair) {
        return this.read(chunkcoordintpair).thenApplyAsync(optional -> optional.map(nbttagcompound -> this.upgradeChunkTag((CompoundTag)nbttagcompound, chunkcoordintpair)), Util.backgroundExecutor().forName("upgradeChunk"));
    }

    private CompoundTag upgradeChunkTag(CompoundTag nbttagcompound, ChunkPos chunkcoordintpair) {
        return this.upgradeChunkTag(this.level.getTypeKey(), this.overworldDataStorage, nbttagcompound, this.generator().getTypeNameForDataFixer(), chunkcoordintpair, this.level);
    }

    void collectSpawningChunks(List<LevelChunk> list) {
        LongIterator longiterator = this.distanceManager.getSpawnCandidateChunks();
        while (longiterator.hasNext()) {
            LevelChunk chunk;
            ChunkHolder playerchunk = (ChunkHolder)this.visibleChunkMap.get(longiterator.nextLong());
            if (playerchunk == null || (chunk = playerchunk.getTickingChunk()) == null || !this.anyPlayerCloseEnoughForSpawningInternal(playerchunk.getPos())) continue;
            list.add(chunk);
        }
    }

    void forEachBlockTickingChunk(Consumer<LevelChunk> consumer) {
        this.distanceManager.forEachEntityTickingChunk(i -> {
            LevelChunk chunk;
            ChunkHolder playerchunk = (ChunkHolder)this.visibleChunkMap.get(i);
            if (playerchunk != null && (chunk = playerchunk.getTickingChunk()) != null) {
                consumer.accept(chunk);
            }
        });
    }

    boolean anyPlayerCloseEnoughForSpawning(ChunkPos chunkcoordintpair) {
        return this.anyPlayerCloseEnoughForSpawning(chunkcoordintpair, false);
    }

    boolean anyPlayerCloseEnoughForSpawning(ChunkPos chunkcoordintpair, boolean reducedRange) {
        TriState tristate = this.distanceManager.hasPlayersNearby(chunkcoordintpair.toLong());
        return tristate == TriState.DEFAULT ? this.anyPlayerCloseEnoughForSpawningInternal(chunkcoordintpair, reducedRange) : tristate.toBoolean(true);
    }

    private boolean anyPlayerCloseEnoughForSpawningInternal(ChunkPos chunkcoordintpair) {
        return this.anyPlayerCloseEnoughForSpawningInternal(chunkcoordintpair, false);
    }

    private boolean anyPlayerCloseEnoughForSpawningInternal(ChunkPos chunkcoordintpair, boolean reducedRange) {
        int chunkRange = this.level.spigotConfig.mobSpawnRange;
        chunkRange = chunkRange > this.level.spigotConfig.viewDistance ? (int)this.level.spigotConfig.viewDistance : chunkRange;
        chunkRange = chunkRange > 8 ? 8 : (int)chunkRange;
        double blockRange = reducedRange ? Math.pow(chunkRange << 4, 2.0) : 16384.0;
        for (ServerPlayer entityplayer : this.playerMap.getAllPlayers()) {
            if (!this.playerIsCloseEnoughForSpawning(entityplayer, chunkcoordintpair, blockRange)) continue;
            return true;
        }
        return false;
    }

    public List<ServerPlayer> getPlayersCloseForSpawning(ChunkPos chunkcoordintpair) {
        long i = chunkcoordintpair.toLong();
        if (!this.distanceManager.hasPlayersNearby(i).toBoolean(true)) {
            return List.of();
        }
        ImmutableList.Builder immutablelist_builder = ImmutableList.builder();
        for (ServerPlayer entityplayer : this.playerMap.getAllPlayers()) {
            if (!this.playerIsCloseEnoughForSpawning(entityplayer, chunkcoordintpair, 16384.0)) continue;
            immutablelist_builder.add((Object)entityplayer);
        }
        return immutablelist_builder.build();
    }

    private boolean playerIsCloseEnoughForSpawning(ServerPlayer entityplayer, ChunkPos chunkcoordintpair, double range) {
        if (entityplayer.isSpectator()) {
            return false;
        }
        double d0 = ChunkMap.euclideanDistanceSquared(chunkcoordintpair, entityplayer.position());
        return d0 < range;
    }

    private static double euclideanDistanceSquared(ChunkPos chunkcoordintpair, Vec3 vec3d) {
        double d0 = SectionPos.sectionToBlockCoord(chunkcoordintpair.x, 8);
        double d1 = SectionPos.sectionToBlockCoord(chunkcoordintpair.z, 8);
        double d2 = d0 - vec3d.x;
        double d3 = d1 - vec3d.z;
        return d2 * d2 + d3 * d3;
    }

    private boolean skipPlayer(ServerPlayer entityplayer) {
        return entityplayer.isSpectator() && !this.level.getGameRules().getBoolean(GameRules.RULE_SPECTATORSGENERATECHUNKS);
    }

    void updatePlayerStatus(ServerPlayer entityplayer, boolean flag) {
        boolean flag1 = this.skipPlayer(entityplayer);
        boolean flag2 = this.playerMap.ignoredOrUnknown(entityplayer);
        if (flag) {
            this.playerMap.addPlayer(entityplayer, flag1);
            this.updatePlayerPos(entityplayer);
            if (!flag1) {
                this.distanceManager.addPlayer(SectionPos.of(entityplayer), entityplayer);
            }
            entityplayer.setChunkTrackingView(ChunkTrackingView.EMPTY);
            this.updateChunkTracking(entityplayer);
        } else {
            SectionPos sectionposition = entityplayer.getLastSectionPos();
            this.playerMap.removePlayer(entityplayer);
            if (!flag2) {
                this.distanceManager.removePlayer(sectionposition, entityplayer);
            }
            this.applyChunkTrackingView(entityplayer, ChunkTrackingView.EMPTY);
        }
    }

    private void updatePlayerPos(ServerPlayer entityplayer) {
        SectionPos sectionposition = SectionPos.of(entityplayer);
        entityplayer.setLastSectionPos(sectionposition);
    }

    public void move(ServerPlayer entityplayer) {
        boolean flag2;
        for (TrackedEntity playerchunkmap_entitytracker : this.entityMap.values()) {
            if (playerchunkmap_entitytracker.entity == entityplayer) {
                playerchunkmap_entitytracker.updatePlayers(this.level.players());
                continue;
            }
            playerchunkmap_entitytracker.updatePlayer(entityplayer);
        }
        SectionPos sectionposition = entityplayer.getLastSectionPos();
        SectionPos sectionposition1 = SectionPos.of(entityplayer);
        boolean flag = this.playerMap.ignored(entityplayer);
        boolean flag1 = this.skipPlayer(entityplayer);
        boolean bl = flag2 = sectionposition.asLong() != sectionposition1.asLong();
        if (flag2 || flag != flag1) {
            this.updatePlayerPos(entityplayer);
            if (!flag) {
                this.distanceManager.removePlayer(sectionposition, entityplayer);
            }
            if (!flag1) {
                this.distanceManager.addPlayer(sectionposition1, entityplayer);
            }
            if (!flag && flag1) {
                this.playerMap.ignorePlayer(entityplayer);
            }
            if (flag && !flag1) {
                this.playerMap.unIgnorePlayer(entityplayer);
            }
            this.updateChunkTracking(entityplayer);
        }
    }

    private void updateChunkTracking(ServerPlayer entityplayer) {
        ChunkTrackingView.Positioned chunktrackingview_a;
        ChunkPos chunkcoordintpair = entityplayer.chunkPosition();
        int i = this.getPlayerViewDistance(entityplayer);
        ChunkTrackingView chunktrackingview = entityplayer.getChunkTrackingView();
        if (chunktrackingview instanceof ChunkTrackingView.Positioned && (chunktrackingview_a = (ChunkTrackingView.Positioned)chunktrackingview).center().equals(chunkcoordintpair) && chunktrackingview_a.viewDistance() == i) {
            return;
        }
        this.applyChunkTrackingView(entityplayer, ChunkTrackingView.of(chunkcoordintpair, i));
    }

    private void applyChunkTrackingView(ServerPlayer entityplayer, ChunkTrackingView chunktrackingview) {
        if (entityplayer.level() == this.level) {
            ChunkTrackingView chunktrackingview1 = entityplayer.getChunkTrackingView();
            if (chunktrackingview instanceof ChunkTrackingView.Positioned) {
                ChunkTrackingView.Positioned chunktrackingview_a1;
                ChunkTrackingView.Positioned chunktrackingview_a = (ChunkTrackingView.Positioned)chunktrackingview;
                if (!(chunktrackingview1 instanceof ChunkTrackingView.Positioned) || !(chunktrackingview_a1 = (ChunkTrackingView.Positioned)chunktrackingview1).center().equals(chunktrackingview_a.center())) {
                    entityplayer.connection.send(new ClientboundSetChunkCacheCenterPacket(chunktrackingview_a.center().x, chunktrackingview_a.center().z));
                }
            }
            ChunkTrackingView.difference(chunktrackingview1, chunktrackingview, chunkcoordintpair -> this.markChunkPendingToSend(entityplayer, (ChunkPos)chunkcoordintpair), chunkcoordintpair -> ChunkMap.dropChunk(entityplayer, chunkcoordintpair));
            entityplayer.setChunkTrackingView(chunktrackingview);
        }
    }

    @Override
    public List<ServerPlayer> getPlayers(ChunkPos chunkcoordintpair, boolean flag) {
        Set<ServerPlayer> set = this.playerMap.getAllPlayers();
        ImmutableList.Builder immutablelist_builder = ImmutableList.builder();
        for (ServerPlayer entityplayer : set) {
            if ((!flag || !this.isChunkOnTrackedBorder(entityplayer, chunkcoordintpair.x, chunkcoordintpair.z)) && (flag || !this.isChunkTracked(entityplayer, chunkcoordintpair.x, chunkcoordintpair.z))) continue;
            immutablelist_builder.add((Object)entityplayer);
        }
        return immutablelist_builder.build();
    }

    protected void addEntity(Entity entity) {
        AsyncCatcher.catchOp("entity track");
        if (!(entity instanceof EnderDragonPart)) {
            EntityType<?> entitytypes = entity.getType();
            int i = entitytypes.clientTrackingRange() * 16;
            if ((i = TrackingRange.getEntityTrackingRange(entity, i)) != 0) {
                int j = entitytypes.updateInterval();
                if (this.entityMap.containsKey(entity.getId())) {
                    throw Util.pauseInIde(new IllegalStateException("Entity is already tracked!"));
                }
                TrackedEntity playerchunkmap_entitytracker = new TrackedEntity(entity, i, j, entitytypes.trackDeltas());
                this.entityMap.put(entity.getId(), (Object)playerchunkmap_entitytracker);
                playerchunkmap_entitytracker.updatePlayers(this.level.players());
                if (entity instanceof ServerPlayer) {
                    ServerPlayer entityplayer = (ServerPlayer)entity;
                    this.updatePlayerStatus(entityplayer, true);
                    for (TrackedEntity playerchunkmap_entitytracker1 : this.entityMap.values()) {
                        if (playerchunkmap_entitytracker1.entity == entityplayer) continue;
                        playerchunkmap_entitytracker1.updatePlayer(entityplayer);
                    }
                }
            }
        }
    }

    protected void removeEntity(Entity entity) {
        TrackedEntity playerchunkmap_entitytracker1;
        AsyncCatcher.catchOp("entity untrack");
        if (entity instanceof ServerPlayer) {
            ServerPlayer entityplayer = (ServerPlayer)entity;
            this.updatePlayerStatus(entityplayer, false);
            for (TrackedEntity playerchunkmap_entitytracker : this.entityMap.values()) {
                playerchunkmap_entitytracker.removePlayer(entityplayer);
            }
        }
        if ((playerchunkmap_entitytracker1 = (TrackedEntity)this.entityMap.remove(entity.getId())) != null) {
            playerchunkmap_entitytracker1.broadcastRemoved();
        }
    }

    protected void tick() {
        for (ServerPlayer entityplayer : this.playerMap.getAllPlayers()) {
            this.updateChunkTracking(entityplayer);
        }
        ArrayList list = Lists.newArrayList();
        List<ServerPlayer> list1 = this.level.players();
        for (TrackedEntity playerchunkmap_entitytracker : this.entityMap.values()) {
            boolean flag;
            SectionPos sectionposition = playerchunkmap_entitytracker.lastSectionPos;
            SectionPos sectionposition1 = SectionPos.of(playerchunkmap_entitytracker.entity);
            boolean bl = flag = !Objects.equals(sectionposition, sectionposition1);
            if (flag) {
                playerchunkmap_entitytracker.updatePlayers(list1);
                Entity entity = playerchunkmap_entitytracker.entity;
                if (entity instanceof ServerPlayer) {
                    list.add((ServerPlayer)entity);
                }
                playerchunkmap_entitytracker.lastSectionPos = sectionposition1;
            }
            if (!flag && !this.distanceManager.inEntityTickingRange(sectionposition1.chunk().toLong())) continue;
            playerchunkmap_entitytracker.serverEntity.sendChanges();
        }
        if (!list.isEmpty()) {
            for (TrackedEntity playerchunkmap_entitytracker1 : this.entityMap.values()) {
                playerchunkmap_entitytracker1.updatePlayers(list);
            }
        }
    }

    public void broadcast(Entity entity, Packet<?> packet) {
        TrackedEntity playerchunkmap_entitytracker = (TrackedEntity)this.entityMap.get(entity.getId());
        if (playerchunkmap_entitytracker != null) {
            playerchunkmap_entitytracker.broadcast(packet);
        }
    }

    protected void broadcastAndSend(Entity entity, Packet<?> packet) {
        TrackedEntity playerchunkmap_entitytracker = (TrackedEntity)this.entityMap.get(entity.getId());
        if (playerchunkmap_entitytracker != null) {
            playerchunkmap_entitytracker.broadcastAndSend(packet);
        }
    }

    public void resendBiomesForChunks(List<ChunkAccess> list) {
        HashMap<ServerPlayer, List> map = new HashMap<ServerPlayer, List>();
        for (ChunkAccess ichunkaccess : list) {
            LevelChunk chunk1;
            ChunkPos chunkcoordintpair = ichunkaccess.getPos();
            LevelChunk chunk = ichunkaccess instanceof LevelChunk ? (chunk1 = (LevelChunk)ichunkaccess) : this.level.getChunk(chunkcoordintpair.x, chunkcoordintpair.z);
            for (ServerPlayer entityplayer : this.getPlayers(chunkcoordintpair, false)) {
                map.computeIfAbsent(entityplayer, entityplayer1 -> new ArrayList()).add(chunk);
            }
        }
        map.forEach((entityplayer1, list1) -> entityplayer1.connection.send(ClientboundChunksBiomesPacket.forChunks(list1)));
    }

    protected PoiManager getPoiManager() {
        return this.poiManager;
    }

    public String getStorageName() {
        return this.storageName;
    }

    void onFullChunkStatusChange(ChunkPos chunkcoordintpair, FullChunkStatus fullchunkstatus) {
        this.chunkStatusListener.onChunkStatusChange(chunkcoordintpair, fullchunkstatus);
    }

    public void waitForLightBeforeSending(ChunkPos chunkcoordintpair, int i) {
        int j = i + 1;
        ChunkPos.rangeClosed(chunkcoordintpair, j).forEach(chunkcoordintpair1 -> {
            ChunkHolder playerchunk = this.getVisibleChunkIfPresent(chunkcoordintpair1.toLong());
            if (playerchunk != null) {
                playerchunk.addSendDependency(this.lightEngine.waitForPendingTasks(chunkcoordintpair1.x, chunkcoordintpair1.z));
            }
        });
    }

    public static final class CallbackExecutor
    implements Executor,
    Runnable {
        private final Queue<Runnable> queue = new ArrayDeque<Runnable>();

        @Override
        public void execute(Runnable runnable) {
            this.queue.add(runnable);
        }

        @Override
        public void run() {
            Runnable task;
            while ((task = this.queue.poll()) != null) {
                task.run();
            }
        }
    }

    private class DistanceManager
    extends net.minecraft.server.level.DistanceManager {
        protected DistanceManager(TicketStorage ticketstorage, Executor executor, Executor executor1) {
            super(ticketstorage, executor, executor1);
        }

        @Override
        protected boolean isChunkToRemove(long i) {
            return ChunkMap.this.toDrop.contains(i);
        }

        @Override
        @Nullable
        protected ChunkHolder getChunk(long i) {
            return ChunkMap.this.getUpdatingChunkIfPresent(i);
        }

        @Override
        @Nullable
        protected ChunkHolder updateChunkScheduling(long i, int j, @Nullable ChunkHolder playerchunk, int k) {
            return ChunkMap.this.updateChunkScheduling(i, j, playerchunk, k);
        }
    }

    public class TrackedEntity {
        public final ServerEntity serverEntity;
        final Entity entity;
        private final int range;
        SectionPos lastSectionPos;
        public final Set<ServerPlayerConnection> seenBy = Sets.newIdentityHashSet();

        public TrackedEntity(Entity entity, int i, int j, boolean flag) {
            this.serverEntity = new ServerEntity(ChunkMap.this.level, entity, j, flag, this::broadcast, this::broadcastIgnorePlayers, this.seenBy);
            this.entity = entity;
            this.range = i;
            this.lastSectionPos = SectionPos.of(entity);
        }

        public boolean equals(Object object) {
            return object instanceof TrackedEntity ? ((TrackedEntity)object).entity.getId() == this.entity.getId() : false;
        }

        public int hashCode() {
            return this.entity.getId();
        }

        public void broadcast(Packet<?> packet) {
            for (ServerPlayerConnection serverplayerconnection : this.seenBy) {
                serverplayerconnection.send(packet);
            }
        }

        public void broadcastIgnorePlayers(Packet<?> packet, List<UUID> list) {
            for (ServerPlayerConnection serverplayerconnection : this.seenBy) {
                if (list.contains(serverplayerconnection.getPlayer().getUUID())) continue;
                serverplayerconnection.send(packet);
            }
        }

        public void broadcastAndSend(Packet<?> packet) {
            this.broadcast(packet);
            if (this.entity instanceof ServerPlayer) {
                ((ServerPlayer)this.entity).connection.send(packet);
            }
        }

        public void broadcastRemoved() {
            for (ServerPlayerConnection serverplayerconnection : this.seenBy) {
                this.serverEntity.removePairing(serverplayerconnection.getPlayer());
            }
        }

        public void removePlayer(ServerPlayer entityplayer) {
            AsyncCatcher.catchOp("player tracker clear");
            if (this.seenBy.remove(entityplayer.connection)) {
                this.serverEntity.removePairing(entityplayer);
            }
        }

        public void updatePlayer(ServerPlayer entityplayer) {
            AsyncCatcher.catchOp("player tracker update");
            if (entityplayer != this.entity) {
                boolean flag;
                Vec3 vec3d = entityplayer.position().subtract(this.entity.position());
                int i = ChunkMap.this.getPlayerViewDistance(entityplayer);
                double d1 = vec3d.x * vec3d.x + vec3d.z * vec3d.z;
                double d0 = Math.min(this.getEffectiveRange(), i * 16);
                double d2 = d0 * d0;
                boolean bl = flag = d1 <= d2 && this.entity.broadcastToPlayer(entityplayer) && ChunkMap.this.isChunkTracked(entityplayer, this.entity.chunkPosition().x, this.entity.chunkPosition().z);
                if (!entityplayer.getBukkitEntity().canSee(this.entity.getBukkitEntity())) {
                    flag = false;
                }
                if (flag) {
                    if (this.seenBy.add(entityplayer.connection)) {
                        this.serverEntity.addPairing(entityplayer);
                    }
                } else if (this.seenBy.remove(entityplayer.connection)) {
                    this.serverEntity.removePairing(entityplayer);
                }
            }
        }

        private int scaledRange(int i) {
            return ChunkMap.this.level.getServer().getScaledTrackingDistance(i);
        }

        private int getEffectiveRange() {
            int i = this.range;
            for (Entity entity : this.entity.getIndirectPassengers()) {
                int j = entity.getType().clientTrackingRange() * 16;
                if (j <= i) continue;
                i = j;
            }
            return this.scaledRange(i);
        }

        public void updatePlayers(List<ServerPlayer> list) {
            for (ServerPlayer entityplayer : list) {
                this.updatePlayer(entityplayer);
            }
        }
    }
}

