/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteMaps;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntMaps;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongConsumer;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.ChunkTracker;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.LoadingChunkTracker;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.SimulationChunkTracker;
import net.minecraft.server.level.ThrottlingChunkTaskDispatcher;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.TriState;
import net.minecraft.util.thread.TaskScheduler;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.TicketStorage;
import net.minecraft.world.level.chunk.LevelChunk;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;

public abstract class DistanceManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    static final int PLAYER_TICKET_LEVEL = ChunkLevel.byStatus(FullChunkStatus.ENTITY_TICKING);
    final Long2ObjectMap<ObjectSet<ServerPlayer>> playersPerChunk = new Long2ObjectOpenHashMap();
    private final LoadingChunkTracker loadingChunkTracker;
    private final SimulationChunkTracker simulationChunkTracker;
    final TicketStorage ticketStorage;
    private final FixedPlayerDistanceChunkTracker naturalSpawnChunkCounter = new FixedPlayerDistanceChunkTracker(8);
    private final PlayerTicketTracker playerTicketManager = new PlayerTicketTracker(32);
    protected final Set<ChunkHolder> chunksToUpdateFutures = new ReferenceOpenHashSet();
    final ThrottlingChunkTaskDispatcher ticketDispatcher;
    final LongSet ticketsToRelease = new LongOpenHashSet();
    final Executor mainThreadExecutor;
    public int simulationDistance = 10;

    protected DistanceManager(TicketStorage ticketstorage, Executor executor, Executor executor1) {
        this.ticketStorage = ticketstorage;
        this.loadingChunkTracker = new LoadingChunkTracker(this, ticketstorage);
        this.simulationChunkTracker = new SimulationChunkTracker(ticketstorage);
        TaskScheduler<Runnable> taskscheduler = TaskScheduler.wrapExecutor("player ticket throttler", executor1);
        this.ticketDispatcher = new ThrottlingChunkTaskDispatcher(taskscheduler, executor, 4);
        this.mainThreadExecutor = executor1;
    }

    protected abstract boolean isChunkToRemove(long var1);

    @Nullable
    protected abstract ChunkHolder getChunk(long var1);

    @Nullable
    protected abstract ChunkHolder updateChunkScheduling(long var1, int var3, @Nullable ChunkHolder var4, int var5);

    public boolean runAllUpdates(ChunkMap playerchunkmap) {
        boolean flag;
        AsyncCatcher.catchOp("chunk updates");
        this.naturalSpawnChunkCounter.runAllUpdates();
        this.simulationChunkTracker.runAllUpdates();
        this.playerTicketManager.runAllUpdates();
        int i = Integer.MAX_VALUE - this.loadingChunkTracker.runDistanceUpdates(Integer.MAX_VALUE);
        boolean bl = flag = i != 0;
        if (flag) {
            // empty if block
        }
        if (!this.chunksToUpdateFutures.isEmpty()) {
            for (ChunkHolder playerchunk : this.chunksToUpdateFutures) {
                playerchunk.callEventIfUnloading(playerchunkmap);
            }
            for (ChunkHolder playerchunk : this.chunksToUpdateFutures) {
                playerchunk.updateHighestAllowedStatus(playerchunkmap);
            }
            for (ChunkHolder playerchunk1 : this.chunksToUpdateFutures) {
                playerchunk1.updateFutures(playerchunkmap, this.mainThreadExecutor);
            }
            this.chunksToUpdateFutures.clear();
            return true;
        }
        if (!this.ticketsToRelease.isEmpty()) {
            LongIterator longiterator = this.ticketsToRelease.iterator();
            while (longiterator.hasNext()) {
                long j = longiterator.nextLong();
                if (!this.ticketStorage.getTickets(j).stream().anyMatch(ticket -> ticket.getType() == TicketType.PLAYER_LOADING)) continue;
                ChunkHolder playerchunk2 = playerchunkmap.getUpdatingChunkIfPresent(j);
                if (playerchunk2 == null) {
                    throw new IllegalStateException();
                }
                CompletableFuture<ChunkResult<LevelChunk>> completablefuture = playerchunk2.getEntityTickingChunkFuture();
                completablefuture.thenAccept(chunkresult -> this.mainThreadExecutor.execute(() -> this.ticketDispatcher.release(j, () -> {}, false)));
            }
            this.ticketsToRelease.clear();
        }
        return flag;
    }

    public void addPlayer(SectionPos sectionposition, ServerPlayer entityplayer) {
        ChunkPos chunkcoordintpair = sectionposition.chunk();
        long i = chunkcoordintpair.toLong();
        ((ObjectSet)this.playersPerChunk.computeIfAbsent(i, j -> new ObjectOpenHashSet())).add((Object)entityplayer);
        this.naturalSpawnChunkCounter.update(i, 0, true);
        this.playerTicketManager.update(i, 0, true);
        this.ticketStorage.addTicket(new Ticket(TicketType.PLAYER_SIMULATION, this.getPlayerTicketLevel()), chunkcoordintpair);
    }

    public void removePlayer(SectionPos sectionposition, ServerPlayer entityplayer) {
        ChunkPos chunkcoordintpair = sectionposition.chunk();
        long i = chunkcoordintpair.toLong();
        ObjectSet objectset = (ObjectSet)this.playersPerChunk.get(i);
        if (objectset == null) {
            return;
        }
        objectset.remove((Object)entityplayer);
        if (objectset.isEmpty()) {
            this.playersPerChunk.remove(i);
            this.naturalSpawnChunkCounter.update(i, Integer.MAX_VALUE, false);
            this.playerTicketManager.update(i, Integer.MAX_VALUE, false);
            this.ticketStorage.removeTicket(new Ticket(TicketType.PLAYER_SIMULATION, this.getPlayerTicketLevel()), chunkcoordintpair);
        }
    }

    private int getPlayerTicketLevel() {
        return Math.max(0, ChunkLevel.byStatus(FullChunkStatus.ENTITY_TICKING) - this.simulationDistance);
    }

    public boolean inEntityTickingRange(long i) {
        return ChunkLevel.isEntityTicking(this.simulationChunkTracker.getLevel(i));
    }

    public boolean inBlockTickingRange(long i) {
        return ChunkLevel.isBlockTicking(this.simulationChunkTracker.getLevel(i));
    }

    public int getChunkLevel(long i, boolean flag) {
        return flag ? this.simulationChunkTracker.getLevel(i) : this.loadingChunkTracker.getLevel(i);
    }

    protected void updatePlayerTickets(int i) {
        this.playerTicketManager.updateViewDistance(i);
    }

    public void updateSimulationDistance(int i) {
        if (i != this.simulationDistance) {
            this.simulationDistance = i;
            this.ticketStorage.replaceTicketLevelOfType(this.getPlayerTicketLevel(), TicketType.PLAYER_SIMULATION);
        }
    }

    public int getNaturalSpawnChunkCount() {
        this.naturalSpawnChunkCounter.runAllUpdates();
        return this.naturalSpawnChunkCounter.chunks.size();
    }

    public TriState hasPlayersNearby(long i) {
        this.naturalSpawnChunkCounter.runAllUpdates();
        int j = this.naturalSpawnChunkCounter.getLevel(i);
        return j <= NaturalSpawner.INSCRIBED_SQUARE_SPAWN_DISTANCE_CHUNK ? TriState.TRUE : (j > 8 ? TriState.FALSE : TriState.DEFAULT);
    }

    public void forEachEntityTickingChunk(LongConsumer longconsumer) {
        for (Long2ByteMap.Entry entry : Long2ByteMaps.fastIterable((Long2ByteMap)this.simulationChunkTracker.chunks)) {
            byte b0 = entry.getByteValue();
            long i = entry.getLongKey();
            if (!ChunkLevel.isEntityTicking(b0)) continue;
            longconsumer.accept(i);
        }
    }

    public LongIterator getSpawnCandidateChunks() {
        this.naturalSpawnChunkCounter.runAllUpdates();
        return this.naturalSpawnChunkCounter.chunks.keySet().iterator();
    }

    public String getDebugStatus() {
        return this.ticketDispatcher.getDebugStatus();
    }

    public boolean hasTickets() {
        return this.ticketStorage.hasTickets();
    }

    private class FixedPlayerDistanceChunkTracker
    extends ChunkTracker {
        protected final Long2ByteMap chunks;
        protected final int maxDistance;

        protected FixedPlayerDistanceChunkTracker(int i) {
            super(i + 2, 16, 256);
            this.chunks = new Long2ByteOpenHashMap();
            this.maxDistance = i;
            this.chunks.defaultReturnValue((byte)(i + 2));
        }

        @Override
        protected int getLevel(long i) {
            return this.chunks.get(i);
        }

        @Override
        protected void setLevel(long i, int j) {
            AsyncCatcher.catchOp("chunk level update");
            byte b0 = j > this.maxDistance ? this.chunks.remove(i) : this.chunks.put(i, (byte)j);
            this.onLevelChange(i, b0, j);
        }

        protected void onLevelChange(long i, int j, int k) {
        }

        @Override
        protected int getLevelFromSource(long i) {
            return this.havePlayer(i) ? 0 : Integer.MAX_VALUE;
        }

        private boolean havePlayer(long i) {
            ObjectSet objectset = (ObjectSet)DistanceManager.this.playersPerChunk.get(i);
            return objectset != null && !objectset.isEmpty();
        }

        public void runAllUpdates() {
            this.runUpdates(Integer.MAX_VALUE);
        }
    }

    private class PlayerTicketTracker
    extends FixedPlayerDistanceChunkTracker {
        private int viewDistance;
        private final Long2IntMap queueLevels;
        private final LongSet toUpdate;

        protected PlayerTicketTracker(int i) {
            super(i);
            this.viewDistance = 0;
            this.queueLevels = Long2IntMaps.synchronize((Long2IntMap)new Long2IntOpenHashMap());
            this.toUpdate = new LongOpenHashSet();
            this.queueLevels.defaultReturnValue(i + 2);
        }

        @Override
        protected void onLevelChange(long i, int j, int k) {
            this.toUpdate.add(i);
        }

        public void updateViewDistance(int i) {
            for (Long2ByteMap.Entry entry : this.chunks.long2ByteEntrySet()) {
                byte b0 = entry.getByteValue();
                long j = entry.getLongKey();
                this.onLevelChange(j, b0, this.haveTicketFor(b0), b0 <= i);
            }
            this.viewDistance = i;
        }

        private void onLevelChange(long i, int j, boolean flag, boolean flag1) {
            if (flag != flag1) {
                Ticket ticket = new Ticket(TicketType.PLAYER_LOADING, PLAYER_TICKET_LEVEL);
                if (flag1) {
                    DistanceManager.this.ticketDispatcher.submit(() -> DistanceManager.this.mainThreadExecutor.execute(() -> {
                        if (this.haveTicketFor(this.getLevel(i))) {
                            DistanceManager.this.ticketStorage.addTicket(i, ticket);
                            DistanceManager.this.ticketsToRelease.add(i);
                        } else {
                            DistanceManager.this.ticketDispatcher.release(i, () -> {}, false);
                        }
                    }), i, () -> j);
                } else {
                    DistanceManager.this.ticketDispatcher.release(i, () -> DistanceManager.this.mainThreadExecutor.execute(() -> DistanceManager.this.ticketStorage.removeTicket(i, ticket)), true);
                }
            }
        }

        @Override
        public void runAllUpdates() {
            super.runAllUpdates();
            if (!this.toUpdate.isEmpty()) {
                LongIterator longiterator = this.toUpdate.iterator();
                while (longiterator.hasNext()) {
                    int k;
                    long i = longiterator.nextLong();
                    int j = this.queueLevels.get(i);
                    if (j == (k = this.getLevel(i))) continue;
                    DistanceManager.this.ticketDispatcher.onLevelChange(new ChunkPos(i), () -> this.queueLevels.get(i), k, l -> {
                        if (l >= this.queueLevels.defaultReturnValue()) {
                            this.queueLevels.remove(i);
                        } else {
                            this.queueLevels.put(i, l);
                        }
                    });
                    this.onLevelChange(i, k, this.haveTicketFor(j), this.haveTicketFor(k));
                }
                this.toUpdate.clear();
            }
        }

        private boolean haveTicketFor(int i) {
            return i <= this.viewDistance;
        }
    }
}

