/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkTracker;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.world.level.TicketStorage;

class LoadingChunkTracker
extends ChunkTracker {
    private static final int MAX_LEVEL = ChunkLevel.MAX_LEVEL + 1;
    private final DistanceManager distanceManager;
    private final TicketStorage ticketStorage;

    public LoadingChunkTracker(DistanceManager var0, TicketStorage var1) {
        super(MAX_LEVEL + 1, 16, 256);
        this.distanceManager = var0;
        this.ticketStorage = var1;
        var1.setLoadingChunkUpdatedListener(this::update);
    }

    @Override
    protected int getLevelFromSource(long var0) {
        return this.ticketStorage.getTicketLevelAt(var0, false);
    }

    @Override
    protected int getLevel(long var0) {
        ChunkHolder var2;
        if (!this.distanceManager.isChunkToRemove(var0) && (var2 = this.distanceManager.getChunk(var0)) != null) {
            return var2.getTicketLevel();
        }
        return MAX_LEVEL;
    }

    @Override
    protected void setLevel(long var0, int var2) {
        int var4;
        ChunkHolder var3 = this.distanceManager.getChunk(var0);
        int n = var4 = var3 == null ? MAX_LEVEL : var3.getTicketLevel();
        if (var4 == var2) {
            return;
        }
        if ((var3 = this.distanceManager.updateChunkScheduling(var0, var2, var3, var4)) != null) {
            this.distanceManager.chunksToUpdateFutures.add(var3);
        }
    }

    public int runDistanceUpdates(int var0) {
        return this.runUpdates(var0);
    }
}

