/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.LocalMobCapCalculator;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.TicketStorage;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.bukkit.entity.SpawnCategory;
import org.slf4j.Logger;

public class ServerChunkCache
extends ChunkSource {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final DistanceManager distanceManager;
    private final ServerLevel level;
    final Thread mainThread;
    final ThreadedLevelLightEngine lightEngine;
    private final MainThreadExecutor mainThreadProcessor;
    public final ChunkMap chunkMap;
    private final DimensionDataStorage dataStorage;
    public final TicketStorage ticketStorage;
    private long lastInhabitedUpdate;
    public boolean spawnEnemies = true;
    public boolean spawnFriendlies = true;
    private static final int CACHE_SIZE = 4;
    private final long[] lastChunkPos = new long[4];
    private final ChunkStatus[] lastChunkStatus = new ChunkStatus[4];
    private final ChunkAccess[] lastChunk = new ChunkAccess[4];
    private final List<LevelChunk> spawningChunks = new ObjectArrayList();
    private final Set<ChunkHolder> chunkHoldersToBroadcast = new ReferenceOpenHashSet();
    @Nullable
    @VisibleForDebug
    private NaturalSpawner.SpawnState lastSpawnState;

    public ServerChunkCache(ServerLevel worldserver, LevelStorageSource.LevelStorageAccess convertable_conversionsession, DataFixer datafixer, StructureTemplateManager structuretemplatemanager, Executor executor, ChunkGenerator chunkgenerator, int i, int j, boolean flag, ChunkProgressListener worldloadlistener, ChunkStatusUpdateListener chunkstatusupdatelistener, Supplier<DimensionDataStorage> supplier) {
        this.level = worldserver;
        this.mainThreadProcessor = new MainThreadExecutor(worldserver);
        this.mainThread = Thread.currentThread();
        Path path = convertable_conversionsession.getDimensionPath(worldserver.dimension()).resolve("data");
        try {
            FileUtil.createDirectoriesSafe(path);
        }
        catch (IOException ioexception) {
            LOGGER.error("Failed to create dimension data storage directory", (Throwable)ioexception);
        }
        this.dataStorage = new DimensionDataStorage(new SavedData.Context(worldserver), path, datafixer, worldserver.registryAccess());
        this.ticketStorage = this.dataStorage.computeIfAbsent(TicketStorage.TYPE);
        this.chunkMap = new ChunkMap(worldserver, convertable_conversionsession, datafixer, structuretemplatemanager, executor, this.mainThreadProcessor, this, chunkgenerator, worldloadlistener, chunkstatusupdatelistener, supplier, this.ticketStorage, i, flag);
        this.lightEngine = this.chunkMap.getLightEngine();
        this.distanceManager = this.chunkMap.getDistanceManager();
        this.distanceManager.updateSimulationDistance(j);
        this.clearCache();
    }

    public boolean isChunkLoaded(int chunkX, int chunkZ) {
        ChunkHolder chunk = this.chunkMap.getUpdatingChunkIfPresent(ChunkPos.asLong(chunkX, chunkZ));
        if (chunk == null) {
            return false;
        }
        return chunk.getFullChunkNow() != null;
    }

    @Override
    public ThreadedLevelLightEngine getLightEngine() {
        return this.lightEngine;
    }

    @Nullable
    private ChunkHolder getVisibleChunkIfPresent(long i) {
        return this.chunkMap.getVisibleChunkIfPresent(i);
    }

    public int getTickingGenerated() {
        return this.chunkMap.getTickingGenerated();
    }

    private void storeInCache(long i, @Nullable ChunkAccess ichunkaccess, ChunkStatus chunkstatus) {
        for (int j = 3; j > 0; --j) {
            this.lastChunkPos[j] = this.lastChunkPos[j - 1];
            this.lastChunkStatus[j] = this.lastChunkStatus[j - 1];
            this.lastChunk[j] = this.lastChunk[j - 1];
        }
        this.lastChunkPos[0] = i;
        this.lastChunkStatus[0] = chunkstatus;
        this.lastChunk[0] = ichunkaccess;
    }

    @Override
    @Nullable
    public ChunkAccess getChunk(int i, int j, ChunkStatus chunkstatus, boolean flag) {
        if (Thread.currentThread() != this.mainThread) {
            return CompletableFuture.supplyAsync(() -> this.getChunk(i, j, chunkstatus, flag), this.mainThreadProcessor).join();
        }
        ProfilerFiller gameprofilerfiller = Profiler.get();
        gameprofilerfiller.incrementCounter("getChunk");
        long k = ChunkPos.asLong(i, j);
        for (int l = 0; l < 4; ++l) {
            ChunkAccess ichunkaccess;
            if (k != this.lastChunkPos[l] || chunkstatus != this.lastChunkStatus[l] || (ichunkaccess = this.lastChunk[l]) == null) continue;
            return ichunkaccess;
        }
        gameprofilerfiller.incrementCounter("getChunkCacheMiss");
        this.level.timings.syncChunkLoadTimer.startTiming();
        CompletableFuture<ChunkResult<ChunkAccess>> completablefuture = this.getChunkFutureMainThread(i, j, chunkstatus, flag);
        MainThreadExecutor chunkproviderserver_a = this.mainThreadProcessor;
        Objects.requireNonNull(completablefuture);
        chunkproviderserver_a.managedBlock(completablefuture::isDone);
        this.level.timings.syncChunkLoadTimer.stopTiming();
        ChunkResult<ChunkAccess> chunkresult = completablefuture.join();
        ChunkAccess ichunkaccess1 = chunkresult.orElse(null);
        if (ichunkaccess1 == null && flag) {
            throw Util.pauseInIde(new IllegalStateException("Chunk not there when requested: " + chunkresult.getError()));
        }
        this.storeInCache(k, ichunkaccess1, chunkstatus);
        return ichunkaccess1;
    }

    @Override
    @Nullable
    public LevelChunk getChunkNow(int i, int j) {
        if (Thread.currentThread() != this.mainThread) {
            return null;
        }
        Profiler.get().incrementCounter("getChunkNow");
        long k = ChunkPos.asLong(i, j);
        for (int l = 0; l < 4; ++l) {
            if (k != this.lastChunkPos[l] || this.lastChunkStatus[l] != ChunkStatus.FULL) continue;
            ChunkAccess ichunkaccess = this.lastChunk[l];
            return ichunkaccess instanceof LevelChunk ? (LevelChunk)ichunkaccess : null;
        }
        ChunkHolder playerchunk = this.getVisibleChunkIfPresent(k);
        if (playerchunk == null) {
            return null;
        }
        ChunkAccess ichunkaccess1 = playerchunk.getChunkIfPresent(ChunkStatus.FULL);
        if (ichunkaccess1 != null) {
            this.storeInCache(k, ichunkaccess1, ChunkStatus.FULL);
            if (ichunkaccess1 instanceof LevelChunk) {
                return (LevelChunk)ichunkaccess1;
            }
        }
        return null;
    }

    private void clearCache() {
        Arrays.fill(this.lastChunkPos, ChunkPos.INVALID_CHUNK_POS);
        Arrays.fill(this.lastChunkStatus, null);
        Arrays.fill(this.lastChunk, null);
    }

    public CompletableFuture<ChunkResult<ChunkAccess>> getChunkFuture(int i, int j, ChunkStatus chunkstatus, boolean flag) {
        CompletionStage<ChunkResult<ChunkAccess>> completablefuture;
        boolean flag1;
        boolean bl = flag1 = Thread.currentThread() == this.mainThread;
        if (flag1) {
            completablefuture = this.getChunkFutureMainThread(i, j, chunkstatus, flag);
            MainThreadExecutor chunkproviderserver_a = this.mainThreadProcessor;
            Objects.requireNonNull(completablefuture);
            chunkproviderserver_a.managedBlock(() -> completablefuture.isDone());
        } else {
            completablefuture = CompletableFuture.supplyAsync(() -> this.getChunkFutureMainThread(i, j, chunkstatus, flag), this.mainThreadProcessor).thenCompose(completablefuture1 -> completablefuture1);
        }
        return completablefuture;
    }

    private CompletableFuture<ChunkResult<ChunkAccess>> getChunkFutureMainThread(int i, int j, ChunkStatus chunkstatus, boolean flag) {
        ChunkPos chunkcoordintpair = new ChunkPos(i, j);
        long k = chunkcoordintpair.toLong();
        int l = ChunkLevel.byStatus(chunkstatus);
        ChunkHolder playerchunk = this.getVisibleChunkIfPresent(k);
        boolean currentlyUnloading = false;
        if (playerchunk != null) {
            FullChunkStatus oldChunkState = ChunkLevel.fullStatus(playerchunk.oldTicketLevel);
            FullChunkStatus currentChunkState = ChunkLevel.fullStatus(playerchunk.getTicketLevel());
            boolean bl = currentlyUnloading = oldChunkState.isOrAfter(FullChunkStatus.FULL) && !currentChunkState.isOrAfter(FullChunkStatus.FULL);
        }
        if (flag && !currentlyUnloading) {
            this.addTicket(new Ticket(TicketType.UNKNOWN, l), chunkcoordintpair);
            if (this.chunkAbsent(playerchunk, l)) {
                ProfilerFiller gameprofilerfiller = Profiler.get();
                gameprofilerfiller.push("chunkLoad");
                this.runDistanceManagerUpdates();
                playerchunk = this.getVisibleChunkIfPresent(k);
                gameprofilerfiller.pop();
                if (this.chunkAbsent(playerchunk, l)) {
                    throw Util.pauseInIde(new IllegalStateException("No chunk holder after ticket has been added"));
                }
            }
        }
        return this.chunkAbsent(playerchunk, l) ? GenerationChunkHolder.UNLOADED_CHUNK_FUTURE : playerchunk.scheduleChunkGenerationTask(chunkstatus, this.chunkMap);
    }

    private boolean chunkAbsent(@Nullable ChunkHolder playerchunk, int i) {
        return playerchunk == null || playerchunk.oldTicketLevel > i;
    }

    @Override
    public boolean hasChunk(int i, int j) {
        int k;
        ChunkHolder playerchunk = this.getVisibleChunkIfPresent(new ChunkPos(i, j).toLong());
        return !this.chunkAbsent(playerchunk, k = ChunkLevel.byStatus(ChunkStatus.FULL));
    }

    @Override
    @Nullable
    public LightChunk getChunkForLighting(int i, int j) {
        long k = ChunkPos.asLong(i, j);
        ChunkHolder playerchunk = this.getVisibleChunkIfPresent(k);
        return playerchunk == null ? null : playerchunk.getChunkIfPresentUnchecked(ChunkStatus.INITIALIZE_LIGHT.getParent());
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    public boolean pollTask() {
        return this.mainThreadProcessor.pollTask();
    }

    boolean runDistanceManagerUpdates() {
        boolean flag = this.distanceManager.runAllUpdates(this.chunkMap);
        boolean flag1 = this.chunkMap.promoteChunkMap();
        this.chunkMap.runGenerationTasks();
        if (!flag && !flag1) {
            return false;
        }
        this.clearCache();
        return true;
    }

    public boolean isPositionTicking(long i) {
        if (!this.level.shouldTickBlocksAt(i)) {
            return false;
        }
        ChunkHolder playerchunk = this.getVisibleChunkIfPresent(i);
        return playerchunk == null ? false : playerchunk.getTickingChunkFuture().getNow(ChunkHolder.UNLOADED_LEVEL_CHUNK).isSuccess();
    }

    public void save(boolean flag) {
        this.runDistanceManagerUpdates();
        this.chunkMap.saveAllChunks(flag);
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    public void close(boolean save) throws IOException {
        if (save) {
            this.save(true);
        }
        this.dataStorage.close();
        this.lightEngine.close();
        this.chunkMap.close();
    }

    public void purgeUnload() {
        ProfilerFiller gameprofilerfiller = Profiler.get();
        gameprofilerfiller.push("purge");
        this.ticketStorage.purgeStaleTickets(this.chunkMap);
        this.runDistanceManagerUpdates();
        gameprofilerfiller.popPush("unload");
        this.chunkMap.tick(() -> true);
        gameprofilerfiller.pop();
        this.clearCache();
    }

    @Override
    public void tick(BooleanSupplier booleansupplier, boolean flag) {
        ProfilerFiller gameprofilerfiller = Profiler.get();
        gameprofilerfiller.push("purge");
        this.level.timings.doChunkMap.startTiming();
        if (this.level.tickRateManager().runsNormally() || !flag || this.level.spigotConfig.unloadFrozenChunks) {
            this.ticketStorage.purgeStaleTickets(this.chunkMap);
        }
        this.runDistanceManagerUpdates();
        this.level.timings.doChunkMap.stopTiming();
        gameprofilerfiller.popPush("chunks");
        if (flag) {
            this.tickChunks();
            this.level.timings.tracker.startTiming();
            this.chunkMap.tick();
            this.level.timings.tracker.stopTiming();
        }
        this.level.timings.doChunkUnload.startTiming();
        gameprofilerfiller.popPush("unload");
        this.chunkMap.tick(booleansupplier);
        this.level.timings.doChunkUnload.stopTiming();
        gameprofilerfiller.pop();
        this.clearCache();
    }

    private void tickChunks() {
        long i = this.level.getGameTime();
        long j = i - this.lastInhabitedUpdate;
        this.lastInhabitedUpdate = i;
        if (!this.level.isDebug()) {
            ProfilerFiller gameprofilerfiller = Profiler.get();
            gameprofilerfiller.push("pollingChunks");
            if (this.level.tickRateManager().runsNormally()) {
                gameprofilerfiller.push("tickingChunks");
                this.tickChunks(gameprofilerfiller, j);
                gameprofilerfiller.pop();
            }
            this.broadcastChangedChunks(gameprofilerfiller);
            gameprofilerfiller.pop();
        }
    }

    private void broadcastChangedChunks(ProfilerFiller gameprofilerfiller) {
        gameprofilerfiller.push("broadcast");
        for (ChunkHolder playerchunk : this.chunkHoldersToBroadcast) {
            LevelChunk chunk = playerchunk.getTickingChunk();
            if (chunk == null) continue;
            playerchunk.broadcastChanges(chunk);
        }
        this.chunkHoldersToBroadcast.clear();
        gameprofilerfiller.pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tickChunks(ProfilerFiller gameprofilerfiller, long i) {
        List<MobCategory> list;
        NaturalSpawner.SpawnState spawnercreature_d;
        gameprofilerfiller.popPush("naturalSpawnCount");
        int j = this.distanceManager.getNaturalSpawnChunkCount();
        this.lastSpawnState = spawnercreature_d = NaturalSpawner.createState(j, this.level.getAllEntities(), this::getFullChunk, new LocalMobCapCalculator(this.chunkMap));
        gameprofilerfiller.popPush("spawnAndTick");
        boolean flag = this.level.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && !this.level.players().isEmpty();
        int k = this.level.getGameRules().getInt(GameRules.RULE_RANDOMTICKING);
        if (flag && (this.spawnEnemies || this.spawnFriendlies)) {
            boolean flag1 = this.level.ticksPerSpawnCategory.getLong((Object)SpawnCategory.ANIMAL) != 0L && this.level.getLevelData().getGameTime() % this.level.ticksPerSpawnCategory.getLong((Object)SpawnCategory.ANIMAL) == 0L;
            list = NaturalSpawner.getFilteredSpawningCategories(spawnercreature_d, this.spawnFriendlies, this.spawnEnemies, flag1, this.level);
        } else {
            list = List.of();
        }
        List<LevelChunk> list1 = this.spawningChunks;
        try {
            gameprofilerfiller.push("filteringSpawningChunks");
            this.chunkMap.collectSpawningChunks(list1);
            gameprofilerfiller.popPush("shuffleSpawningChunks");
            Util.shuffle(list1, this.level.random);
            gameprofilerfiller.popPush("tickSpawningChunks");
            for (LevelChunk chunk : list1) {
                this.tickSpawningChunk(chunk, i, list, spawnercreature_d);
            }
        }
        finally {
            list1.clear();
        }
        gameprofilerfiller.popPush("tickTickingChunks");
        this.chunkMap.forEachBlockTickingChunk(chunk1 -> {
            this.level.timings.doTickTiles.startTiming();
            this.level.tickChunk((LevelChunk)chunk1, k);
            this.level.timings.doTickTiles.stopTiming();
        });
        gameprofilerfiller.pop();
        gameprofilerfiller.popPush("customSpawners");
        if (flag) {
            this.level.tickCustomSpawners(this.spawnEnemies, this.spawnFriendlies);
        }
    }

    private void tickSpawningChunk(LevelChunk chunk, long i, List<MobCategory> list, NaturalSpawner.SpawnState spawnercreature_d) {
        ChunkPos chunkcoordintpair = chunk.getPos();
        chunk.incrementInhabitedTime(i);
        if (this.distanceManager.inEntityTickingRange(chunkcoordintpair.toLong())) {
            this.level.tickThunder(chunk);
        }
        if (!list.isEmpty() && this.level.canSpawnEntitiesInChunk(chunkcoordintpair) && this.chunkMap.anyPlayerCloseEnoughForSpawning(chunkcoordintpair, true)) {
            NaturalSpawner.spawnForChunk(this.level, chunk, spawnercreature_d, list);
        }
    }

    private void getFullChunk(long i, Consumer<LevelChunk> consumer) {
        ChunkHolder playerchunk = this.getVisibleChunkIfPresent(i);
        if (playerchunk != null) {
            playerchunk.getFullChunkFuture().getNow(ChunkHolder.UNLOADED_LEVEL_CHUNK).ifSuccess(consumer);
        }
    }

    @Override
    public String gatherStats() {
        return Integer.toString(this.getLoadedChunksCount());
    }

    @VisibleForTesting
    public int getPendingTasksCount() {
        return this.mainThreadProcessor.getPendingTasksCount();
    }

    public ChunkGenerator getGenerator() {
        return this.chunkMap.generator();
    }

    public ChunkGeneratorStructureState getGeneratorState() {
        return this.chunkMap.generatorState();
    }

    public RandomState randomState() {
        return this.chunkMap.randomState();
    }

    @Override
    public int getLoadedChunksCount() {
        return this.chunkMap.size();
    }

    public void blockChanged(BlockPos blockposition) {
        int j;
        int i = SectionPos.blockToSectionCoord(blockposition.getX());
        ChunkHolder playerchunk = this.getVisibleChunkIfPresent(ChunkPos.asLong(i, j = SectionPos.blockToSectionCoord(blockposition.getZ())));
        if (playerchunk != null && playerchunk.blockChanged(blockposition)) {
            this.chunkHoldersToBroadcast.add(playerchunk);
        }
    }

    @Override
    public void onLightUpdate(LightLayer enumskyblock, SectionPos sectionposition) {
        this.mainThreadProcessor.execute(() -> {
            ChunkHolder playerchunk = this.getVisibleChunkIfPresent(sectionposition.chunk().toLong());
            if (playerchunk != null && playerchunk.sectionLightChanged(enumskyblock, sectionposition.y())) {
                this.chunkHoldersToBroadcast.add(playerchunk);
            }
        });
    }

    public void addTicket(Ticket ticket, ChunkPos chunkcoordintpair) {
        this.ticketStorage.addTicket(ticket, chunkcoordintpair);
    }

    public void addTicketWithRadius(TicketType tickettype, ChunkPos chunkcoordintpair, int i) {
        this.ticketStorage.addTicketWithRadius(tickettype, chunkcoordintpair, i);
    }

    public void removeTicketWithRadius(TicketType tickettype, ChunkPos chunkcoordintpair, int i) {
        this.ticketStorage.removeTicketWithRadius(tickettype, chunkcoordintpair, i);
    }

    @Override
    public boolean updateChunkForced(ChunkPos chunkcoordintpair, boolean flag) {
        return this.ticketStorage.updateChunkForced(chunkcoordintpair, flag);
    }

    @Override
    public LongSet getForceLoadedChunks() {
        return this.ticketStorage.getForceLoadedChunks();
    }

    public void move(ServerPlayer entityplayer) {
        if (!entityplayer.isRemoved()) {
            this.chunkMap.move(entityplayer);
            if (entityplayer.isReceivingWaypoints()) {
                this.level.getWaypointManager().updatePlayer(entityplayer);
            }
        }
    }

    public void removeEntity(Entity entity) {
        this.chunkMap.removeEntity(entity);
    }

    public void addEntity(Entity entity) {
        this.chunkMap.addEntity(entity);
    }

    public void broadcastAndSend(Entity entity, Packet<?> packet) {
        this.chunkMap.broadcastAndSend(entity, packet);
    }

    public void broadcast(Entity entity, Packet<?> packet) {
        this.chunkMap.broadcast(entity, packet);
    }

    public void setViewDistance(int i) {
        this.chunkMap.setServerViewDistance(i);
    }

    public void setSimulationDistance(int i) {
        this.distanceManager.updateSimulationDistance(i);
    }

    @Override
    public void setSpawnSettings(boolean flag) {
        this.setSpawnSettings(flag, this.spawnFriendlies);
    }

    public void setSpawnSettings(boolean flag, boolean spawnFriendlies) {
        this.spawnEnemies = flag;
        this.spawnFriendlies = spawnFriendlies;
    }

    public String getChunkDebugData(ChunkPos chunkcoordintpair) {
        return this.chunkMap.getChunkDebugData(chunkcoordintpair);
    }

    public DimensionDataStorage getDataStorage() {
        return this.dataStorage;
    }

    public PoiManager getPoiManager() {
        return this.chunkMap.getPoiManager();
    }

    public ChunkScanAccess chunkScanner() {
        return this.chunkMap.chunkScanner();
    }

    @Nullable
    @VisibleForDebug
    public NaturalSpawner.SpawnState getLastSpawnState() {
        return this.lastSpawnState;
    }

    public void deactivateTicketsOnClosing() {
        this.ticketStorage.deactivateTicketsOnClosing();
    }

    public void onChunkReadyToSend(ChunkHolder playerchunk) {
        if (playerchunk.hasChangesToBroadcast()) {
            this.chunkHoldersToBroadcast.add(playerchunk);
        }
    }

    private final class MainThreadExecutor
    extends BlockableEventLoop<Runnable> {
        MainThreadExecutor(Level world) {
            super("Chunk source main thread executor for " + String.valueOf(world.dimension().location()));
        }

        @Override
        public void managedBlock(BooleanSupplier booleansupplier) {
            super.managedBlock(() -> MinecraftServer.throwIfFatalException() && booleansupplier.getAsBoolean());
        }

        @Override
        public Runnable wrapRunnable(Runnable runnable) {
            return runnable;
        }

        @Override
        protected boolean shouldRun(Runnable runnable) {
            return true;
        }

        @Override
        protected boolean scheduleExecutables() {
            return true;
        }

        @Override
        protected Thread getRunningThread() {
            return ServerChunkCache.this.mainThread;
        }

        @Override
        protected void doRunTask(Runnable runnable) {
            Profiler.get().incrementCounter("runTask");
            super.doRunTask(runnable);
        }

        @Override
        public boolean pollTask() {
            try {
                if (ServerChunkCache.this.runDistanceManagerUpdates()) {
                    boolean bl = true;
                    return bl;
                }
                ServerChunkCache.this.lightEngine.tryScheduleUpdate();
                boolean bl = super.pollTask();
                return bl;
            }
            finally {
                ServerChunkCache.this.chunkMap.callbackExecutor.run();
            }
        }
    }
}

