/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkTaskDispatcher;
import net.minecraft.util.thread.ConsecutiveExecutor;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.LevelLightEngine;
import org.slf4j.Logger;

public class ThreadedLevelLightEngine
extends LevelLightEngine
implements AutoCloseable {
    public static final int DEFAULT_BATCH_SIZE = 1000;
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ConsecutiveExecutor consecutiveExecutor;
    private final ObjectList<Pair<TaskType, Runnable>> lightTasks = new ObjectArrayList();
    private final ChunkMap chunkMap;
    private final ChunkTaskDispatcher taskDispatcher;
    private final int taskPerBatch = 1000;
    private final AtomicBoolean scheduled = new AtomicBoolean();

    public ThreadedLevelLightEngine(LightChunkGetter var0, ChunkMap var1, boolean var2, ConsecutiveExecutor var3, ChunkTaskDispatcher var4) {
        super(var0, true, var2);
        this.chunkMap = var1;
        this.taskDispatcher = var4;
        this.consecutiveExecutor = var3;
    }

    @Override
    public void close() {
    }

    @Override
    public int runLightUpdates() {
        throw Util.pauseInIde(new UnsupportedOperationException("Ran automatically on a different thread!"));
    }

    @Override
    public void checkBlock(BlockPos var0) {
        BlockPos var1 = var0.immutable();
        this.addTask(SectionPos.blockToSectionCoord(var0.getX()), SectionPos.blockToSectionCoord(var0.getZ()), TaskType.PRE_UPDATE, Util.name(() -> super.checkBlock(var1), () -> "checkBlock " + String.valueOf(var1)));
    }

    protected void updateChunkStatus(ChunkPos var0) {
        this.addTask(var0.x, var0.z, () -> 0, TaskType.PRE_UPDATE, Util.name(() -> {
            int var1;
            super.retainData(var0, false);
            super.setLightEnabled(var0, false);
            for (var1 = this.getMinLightSection(); var1 < this.getMaxLightSection(); ++var1) {
                super.queueSectionData(LightLayer.BLOCK, SectionPos.of(var0, var1), null);
                super.queueSectionData(LightLayer.SKY, SectionPos.of(var0, var1), null);
            }
            for (var1 = this.levelHeightAccessor.getMinSectionY(); var1 <= this.levelHeightAccessor.getMaxSectionY(); ++var1) {
                super.updateSectionStatus(SectionPos.of(var0, var1), true);
            }
        }, () -> "updateChunkStatus " + String.valueOf(var0) + " true"));
    }

    @Override
    public void updateSectionStatus(SectionPos var0, boolean var1) {
        this.addTask(var0.x(), var0.z(), () -> 0, TaskType.PRE_UPDATE, Util.name(() -> super.updateSectionStatus(var0, var1), () -> "updateSectionStatus " + String.valueOf(var0) + " " + var1));
    }

    @Override
    public void propagateLightSources(ChunkPos var0) {
        this.addTask(var0.x, var0.z, TaskType.PRE_UPDATE, Util.name(() -> super.propagateLightSources(var0), () -> "propagateLight " + String.valueOf(var0)));
    }

    @Override
    public void setLightEnabled(ChunkPos var0, boolean var1) {
        this.addTask(var0.x, var0.z, TaskType.PRE_UPDATE, Util.name(() -> super.setLightEnabled(var0, var1), () -> "enableLight " + String.valueOf(var0) + " " + var1));
    }

    @Override
    public void queueSectionData(LightLayer var0, SectionPos var1, @Nullable DataLayer var2) {
        this.addTask(var1.x(), var1.z(), () -> 0, TaskType.PRE_UPDATE, Util.name(() -> super.queueSectionData(var0, var1, var2), () -> "queueData " + String.valueOf(var1)));
    }

    private void addTask(int var0, int var1, TaskType var2, Runnable var3) {
        this.addTask(var0, var1, this.chunkMap.getChunkQueueLevel(ChunkPos.asLong(var0, var1)), var2, var3);
    }

    private void addTask(int var0, int var1, IntSupplier var2, TaskType var3, Runnable var4) {
        this.taskDispatcher.submit(() -> {
            this.lightTasks.add((Object)Pair.of((Object)((Object)var3), (Object)var4));
            if (this.lightTasks.size() >= 1000) {
                this.runUpdate();
            }
        }, ChunkPos.asLong(var0, var1), var2);
    }

    @Override
    public void retainData(ChunkPos var0, boolean var1) {
        this.addTask(var0.x, var0.z, () -> 0, TaskType.PRE_UPDATE, Util.name(() -> super.retainData(var0, var1), () -> "retainData " + String.valueOf(var0)));
    }

    public CompletableFuture<ChunkAccess> initializeLight(ChunkAccess var0, boolean var12) {
        ChunkPos var2 = var0.getPos();
        this.addTask(var2.x, var2.z, TaskType.PRE_UPDATE, Util.name(() -> {
            LevelChunkSection[] var2 = var0.getSections();
            for (int var3 = 0; var3 < var0.getSectionsCount(); ++var3) {
                LevelChunkSection var4 = var2[var3];
                if (var4.hasOnlyAir()) continue;
                int var5 = this.levelHeightAccessor.getSectionYFromSectionIndex(var3);
                super.updateSectionStatus(SectionPos.of(var2, var5), false);
            }
        }, () -> "initializeLight: " + String.valueOf(var2)));
        return CompletableFuture.supplyAsync(() -> {
            super.setLightEnabled(var2, var12);
            super.retainData(var2, false);
            return var0;
        }, var1 -> this.addTask(var0.x, var0.z, TaskType.POST_UPDATE, var1));
    }

    public CompletableFuture<ChunkAccess> lightChunk(ChunkAccess var0, boolean var12) {
        ChunkPos var2 = var0.getPos();
        var0.setLightCorrect(false);
        this.addTask(var2.x, var2.z, TaskType.PRE_UPDATE, Util.name(() -> {
            if (!var12) {
                super.propagateLightSources(var2);
            }
        }, () -> "lightChunk " + String.valueOf(var2) + " " + var12));
        return CompletableFuture.supplyAsync(() -> {
            var0.setLightCorrect(true);
            return var0;
        }, var1 -> this.addTask(var0.x, var0.z, TaskType.POST_UPDATE, var1));
    }

    public void tryScheduleUpdate() {
        if ((!this.lightTasks.isEmpty() || super.hasLightWork()) && this.scheduled.compareAndSet(false, true)) {
            this.consecutiveExecutor.schedule(() -> {
                this.runUpdate();
                this.scheduled.set(false);
            });
        }
    }

    private void runUpdate() {
        Pair var3;
        int var2;
        int var0 = Math.min(this.lightTasks.size(), 1000);
        ObjectListIterator var1 = this.lightTasks.iterator();
        for (var2 = 0; var1.hasNext() && var2 < var0; ++var2) {
            var3 = (Pair)var1.next();
            if (var3.getFirst() != TaskType.PRE_UPDATE) continue;
            ((Runnable)var3.getSecond()).run();
        }
        var1.back(var2);
        super.runLightUpdates();
        for (var2 = 0; var1.hasNext() && var2 < var0; ++var2) {
            var3 = (Pair)var1.next();
            if (var3.getFirst() == TaskType.POST_UPDATE) {
                ((Runnable)var3.getSecond()).run();
            }
            var1.remove();
        }
    }

    public CompletableFuture<?> waitForPendingTasks(int var0, int var1) {
        return CompletableFuture.runAsync(() -> {}, var2 -> this.addTask(var0, var1, TaskType.POST_UPDATE, var2));
    }

    static enum TaskType {
        PRE_UPDATE,
        POST_UPDATE;

    }
}

