/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import net.minecraft.network.Connection;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.protocol.handshake.ClientIntent;
import net.minecraft.network.protocol.handshake.ClientIntentionPacket;
import net.minecraft.network.protocol.handshake.ServerHandshakePacketListener;
import net.minecraft.network.protocol.login.LoginProtocols;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerLoginPacketListenerImpl;

public class MemoryServerHandshakePacketListenerImpl
implements ServerHandshakePacketListener {
    private final MinecraftServer server;
    private final Connection connection;

    public MemoryServerHandshakePacketListenerImpl(MinecraftServer var0, Connection var1) {
        this.server = var0;
        this.connection = var1;
    }

    @Override
    public void handleIntention(ClientIntentionPacket var0) {
        if (var0.intention() != ClientIntent.LOGIN) {
            throw new UnsupportedOperationException("Invalid intention " + String.valueOf((Object)var0.intention()));
        }
        this.connection.setupInboundProtocol(LoginProtocols.SERVERBOUND, new ServerLoginPacketListenerImpl(this.server, this.connection, false));
        this.connection.setupOutboundProtocol(LoginProtocols.CLIENTBOUND);
    }

    @Override
    public void onDisconnect(DisconnectionDetails var0) {
    }

    @Override
    public boolean isAcceptingMessages() {
        return this.connection.isConnected();
    }
}

