/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.level.validation.DirectoryValidator;
import net.minecraft.world.level.validation.ForbiddenSymlinkInfo;

public abstract class PackDetector<T> {
    private final DirectoryValidator validator;

    protected PackDetector(DirectoryValidator var0) {
        this.validator = var0;
    }

    @Nullable
    public T detectPackResources(Path var0, List<ForbiddenSymlinkInfo> var1) throws IOException {
        BasicFileAttributes var3;
        Path var2 = var0;
        try {
            var3 = Files.readAttributes(var0, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
        }
        catch (NoSuchFileException var4) {
            return null;
        }
        if (var3.isSymbolicLink()) {
            this.validator.validateSymlink(var0, var1);
            if (!var1.isEmpty()) {
                return null;
            }
            var2 = Files.readSymbolicLink(var0);
            var3 = Files.readAttributes(var2, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
        }
        if (var3.isDirectory()) {
            this.validator.validateKnownDirectory(var2, var1);
            if (!var1.isEmpty()) {
                return null;
            }
            if (!Files.isRegularFile(var2.resolve("pack.mcmeta"), new LinkOption[0])) {
                return null;
            }
            return this.createDirectoryPack(var2);
        }
        if (var3.isRegularFile() && var2.getFileName().toString().endsWith(".zip")) {
            return this.createZipPack(var2);
        }
        return null;
    }

    @Nullable
    protected abstract T createZipPack(Path var1) throws IOException;

    @Nullable
    protected abstract T createDirectoryPack(Path var1) throws IOException;
}

