/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.world.flag.FeatureFlagSet;

public class PackRepository {
    private final Set<RepositorySource> sources;
    private Map<String, Pack> available = ImmutableMap.of();
    private List<Pack> selected = ImmutableList.of();

    public PackRepository(RepositorySource ... var0) {
        this.sources = ImmutableSet.copyOf((Object[])var0);
    }

    public static String displayPackList(Collection<Pack> var02) {
        return var02.stream().map(var0 -> var0.getId() + (var0.getCompatibility().isCompatible() ? "" : " (incompatible)")).collect(Collectors.joining(", "));
    }

    public void reload() {
        List var0 = (List)this.selected.stream().map(Pack::getId).collect(ImmutableList.toImmutableList());
        this.available = this.discoverAvailable();
        this.selected = this.rebuildSelected(var0);
    }

    private Map<String, Pack> discoverAvailable() {
        TreeMap var0 = Maps.newTreeMap();
        for (RepositorySource var2 : this.sources) {
            var2.loadPacks(var1 -> var0.put(var1.getId(), var1));
        }
        return ImmutableMap.copyOf((Map)var0);
    }

    public boolean isAbleToClearAnyPack() {
        List<Pack> var0 = this.rebuildSelected(List.of());
        return !this.selected.equals(var0);
    }

    public void setSelected(Collection<String> var0) {
        this.selected = this.rebuildSelected(var0);
    }

    public boolean addPack(String var0) {
        Pack var1 = this.available.get(var0);
        if (var1 != null && !this.selected.contains(var1)) {
            ArrayList var2 = Lists.newArrayList(this.selected);
            var2.add(var1);
            this.selected = var2;
            return true;
        }
        return false;
    }

    public boolean removePack(String var0) {
        Pack var1 = this.available.get(var0);
        if (var1 != null && this.selected.contains(var1)) {
            ArrayList var2 = Lists.newArrayList(this.selected);
            var2.remove(var1);
            this.selected = var2;
            return true;
        }
        return false;
    }

    private List<Pack> rebuildSelected(Collection<String> var0) {
        List var1 = this.getAvailablePacks(var0).collect(Util.toMutableList());
        for (Pack var3 : this.available.values()) {
            if (!var3.isRequired() || var1.contains(var3)) continue;
            var3.getDefaultPosition().insert(var1, var3, Pack::selectionConfig, false);
        }
        return ImmutableList.copyOf(var1);
    }

    private Stream<Pack> getAvailablePacks(Collection<String> var0) {
        return var0.stream().map(this.available::get).filter(Objects::nonNull);
    }

    public Collection<String> getAvailableIds() {
        return this.available.keySet();
    }

    public Collection<Pack> getAvailablePacks() {
        return this.available.values();
    }

    public Collection<String> getSelectedIds() {
        return (Collection)this.selected.stream().map(Pack::getId).collect(ImmutableSet.toImmutableSet());
    }

    public FeatureFlagSet getRequestedFeatureFlags() {
        return this.getSelectedPacks().stream().map(Pack::getRequestedFeatures).reduce(FeatureFlagSet::join).orElse(FeatureFlagSet.of());
    }

    public Collection<Pack> getSelectedPacks() {
        return this.selected;
    }

    @Nullable
    public Pack getPack(String var0) {
        return this.available.get(var0);
    }

    public boolean isAvailable(String var0) {
        return this.available.containsKey(var0);
    }

    public List<PackResources> openAllSelected() {
        return (List)this.selected.stream().map(Pack::open).collect(ImmutableList.toImmutableList());
    }
}

