/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceMetadata;
import org.slf4j.Logger;

public class FallbackResourceManager
implements ResourceManager {
    static final Logger LOGGER = LogUtils.getLogger();
    protected final List<PackEntry> fallbacks = Lists.newArrayList();
    private final PackType type;
    private final String namespace;

    public FallbackResourceManager(PackType var0, String var1) {
        this.type = var0;
        this.namespace = var1;
    }

    public void push(PackResources var0) {
        this.pushInternal(var0.packId(), var0, null);
    }

    public void push(PackResources var0, Predicate<ResourceLocation> var1) {
        this.pushInternal(var0.packId(), var0, var1);
    }

    public void pushFilterOnly(String var0, Predicate<ResourceLocation> var1) {
        this.pushInternal(var0, null, var1);
    }

    private void pushInternal(String var0, @Nullable PackResources var1, @Nullable Predicate<ResourceLocation> var2) {
        this.fallbacks.add(new PackEntry(var0, var1, var2));
    }

    @Override
    public Set<String> getNamespaces() {
        return ImmutableSet.of((Object)this.namespace);
    }

    @Override
    public Optional<Resource> getResource(ResourceLocation var0) {
        for (int var1 = this.fallbacks.size() - 1; var1 >= 0; --var1) {
            IoSupplier<InputStream> var4;
            PackEntry var2 = this.fallbacks.get(var1);
            PackResources var3 = var2.resources;
            if (var3 != null && (var4 = var3.getResource(this.type, var0)) != null) {
                IoSupplier<ResourceMetadata> var5 = this.createStackMetadataFinder(var0, var1);
                return Optional.of(FallbackResourceManager.createResource(var3, var0, var4, var5));
            }
            if (!var2.isFiltered(var0)) continue;
            LOGGER.warn("Resource {} not found, but was filtered by pack {}", (Object)var0, (Object)var2.name);
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static Resource createResource(PackResources var0, ResourceLocation var1, IoSupplier<InputStream> var2, IoSupplier<ResourceMetadata> var3) {
        return new Resource(var0, FallbackResourceManager.wrapForDebug(var1, var0, var2), var3);
    }

    private static IoSupplier<InputStream> wrapForDebug(ResourceLocation var0, PackResources var1, IoSupplier<InputStream> var2) {
        if (LOGGER.isDebugEnabled()) {
            return () -> new LeakedResourceWarningInputStream((InputStream)var2.get(), var0, var1.packId());
        }
        return var2;
    }

    @Override
    public List<Resource> getResourceStack(ResourceLocation var0) {
        ResourceLocation var1 = FallbackResourceManager.getMetadataLocation(var0);
        ArrayList<Resource> var2 = new ArrayList<Resource>();
        boolean var3 = false;
        String var4 = null;
        for (int var5 = this.fallbacks.size() - 1; var5 >= 0; --var5) {
            IoSupplier<InputStream> var8;
            PackEntry var6 = this.fallbacks.get(var5);
            PackResources var7 = var6.resources;
            if (var7 != null && (var8 = var7.getResource(this.type, var0)) != null) {
                IoSupplier<ResourceMetadata> var9 = var3 ? ResourceMetadata.EMPTY_SUPPLIER : () -> {
                    IoSupplier<InputStream> var2 = var7.getResource(this.type, var1);
                    return var2 != null ? FallbackResourceManager.parseMetadata(var2) : ResourceMetadata.EMPTY;
                };
                var2.add(new Resource(var7, var8, var9));
            }
            if (var6.isFiltered(var0)) {
                var4 = var6.name;
                break;
            }
            if (!var6.isFiltered(var1)) continue;
            var3 = true;
        }
        if (var2.isEmpty() && var4 != null) {
            LOGGER.warn("Resource {} not found, but was filtered by pack {}", (Object)var0, var4);
        }
        return Lists.reverse(var2);
    }

    private static boolean isMetadata(ResourceLocation var0) {
        return var0.getPath().endsWith(".mcmeta");
    }

    private static ResourceLocation getResourceLocationFromMetadata(ResourceLocation var0) {
        String var1 = var0.getPath().substring(0, var0.getPath().length() - ".mcmeta".length());
        return var0.withPath(var1);
    }

    static ResourceLocation getMetadataLocation(ResourceLocation var0) {
        return var0.withPath(var0.getPath() + ".mcmeta");
    }

    @Override
    public Map<ResourceLocation, Resource> listResources(String var0, Predicate<ResourceLocation> var1) {
        final class ResourceWithSourceAndIndex
        extends Record {
            final PackResources packResources;
            final IoSupplier<InputStream> resource;
            final int packIndex;

            ResourceWithSourceAndIndex(PackResources var0, IoSupplier<InputStream> var1, int var2) {
                this.packResources = var0;
                this.resource = var1;
                this.packIndex = var2;
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{ResourceWithSourceAndIndex.class, "packResources;resource;packIndex", "packResources", "resource", "packIndex"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ResourceWithSourceAndIndex.class, "packResources;resource;packIndex", "packResources", "resource", "packIndex"}, this);
            }

            @Override
            public final boolean equals(Object var0) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ResourceWithSourceAndIndex.class, "packResources;resource;packIndex", "packResources", "resource", "packIndex"}, this, var0);
            }

            public PackResources packResources() {
                return this.packResources;
            }

            public IoSupplier<InputStream> resource() {
                return this.resource;
            }

            public int packIndex() {
                return this.packIndex;
            }
        }
        HashMap<ResourceLocation, ResourceWithSourceAndIndex> var22 = new HashMap<ResourceLocation, ResourceWithSourceAndIndex>();
        HashMap var32 = new HashMap();
        int var4 = this.fallbacks.size();
        for (int var52 = 0; var52 < var4; ++var52) {
            PackEntry var62 = this.fallbacks.get(var52);
            var62.filterAll(var22.keySet());
            var62.filterAll(var32.keySet());
            PackResources var7 = var62.resources;
            if (var7 == null) continue;
            int var8 = var52;
            var7.listResources(this.type, this.namespace, var0, (var5, var6) -> {
                if (FallbackResourceManager.isMetadata(var5)) {
                    if (var1.test(FallbackResourceManager.getResourceLocationFromMetadata(var5))) {
                        var32.put(var5, new ResourceWithSourceAndIndex(var7, (IoSupplier<InputStream>)var6, var8));
                    }
                } else if (var1.test((ResourceLocation)var5)) {
                    var22.put((ResourceLocation)var5, new ResourceWithSourceAndIndex(var7, (IoSupplier<InputStream>)var6, var8));
                }
            });
        }
        TreeMap var53 = Maps.newTreeMap();
        var22.forEach((var2, var3) -> {
            ResourceLocation var5 = FallbackResourceManager.getMetadataLocation(var2);
            ResourceWithSourceAndIndex var6 = (ResourceWithSourceAndIndex)var32.get(var5);
            IoSupplier<ResourceMetadata> var4 = var6 != null && var6.packIndex >= var3.packIndex ? FallbackResourceManager.convertToMetadata(var6.resource) : ResourceMetadata.EMPTY_SUPPLIER;
            var53.put(var2, FallbackResourceManager.createResource(var3.packResources, var2, var3.resource, var4));
        });
        return var53;
    }

    private IoSupplier<ResourceMetadata> createStackMetadataFinder(ResourceLocation var0, int var1) {
        return () -> {
            ResourceLocation var2 = FallbackResourceManager.getMetadataLocation(var0);
            for (int var3 = this.fallbacks.size() - 1; var3 >= var1; --var3) {
                IoSupplier<InputStream> var6;
                PackEntry var4 = this.fallbacks.get(var3);
                PackResources var5 = var4.resources;
                if (var5 != null && (var6 = var5.getResource(this.type, var2)) != null) {
                    return FallbackResourceManager.parseMetadata(var6);
                }
                if (var4.isFiltered(var2)) break;
            }
            return ResourceMetadata.EMPTY;
        };
    }

    private static IoSupplier<ResourceMetadata> convertToMetadata(IoSupplier<InputStream> var0) {
        return () -> FallbackResourceManager.parseMetadata(var0);
    }

    private static ResourceMetadata parseMetadata(IoSupplier<InputStream> var0) throws IOException {
        try (InputStream var1 = var0.get();){
            ResourceMetadata resourceMetadata = ResourceMetadata.fromJsonStream(var1);
            return resourceMetadata;
        }
    }

    private static void applyPackFiltersToExistingResources(PackEntry var0, Map<ResourceLocation, EntryStack> var1) {
        for (EntryStack var3 : var1.values()) {
            if (var0.isFiltered(var3.fileLocation)) {
                var3.fileSources.clear();
                continue;
            }
            if (!var0.isFiltered(var3.metadataLocation())) continue;
            var3.metaSources.clear();
        }
    }

    private void listPackResources(PackEntry var0, String var1, Predicate<ResourceLocation> var2, Map<ResourceLocation, EntryStack> var32) {
        PackResources var42 = var0.resources;
        if (var42 == null) {
            return;
        }
        var42.listResources(this.type, this.namespace, var1, (var3, var4) -> {
            if (FallbackResourceManager.isMetadata(var3)) {
                ResourceLocation var5 = FallbackResourceManager.getResourceLocationFromMetadata(var3);
                if (!var2.test(var5)) {
                    return;
                }
                var1.computeIfAbsent(var5, (Function<ResourceLocation, EntryStack>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(net.minecraft.resources.ResourceLocation ), (Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/server/packs/resources/FallbackResourceManager$EntryStack;)()).metaSources.put(var42, (IoSupplier<InputStream>)var4);
            } else {
                if (!var2.test((ResourceLocation)var3)) {
                    return;
                }
                var1.computeIfAbsent(var3, (Function<ResourceLocation, EntryStack>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(net.minecraft.resources.ResourceLocation ), (Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/server/packs/resources/FallbackResourceManager$EntryStack;)()).fileSources.add(new ResourceWithSource(var42, (IoSupplier<InputStream>)var4));
            }
        });
    }

    @Override
    public Map<ResourceLocation, List<Resource>> listResourceStacks(String var0, Predicate<ResourceLocation> var1) {
        HashMap var2 = Maps.newHashMap();
        for (PackEntry var4 : this.fallbacks) {
            FallbackResourceManager.applyPackFiltersToExistingResources(var4, var2);
            this.listPackResources(var4, var0, var1, var2);
        }
        TreeMap var3 = Maps.newTreeMap();
        for (EntryStack var5 : var2.values()) {
            if (var5.fileSources.isEmpty()) continue;
            ArrayList<Resource> var6 = new ArrayList<Resource>();
            for (ResourceWithSource var8 : var5.fileSources) {
                PackResources var9 = var8.source;
                IoSupplier<InputStream> var10 = var5.metaSources.get(var9);
                IoSupplier<ResourceMetadata> var11 = var10 != null ? FallbackResourceManager.convertToMetadata(var10) : ResourceMetadata.EMPTY_SUPPLIER;
                var6.add(FallbackResourceManager.createResource(var9, var5.fileLocation, var8.resource, var11));
            }
            var3.put(var5.fileLocation, var6);
        }
        return var3;
    }

    @Override
    public Stream<PackResources> listPacks() {
        return this.fallbacks.stream().map(var0 -> var0.resources).filter(Objects::nonNull);
    }

    static final class PackEntry
    extends Record {
        final String name;
        @Nullable
        final PackResources resources;
        @Nullable
        private final Predicate<ResourceLocation> filter;

        PackEntry(String var0, @Nullable PackResources var1, @Nullable Predicate<ResourceLocation> var2) {
            this.name = var0;
            this.resources = var1;
            this.filter = var2;
        }

        public void filterAll(Collection<ResourceLocation> var0) {
            if (this.filter != null) {
                var0.removeIf(this.filter);
            }
        }

        public boolean isFiltered(ResourceLocation var0) {
            return this.filter != null && this.filter.test(var0);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{PackEntry.class, "name;resources;filter", "name", "resources", "filter"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PackEntry.class, "name;resources;filter", "name", "resources", "filter"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PackEntry.class, "name;resources;filter", "name", "resources", "filter"}, this, var0);
        }

        public String name() {
            return this.name;
        }

        @Nullable
        public PackResources resources() {
            return this.resources;
        }

        @Nullable
        public Predicate<ResourceLocation> filter() {
            return this.filter;
        }
    }

    static final class EntryStack
    extends Record {
        final ResourceLocation fileLocation;
        private final ResourceLocation metadataLocation;
        final List<ResourceWithSource> fileSources;
        final Map<PackResources, IoSupplier<InputStream>> metaSources;

        EntryStack(ResourceLocation var0) {
            this(var0, FallbackResourceManager.getMetadataLocation(var0), new ArrayList<ResourceWithSource>(), (Map<PackResources, IoSupplier<InputStream>>)new Object2ObjectArrayMap());
        }

        private EntryStack(ResourceLocation var0, ResourceLocation var1, List<ResourceWithSource> var2, Map<PackResources, IoSupplier<InputStream>> var3) {
            this.fileLocation = var0;
            this.metadataLocation = var1;
            this.fileSources = var2;
            this.metaSources = var3;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{EntryStack.class, "fileLocation;metadataLocation;fileSources;metaSources", "fileLocation", "metadataLocation", "fileSources", "metaSources"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{EntryStack.class, "fileLocation;metadataLocation;fileSources;metaSources", "fileLocation", "metadataLocation", "fileSources", "metaSources"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{EntryStack.class, "fileLocation;metadataLocation;fileSources;metaSources", "fileLocation", "metadataLocation", "fileSources", "metaSources"}, this, var0);
        }

        public ResourceLocation fileLocation() {
            return this.fileLocation;
        }

        public ResourceLocation metadataLocation() {
            return this.metadataLocation;
        }

        public List<ResourceWithSource> fileSources() {
            return this.fileSources;
        }

        public Map<PackResources, IoSupplier<InputStream>> metaSources() {
            return this.metaSources;
        }
    }

    static final class ResourceWithSource
    extends Record {
        final PackResources source;
        final IoSupplier<InputStream> resource;

        ResourceWithSource(PackResources var0, IoSupplier<InputStream> var1) {
            this.source = var0;
            this.resource = var1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ResourceWithSource.class, "source;resource", "source", "resource"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ResourceWithSource.class, "source;resource", "source", "resource"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ResourceWithSource.class, "source;resource", "source", "resource"}, this, var0);
        }

        public PackResources source() {
            return this.source;
        }

        public IoSupplier<InputStream> resource() {
            return this.resource;
        }
    }

    static class LeakedResourceWarningInputStream
    extends FilterInputStream {
        private final Supplier<String> message;
        private boolean closed;

        public LeakedResourceWarningInputStream(InputStream var0, ResourceLocation var1, String var2) {
            super(var0);
            Exception var3 = new Exception("Stacktrace");
            this.message = () -> {
                StringWriter var3 = new StringWriter();
                var3.printStackTrace(new PrintWriter(var3));
                return "Leaked resource: '" + String.valueOf(var1) + "' loaded from pack: '" + var2 + "'\n" + String.valueOf(var3);
            };
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.closed = true;
        }

        protected void finalize() throws Throwable {
            if (!this.closed) {
                LOGGER.warn("{}", (Object)this.message.get());
            }
            super.finalize();
        }
    }
}

