/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.base.Stopwatch;
import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.Util;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadInstance;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleReloadInstance;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.Profiler;
import org.slf4j.Logger;

public class ProfiledReloadInstance
extends SimpleReloadInstance<State> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Stopwatch total = Stopwatch.createUnstarted();

    public static ReloadInstance of(ResourceManager var0, List<PreparableReloadListener> var12, Executor var22, Executor var32, CompletableFuture<Unit> var42) {
        ProfiledReloadInstance var5 = new ProfiledReloadInstance(var12);
        var5.startTasks(var22, var32, var0, var12, (var1, var2, var3, var4, var52) -> {
            AtomicLong var6 = new AtomicLong();
            AtomicLong var7 = new AtomicLong();
            AtomicLong var8 = new AtomicLong();
            AtomicLong var9 = new AtomicLong();
            CompletableFuture<Void> var10 = var3.reload(var1, var2, ProfiledReloadInstance.profiledExecutor(var4, var6, var7, var3.getName()), ProfiledReloadInstance.profiledExecutor(var52, var8, var9, var3.getName()));
            return var10.thenApplyAsync(var5 -> {
                LOGGER.debug("Finished reloading {}", (Object)var3.getName());
                return new State(var3.getName(), var6, var7, var8, var9);
            }, var32);
        }, var42);
        return var5;
    }

    private ProfiledReloadInstance(List<PreparableReloadListener> var0) {
        super(var0);
        this.total.start();
    }

    @Override
    protected CompletableFuture<List<State>> prepareTasks(Executor var0, Executor var1, ResourceManager var2, List<PreparableReloadListener> var3, SimpleReloadInstance.StateFactory<State> var4, CompletableFuture<?> var5) {
        return super.prepareTasks(var0, var1, var2, var3, var4, var5).thenApplyAsync(this::finish, var1);
    }

    private static Executor profiledExecutor(Executor var0, AtomicLong var1, AtomicLong var2, String var3) {
        return var4 -> var0.execute(() -> {
            Runnable var4 = Profiler.get();
            var4.push(var3);
            long var5 = Util.getNanos();
            var4.run();
            var1.addAndGet(Util.getNanos() - var5);
            var2.incrementAndGet();
            var4.pop();
        });
    }

    private List<State> finish(List<State> var0) {
        this.total.stop();
        long var1 = 0L;
        LOGGER.info("Resource reload finished after {} ms", (Object)this.total.elapsed(TimeUnit.MILLISECONDS));
        for (State var4 : var0) {
            long var5 = TimeUnit.NANOSECONDS.toMillis(var4.preparationNanos.get());
            long var7 = var4.preparationCount.get();
            long var9 = TimeUnit.NANOSECONDS.toMillis(var4.reloadNanos.get());
            long var11 = var4.reloadCount.get();
            long var13 = var5 + var9;
            long var15 = var7 + var11;
            String var17 = var4.name;
            LOGGER.info("{} took approximately {} tasks/{} ms ({} tasks/{} ms preparing, {} tasks/{} ms applying)", new Object[]{var17, var15, var13, var7, var5, var11, var9});
            var1 += var9;
        }
        LOGGER.info("Total blocking time: {} ms", (Object)var1);
        return var0;
    }

    public static final class State
    extends Record {
        final String name;
        final AtomicLong preparationNanos;
        final AtomicLong preparationCount;
        final AtomicLong reloadNanos;
        final AtomicLong reloadCount;

        public State(String var0, AtomicLong var1, AtomicLong var2, AtomicLong var3, AtomicLong var4) {
            this.name = var0;
            this.preparationNanos = var1;
            this.preparationCount = var2;
            this.reloadNanos = var3;
            this.reloadCount = var4;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{State.class, "name;preparationNanos;preparationCount;reloadNanos;reloadCount", "name", "preparationNanos", "preparationCount", "reloadNanos", "reloadCount"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{State.class, "name;preparationNanos;preparationCount;reloadNanos;reloadCount", "name", "preparationNanos", "preparationCount", "reloadNanos", "reloadCount"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{State.class, "name;preparationNanos;preparationCount;reloadNanos;reloadCount", "name", "preparationNanos", "preparationCount", "reloadNanos", "reloadCount"}, this, var0);
        }

        public String name() {
            return this.name;
        }

        public AtomicLong preparationNanos() {
            return this.preparationNanos;
        }

        public AtomicLong preparationCount() {
            return this.preparationCount;
        }

        public AtomicLong reloadNanos() {
            return this.reloadNanos;
        }

        public AtomicLong reloadCount() {
            return this.reloadCount;
        }
    }
}

