/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.gson.JsonObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.players.StoredUserEntry;

public abstract class BanListEntry<T>
extends StoredUserEntry<T> {
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z", Locale.ROOT);
    public static final String EXPIRES_NEVER = "forever";
    protected final Date created;
    protected final String source;
    @Nullable
    protected final Date expires;
    protected final String reason;

    public BanListEntry(@Nullable T t0, @Nullable Date date, @Nullable String s, @Nullable Date date1, @Nullable String s1) {
        super(t0);
        this.created = date == null ? new Date() : date;
        this.source = s == null ? "(Unknown)" : s;
        this.expires = date1;
        this.reason = s1 == null ? "Banned by an operator." : s1;
    }

    protected BanListEntry(@Nullable T t0, JsonObject jsonobject) {
        super(BanListEntry.checkExpiry(t0, jsonobject));
        Date date1;
        Date date;
        try {
            date = jsonobject.has("created") ? DATE_FORMAT.parse(jsonobject.get("created").getAsString()) : new Date();
        }
        catch (ParseException parseexception) {
            date = new Date();
        }
        this.created = date;
        this.source = jsonobject.has("source") ? jsonobject.get("source").getAsString() : "(Unknown)";
        try {
            date1 = jsonobject.has("expires") ? DATE_FORMAT.parse(jsonobject.get("expires").getAsString()) : null;
        }
        catch (ParseException parseexception1) {
            date1 = null;
        }
        this.expires = date1;
        this.reason = jsonobject.has("reason") ? jsonobject.get("reason").getAsString() : "Banned by an operator.";
    }

    public Date getCreated() {
        return this.created;
    }

    public String getSource() {
        return this.source;
    }

    @Nullable
    public Date getExpires() {
        return this.expires;
    }

    public String getReason() {
        return this.reason;
    }

    public abstract Component getDisplayName();

    @Override
    boolean hasExpired() {
        return this.expires == null ? false : this.expires.before(new Date());
    }

    @Override
    protected void serialize(JsonObject jsonobject) {
        jsonobject.addProperty("created", DATE_FORMAT.format(this.created));
        jsonobject.addProperty("source", this.source);
        jsonobject.addProperty("expires", this.expires == null ? EXPIRES_NEVER : DATE_FORMAT.format(this.expires));
        jsonobject.addProperty("reason", this.reason);
    }

    private static <T> T checkExpiry(T object, JsonObject jsonobject) {
        Date expires = null;
        try {
            expires = jsonobject.has("expires") ? DATE_FORMAT.parse(jsonobject.get("expires").getAsString()) : null;
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (expires == null || expires.after(new Date())) {
            return object;
        }
        return null;
    }
}

