/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.UUIDUtil;
import net.minecraft.util.StringUtil;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class GameProfileCache {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int GAMEPROFILES_MRU_LIMIT = 1000;
    private static final int GAMEPROFILES_EXPIRATION_MONTHS = 1;
    private static boolean usesAuthentication;
    private final Map<String, GameProfileInfo> profilesByName = Maps.newConcurrentMap();
    private final Map<UUID, GameProfileInfo> profilesByUUID = Maps.newConcurrentMap();
    private final Map<String, CompletableFuture<Optional<GameProfile>>> requests = Maps.newConcurrentMap();
    private final GameProfileRepository profileRepository;
    private final Gson gson = new GsonBuilder().create();
    private final File file;
    private final AtomicLong operationCount = new AtomicLong();
    @Nullable
    private Executor executor;

    public GameProfileCache(GameProfileRepository gameprofilerepository, File file) {
        this.profileRepository = gameprofilerepository;
        this.file = file;
        Lists.reverse(this.load()).forEach(this::safeAdd);
    }

    private void safeAdd(GameProfileInfo usercache_usercacheentry) {
        GameProfile gameprofile = usercache_usercacheentry.getProfile();
        usercache_usercacheentry.setLastAccess(this.getNextOperation());
        this.profilesByName.put(gameprofile.getName().toLowerCase(Locale.ROOT), usercache_usercacheentry);
        this.profilesByUUID.put(gameprofile.getId(), usercache_usercacheentry);
    }

    private static Optional<GameProfile> lookupGameProfile(GameProfileRepository gameprofilerepository, String s) {
        if (!StringUtil.isValidPlayerName(s)) {
            return GameProfileCache.createUnknownProfile(s);
        }
        Optional<GameProfile> optional = gameprofilerepository.findProfileByName(s);
        return optional.isEmpty() ? GameProfileCache.createUnknownProfile(s) : optional;
    }

    private static Optional<GameProfile> createUnknownProfile(String s) {
        return GameProfileCache.usesAuthentication() ? Optional.empty() : Optional.of(UUIDUtil.createOfflineProfile(s));
    }

    public static void setUsesAuthentication(boolean flag) {
        usesAuthentication = flag;
    }

    private static boolean usesAuthentication() {
        return usesAuthentication;
    }

    public void add(GameProfile gameprofile) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(2, 1);
        Date date = calendar.getTime();
        GameProfileInfo usercache_usercacheentry = new GameProfileInfo(gameprofile, date);
        this.safeAdd(usercache_usercacheentry);
        if (!SpigotConfig.saveUserCacheOnStopOnly) {
            this.save();
        }
    }

    private long getNextOperation() {
        return this.operationCount.incrementAndGet();
    }

    public Optional<GameProfile> get(String s) {
        Optional<GameProfile> optional;
        String s1 = s.toLowerCase(Locale.ROOT);
        GameProfileInfo usercache_usercacheentry = this.profilesByName.get(s1);
        boolean flag = false;
        if (usercache_usercacheentry != null && new Date().getTime() >= usercache_usercacheentry.expirationDate.getTime()) {
            this.profilesByUUID.remove(usercache_usercacheentry.getProfile().getId());
            this.profilesByName.remove(usercache_usercacheentry.getProfile().getName().toLowerCase(Locale.ROOT));
            flag = true;
            usercache_usercacheentry = null;
        }
        if (usercache_usercacheentry != null) {
            usercache_usercacheentry.setLastAccess(this.getNextOperation());
            optional = Optional.of(usercache_usercacheentry.getProfile());
        } else {
            optional = GameProfileCache.lookupGameProfile(this.profileRepository, s);
            if (optional.isPresent()) {
                this.add(optional.get());
                flag = false;
            }
        }
        if (flag && !SpigotConfig.saveUserCacheOnStopOnly) {
            this.save();
        }
        return optional;
    }

    public CompletableFuture<Optional<GameProfile>> getAsync(String s) {
        if (this.executor == null) {
            throw new IllegalStateException("No executor");
        }
        CompletableFuture<Optional<GameProfile>> completablefuture = this.requests.get(s);
        if (completablefuture != null) {
            return completablefuture;
        }
        CompletionStage completablefuture1 = CompletableFuture.supplyAsync(() -> this.get(s), Util.backgroundExecutor().forName("getProfile")).whenCompleteAsync((optional, throwable) -> this.requests.remove(s), this.executor);
        this.requests.put(s, (CompletableFuture<Optional<GameProfile>>)completablefuture1);
        return completablefuture1;
    }

    public Optional<GameProfile> get(UUID uuid) {
        GameProfileInfo usercache_usercacheentry = this.profilesByUUID.get(uuid);
        if (usercache_usercacheentry == null) {
            return Optional.empty();
        }
        usercache_usercacheentry.setLastAccess(this.getNextOperation());
        return Optional.of(usercache_usercacheentry.getProfile());
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public void clearExecutor() {
        this.executor = null;
    }

    private static DateFormat createDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z", Locale.ROOT);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<GameProfileInfo> load() {
        ArrayList list = Lists.newArrayList();
        try (BufferedReader reader2222 = Files.newReader((File)this.file, (Charset)StandardCharsets.UTF_8);){
            JsonArray jsonarray = (JsonArray)this.gson.fromJson((Reader)reader2222, JsonArray.class);
            if (jsonarray == null) {
                ArrayList arrayList = list;
                return arrayList;
            }
            DateFormat dateformat = GameProfileCache.createDateFormat();
            jsonarray.forEach(jsonelement -> {
                Optional<GameProfileInfo> optional = GameProfileCache.readGameProfile(jsonelement, dateformat);
                Objects.requireNonNull(list);
                optional.ifPresent(list::add);
            });
            return list;
        }
        catch (FileNotFoundException reader2222) {
            return list;
        }
        catch (JsonSyntaxException | NullPointerException ex) {
            LOGGER.warn("Usercache.json is corrupted or has bad formatting. Deleting it to prevent further issues.");
            this.file.delete();
            return list;
        }
        catch (JsonParseException | IOException ioexception) {
            LOGGER.warn("Failed to load profile cache {}", (Object)this.file, (Object)ioexception);
        }
        return list;
    }

    public void save() {
        JsonArray jsonarray = new JsonArray();
        DateFormat dateformat = GameProfileCache.createDateFormat();
        this.getTopMRUProfiles(SpigotConfig.userCacheCap).forEach(usercache_usercacheentry -> jsonarray.add(GameProfileCache.writeGameProfile(usercache_usercacheentry, dateformat)));
        String s = this.gson.toJson((JsonElement)jsonarray);
        try (BufferedWriter writer = Files.newWriter((File)this.file, (Charset)StandardCharsets.UTF_8);){
            writer.write(s);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Stream<GameProfileInfo> getTopMRUProfiles(int i) {
        return ImmutableList.copyOf(this.profilesByUUID.values()).stream().sorted(Comparator.comparing(GameProfileInfo::getLastAccess).reversed()).limit(i);
    }

    private static JsonElement writeGameProfile(GameProfileInfo usercache_usercacheentry, DateFormat dateformat) {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("name", usercache_usercacheentry.getProfile().getName());
        jsonobject.addProperty("uuid", usercache_usercacheentry.getProfile().getId().toString());
        jsonobject.addProperty("expiresOn", dateformat.format(usercache_usercacheentry.getExpirationDate()));
        return jsonobject;
    }

    private static Optional<GameProfileInfo> readGameProfile(JsonElement jsonelement, DateFormat dateformat) {
        if (jsonelement.isJsonObject()) {
            JsonObject jsonobject = jsonelement.getAsJsonObject();
            JsonElement jsonelement1 = jsonobject.get("name");
            JsonElement jsonelement2 = jsonobject.get("uuid");
            JsonElement jsonelement3 = jsonobject.get("expiresOn");
            if (jsonelement1 != null && jsonelement2 != null) {
                String s = jsonelement2.getAsString();
                String s1 = jsonelement1.getAsString();
                Date date = null;
                if (jsonelement3 != null) {
                    try {
                        date = dateformat.parse(jsonelement3.getAsString());
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                if (s1 != null && s != null && date != null) {
                    UUID uuid;
                    try {
                        uuid = UUID.fromString(s);
                    }
                    catch (Throwable throwable) {
                        return Optional.empty();
                    }
                    return Optional.of(new GameProfileInfo(new GameProfile(uuid, s1), date));
                }
                return Optional.empty();
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static class GameProfileInfo {
        private final GameProfile profile;
        final Date expirationDate;
        private volatile long lastAccess;

        GameProfileInfo(GameProfile gameprofile, Date date) {
            this.profile = gameprofile;
            this.expirationDate = date;
        }

        public GameProfile getProfile() {
            return this.profile;
        }

        public Date getExpirationDate() {
            return this.expirationDate;
        }

        public void setLastAccess(long i) {
            this.lastAccess = i;
        }

        public long getLastAccess() {
            return this.lastAccess;
        }
    }
}

