/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.players.BanListEntry;

public class UserBanListEntry
extends BanListEntry<GameProfile> {
    public UserBanListEntry(@Nullable GameProfile gameprofile) {
        this(gameprofile, (Date)null, (String)null, (Date)null, (String)null);
    }

    public UserBanListEntry(@Nullable GameProfile gameprofile, @Nullable Date date, @Nullable String s, @Nullable Date date1, @Nullable String s1) {
        super(gameprofile, date, s, date1, s1);
    }

    public UserBanListEntry(JsonObject jsonobject) {
        super(UserBanListEntry.createGameProfile(jsonobject), jsonobject);
    }

    @Override
    protected void serialize(JsonObject jsonobject) {
        if (this.getUser() != null) {
            jsonobject.addProperty("uuid", ((GameProfile)this.getUser()).getId().toString());
            jsonobject.addProperty("name", ((GameProfile)this.getUser()).getName());
            super.serialize(jsonobject);
        }
    }

    @Override
    public Component getDisplayName() {
        GameProfile gameprofile = (GameProfile)this.getUser();
        return gameprofile != null ? Component.literal(gameprofile.getName()) : Component.translatable("commands.banlist.entry.unknown");
    }

    @Nullable
    private static GameProfile createGameProfile(JsonObject jsonobject) {
        UUID uuid = null;
        String name = null;
        if (jsonobject.has("uuid")) {
            String s = jsonobject.get("uuid").getAsString();
            try {
                uuid = UUID.fromString(s);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (jsonobject.has("name")) {
            name = jsonobject.get("name").getAsString();
        }
        if (uuid != null || name != null) {
            return new GameProfile(uuid, name);
        }
        return null;
    }
}

