/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.rcon;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class NetworkDataOutputStream {
    private final ByteArrayOutputStream outputStream;
    private final DataOutputStream dataOutputStream;

    public NetworkDataOutputStream(int var0) {
        this.outputStream = new ByteArrayOutputStream(var0);
        this.dataOutputStream = new DataOutputStream(this.outputStream);
    }

    public void writeBytes(byte[] var0) throws IOException {
        this.dataOutputStream.write(var0, 0, var0.length);
    }

    public void writeString(String var0) throws IOException {
        this.dataOutputStream.writeBytes(var0);
        this.dataOutputStream.write(0);
    }

    public void write(int var0) throws IOException {
        this.dataOutputStream.write(var0);
    }

    public void writeShort(short var0) throws IOException {
        this.dataOutputStream.writeShort(Short.reverseBytes(var0));
    }

    public void writeInt(int var0) throws IOException {
        this.dataOutputStream.writeInt(Integer.reverseBytes(var0));
    }

    public void writeFloat(float var0) throws IOException {
        this.dataOutputStream.writeInt(Integer.reverseBytes(Float.floatToIntBits(var0)));
    }

    public byte[] toByteArray() {
        return this.outputStream.toByteArray();
    }

    public void reset() {
        this.outputStream.reset();
    }
}

