/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.annotations.VisibleForTesting;
import java.util.AbstractList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.SequencedCollection;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.util.ListAndDeque;

public class ArrayListDeque<T>
extends AbstractList<T>
implements ListAndDeque<T> {
    private static final int MIN_GROWTH = 1;
    private Object[] contents;
    private int head;
    private int size;

    public ArrayListDeque() {
        this(1);
    }

    public ArrayListDeque(int var0) {
        this.contents = new Object[var0];
        this.head = 0;
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @VisibleForTesting
    public int capacity() {
        return this.contents.length;
    }

    private int getIndex(int var0) {
        return (var0 + this.head) % this.contents.length;
    }

    @Override
    public T get(int var0) {
        this.verifyIndexInRange(var0);
        return this.getInner(this.getIndex(var0));
    }

    private static void verifyIndexInRange(int var0, int var1) {
        if (var0 < 0 || var0 >= var1) {
            throw new IndexOutOfBoundsException(var0);
        }
    }

    private void verifyIndexInRange(int var0) {
        ArrayListDeque.verifyIndexInRange(var0, this.size);
    }

    private T getInner(int var0) {
        return (T)this.contents[var0];
    }

    @Override
    public T set(int var0, T var1) {
        this.verifyIndexInRange(var0);
        Objects.requireNonNull(var1);
        int var2 = this.getIndex(var0);
        T var3 = this.getInner(var2);
        this.contents[var2] = var1;
        return var3;
    }

    @Override
    public void add(int var0, T var1) {
        ArrayListDeque.verifyIndexInRange(var0, this.size + 1);
        Objects.requireNonNull(var1);
        if (this.size == this.contents.length) {
            this.grow();
        }
        int var2 = this.getIndex(var0);
        if (var0 == this.size) {
            this.contents[var2] = var1;
        } else if (var0 == 0) {
            --this.head;
            if (this.head < 0) {
                this.head += this.contents.length;
            }
            this.contents[this.getIndex((int)0)] = var1;
        } else {
            for (int var3 = this.size - 1; var3 >= var0; --var3) {
                this.contents[this.getIndex((int)(var3 + 1))] = this.contents[this.getIndex(var3)];
            }
            this.contents[var2] = var1;
        }
        ++this.modCount;
        ++this.size;
    }

    private void grow() {
        int var0 = this.contents.length + Math.max(this.contents.length >> 1, 1);
        Object[] var1 = new Object[var0];
        this.copyCount(var1, this.size);
        this.head = 0;
        this.contents = var1;
    }

    @Override
    public T remove(int var0) {
        this.verifyIndexInRange(var0);
        int var1 = this.getIndex(var0);
        T var2 = this.getInner(var1);
        if (var0 == 0) {
            this.contents[var1] = null;
            ++this.head;
        } else if (var0 == this.size - 1) {
            this.contents[var1] = null;
        } else {
            for (int var3 = var0 + 1; var3 < this.size; ++var3) {
                this.contents[this.getIndex((int)(var3 - 1))] = this.get(var3);
            }
            this.contents[this.getIndex((int)(this.size - 1))] = null;
        }
        ++this.modCount;
        --this.size;
        return var2;
    }

    @Override
    public boolean removeIf(Predicate<? super T> var0) {
        int var1 = 0;
        for (int var2 = 0; var2 < this.size; ++var2) {
            T var3 = this.get(var2);
            if (var0.test(var3)) {
                ++var1;
                continue;
            }
            if (var1 == 0) continue;
            this.contents[this.getIndex((int)(var2 - var1))] = var3;
            this.contents[this.getIndex((int)var2)] = null;
        }
        this.modCount += var1;
        this.size -= var1;
        return var1 != 0;
    }

    private void copyCount(Object[] var0, int var1) {
        for (int var2 = 0; var2 < var1; ++var2) {
            var0[var2] = this.get(var2);
        }
    }

    @Override
    public void replaceAll(UnaryOperator<T> var0) {
        for (int var1 = 0; var1 < this.size; ++var1) {
            int var2 = this.getIndex(var1);
            this.contents[var2] = Objects.requireNonNull(var0.apply(this.getInner(var1)));
        }
    }

    @Override
    public void forEach(Consumer<? super T> var0) {
        for (int var1 = 0; var1 < this.size; ++var1) {
            var0.accept(this.get(var1));
        }
    }

    @Override
    public void addFirst(T var0) {
        this.add(0, var0);
    }

    @Override
    public void addLast(T var0) {
        this.add(this.size, var0);
    }

    @Override
    public boolean offerFirst(T var0) {
        this.addFirst(var0);
        return true;
    }

    @Override
    public boolean offerLast(T var0) {
        this.addLast(var0);
        return true;
    }

    @Override
    public T removeFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.remove(0);
    }

    @Override
    public T removeLast() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.remove(this.size - 1);
    }

    @Override
    public ListAndDeque<T> reversed() {
        return new ReversedView(this);
    }

    @Override
    @Nullable
    public T pollFirst() {
        if (this.size == 0) {
            return null;
        }
        return this.removeFirst();
    }

    @Override
    @Nullable
    public T pollLast() {
        if (this.size == 0) {
            return null;
        }
        return this.removeLast();
    }

    @Override
    public T getFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.get(0);
    }

    @Override
    public T getLast() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.get(this.size - 1);
    }

    @Override
    @Nullable
    public T peekFirst() {
        if (this.size == 0) {
            return null;
        }
        return this.getFirst();
    }

    @Override
    @Nullable
    public T peekLast() {
        if (this.size == 0) {
            return null;
        }
        return this.getLast();
    }

    @Override
    public boolean removeFirstOccurrence(Object var0) {
        for (int var1 = 0; var1 < this.size; ++var1) {
            T var2 = this.get(var1);
            if (!Objects.equals(var0, var2)) continue;
            this.remove(var1);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeLastOccurrence(Object var0) {
        for (int var1 = this.size - 1; var1 >= 0; --var1) {
            T var2 = this.get(var1);
            if (!Objects.equals(var0, var2)) continue;
            this.remove(var1);
            return true;
        }
        return false;
    }

    @Override
    public Iterator<T> descendingIterator() {
        return new DescendingIterator();
    }

    @Override
    public /* synthetic */ List reversed() {
        return this.reversed();
    }

    @Override
    public /* synthetic */ SequencedCollection reversed() {
        return this.reversed();
    }

    @Override
    public /* synthetic */ Deque reversed() {
        return this.reversed();
    }

    class ReversedView
    extends AbstractList<T>
    implements ListAndDeque<T> {
        private final ArrayListDeque<T> source;

        public ReversedView(ArrayListDeque var1) {
            this.source = var1;
        }

        @Override
        public ListAndDeque<T> reversed() {
            return this.source;
        }

        @Override
        public T getFirst() {
            return this.source.getLast();
        }

        @Override
        public T getLast() {
            return this.source.getFirst();
        }

        @Override
        public void addFirst(T var0) {
            this.source.addLast(var0);
        }

        @Override
        public void addLast(T var0) {
            this.source.addFirst(var0);
        }

        @Override
        public boolean offerFirst(T var0) {
            return this.source.offerLast(var0);
        }

        @Override
        public boolean offerLast(T var0) {
            return this.source.offerFirst(var0);
        }

        @Override
        public T pollFirst() {
            return this.source.pollLast();
        }

        @Override
        public T pollLast() {
            return this.source.pollFirst();
        }

        @Override
        public T peekFirst() {
            return this.source.peekLast();
        }

        @Override
        public T peekLast() {
            return this.source.peekFirst();
        }

        @Override
        public T removeFirst() {
            return this.source.removeLast();
        }

        @Override
        public T removeLast() {
            return this.source.removeFirst();
        }

        @Override
        public boolean removeFirstOccurrence(Object var0) {
            return this.source.removeLastOccurrence(var0);
        }

        @Override
        public boolean removeLastOccurrence(Object var0) {
            return this.source.removeFirstOccurrence(var0);
        }

        @Override
        public Iterator<T> descendingIterator() {
            return this.source.iterator();
        }

        @Override
        public int size() {
            return this.source.size();
        }

        @Override
        public boolean isEmpty() {
            return this.source.isEmpty();
        }

        @Override
        public boolean contains(Object var0) {
            return this.source.contains(var0);
        }

        @Override
        public T get(int var0) {
            return this.source.get(this.reverseIndex(var0));
        }

        @Override
        public T set(int var0, T var1) {
            return this.source.set(this.reverseIndex(var0), var1);
        }

        @Override
        public void add(int var0, T var1) {
            this.source.add(this.reverseIndex(var0) + 1, var1);
        }

        @Override
        public T remove(int var0) {
            return this.source.remove(this.reverseIndex(var0));
        }

        @Override
        public int indexOf(Object var0) {
            return this.reverseIndex(this.source.lastIndexOf(var0));
        }

        @Override
        public int lastIndexOf(Object var0) {
            return this.reverseIndex(this.source.indexOf(var0));
        }

        @Override
        public List<T> subList(int var0, int var1) {
            return this.source.subList(this.reverseIndex(var1) + 1, this.reverseIndex(var0) + 1).reversed();
        }

        @Override
        public Iterator<T> iterator() {
            return this.source.descendingIterator();
        }

        @Override
        public void clear() {
            this.source.clear();
        }

        private int reverseIndex(int var0) {
            return var0 == -1 ? -1 : this.source.size() - 1 - var0;
        }

        @Override
        public /* synthetic */ List reversed() {
            return this.reversed();
        }

        @Override
        public /* synthetic */ SequencedCollection reversed() {
            return this.reversed();
        }

        @Override
        public /* synthetic */ Deque reversed() {
            return this.reversed();
        }
    }

    class DescendingIterator
    implements Iterator<T> {
        private int index;

        public DescendingIterator() {
            this.index = ArrayListDeque.this.size() - 1;
        }

        @Override
        public boolean hasNext() {
            return this.index >= 0;
        }

        @Override
        public T next() {
            return ArrayListDeque.this.get(this.index--);
        }

        @Override
        public void remove() {
            ArrayListDeque.this.remove(this.index + 1);
        }
    }
}

