/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.List;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.StringDecomposer;

@FunctionalInterface
public interface FormattedCharSequence {
    public static final FormattedCharSequence EMPTY = var0 -> true;

    public boolean accept(FormattedCharSink var1);

    public static FormattedCharSequence codepoint(int var0, Style var1) {
        return var2 -> var2.accept(0, var1, var0);
    }

    public static FormattedCharSequence forward(String var0, Style var1) {
        if (var0.isEmpty()) {
            return EMPTY;
        }
        return var2 -> StringDecomposer.iterate(var0, var1, var2);
    }

    public static FormattedCharSequence forward(String var0, Style var1, Int2IntFunction var2) {
        if (var0.isEmpty()) {
            return EMPTY;
        }
        return var3 -> StringDecomposer.iterate(var0, var1, FormattedCharSequence.decorateOutput(var3, var2));
    }

    public static FormattedCharSequence backward(String var0, Style var1) {
        if (var0.isEmpty()) {
            return EMPTY;
        }
        return var2 -> StringDecomposer.iterateBackwards(var0, var1, var2);
    }

    public static FormattedCharSequence backward(String var0, Style var1, Int2IntFunction var2) {
        if (var0.isEmpty()) {
            return EMPTY;
        }
        return var3 -> StringDecomposer.iterateBackwards(var0, var1, FormattedCharSequence.decorateOutput(var3, var2));
    }

    public static FormattedCharSink decorateOutput(FormattedCharSink var0, Int2IntFunction var1) {
        return (var2, var3, var4) -> var0.accept(var2, var3, (Integer)var1.apply((Object)var4));
    }

    public static FormattedCharSequence composite() {
        return EMPTY;
    }

    public static FormattedCharSequence composite(FormattedCharSequence var0) {
        return var0;
    }

    public static FormattedCharSequence composite(FormattedCharSequence var0, FormattedCharSequence var1) {
        return FormattedCharSequence.fromPair(var0, var1);
    }

    public static FormattedCharSequence composite(FormattedCharSequence ... var0) {
        return FormattedCharSequence.fromList((List<FormattedCharSequence>)ImmutableList.copyOf((Object[])var0));
    }

    public static FormattedCharSequence composite(List<FormattedCharSequence> var0) {
        int var1 = var0.size();
        switch (var1) {
            case 0: {
                return EMPTY;
            }
            case 1: {
                return var0.get(0);
            }
            case 2: {
                return FormattedCharSequence.fromPair(var0.get(0), var0.get(1));
            }
        }
        return FormattedCharSequence.fromList((List<FormattedCharSequence>)ImmutableList.copyOf(var0));
    }

    public static FormattedCharSequence fromPair(FormattedCharSequence var0, FormattedCharSequence var1) {
        return var2 -> var0.accept(var2) && var1.accept(var2);
    }

    public static FormattedCharSequence fromList(List<FormattedCharSequence> var0) {
        return var1 -> {
            for (FormattedCharSequence var3 : var0) {
                if (var3.accept(var1)) continue;
                return false;
            }
            return true;
        };
    }
}

