/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.util.concurrent.atomic.AtomicInteger;

public class TickThrottler {
    private final int incrementStep;
    private final int threshold;
    private final AtomicInteger c = new AtomicInteger();

    public TickThrottler(int i, int j) {
        this.incrementStep = i;
        this.threshold = j;
    }

    public void increment() {
        this.c.addAndGet(this.incrementStep);
    }

    public void tick() {
        int val;
        while ((val = this.c.get()) > 0 && !this.c.compareAndSet(val, val - 1)) {
        }
    }

    public boolean isUnderThreshold() {
        return this.c.get() < this.threshold;
    }

    public boolean isIncrementAndUnderThreshold() {
        return this.isIncrementAndUnderThreshold(this.incrementStep, this.threshold);
    }

    public boolean isIncrementAndUnderThreshold(int incrementStep, int threshold) {
        return this.c.addAndGet(incrementStep) < threshold;
    }
}

