/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.LenientJsonParser;

public class LegacyComponentDataFixUtils {
    private static final String EMPTY_CONTENTS = LegacyComponentDataFixUtils.createTextComponentJson("");

    public static <T> Dynamic<T> createPlainTextComponent(DynamicOps<T> var0, String var1) {
        String var2 = LegacyComponentDataFixUtils.createTextComponentJson(var1);
        return new Dynamic(var0, var0.createString(var2));
    }

    public static <T> Dynamic<T> createEmptyComponent(DynamicOps<T> var0) {
        return new Dynamic(var0, var0.createString(EMPTY_CONTENTS));
    }

    public static String createTextComponentJson(String var0) {
        JsonObject var1 = new JsonObject();
        var1.addProperty("text", var0);
        return GsonHelper.toStableString((JsonElement)var1);
    }

    public static String createTranslatableComponentJson(String var0) {
        JsonObject var1 = new JsonObject();
        var1.addProperty("translate", var0);
        return GsonHelper.toStableString((JsonElement)var1);
    }

    public static <T> Dynamic<T> createTranslatableComponent(DynamicOps<T> var0, String var1) {
        String var2 = LegacyComponentDataFixUtils.createTranslatableComponentJson(var1);
        return new Dynamic(var0, var0.createString(var2));
    }

    public static String rewriteFromLenient(String var0) {
        if (var0.isEmpty() || var0.equals("null")) {
            return EMPTY_CONTENTS;
        }
        char var1 = var0.charAt(0);
        char var2 = var0.charAt(var0.length() - 1);
        if (var1 == '\"' && var2 == '\"' || var1 == '{' && var2 == '}' || var1 == '[' && var2 == ']') {
            try {
                JsonElement var3 = LenientJsonParser.parse(var0);
                if (var3.isJsonPrimitive()) {
                    return LegacyComponentDataFixUtils.createTextComponentJson(var3.getAsString());
                }
                return GsonHelper.toStableString(var3);
            }
            catch (JsonParseException jsonParseException) {
                // empty catch block
            }
        }
        return LegacyComponentDataFixUtils.createTextComponentJson(var0);
    }

    public static Optional<String> extractTranslationString(String var0) {
        try {
            JsonObject var2;
            JsonElement var3;
            JsonElement var1 = LenientJsonParser.parse(var0);
            if (var1.isJsonObject() && (var3 = (var2 = var1.getAsJsonObject()).get("translate")) != null && var3.isJsonPrimitive()) {
                return Optional.of(var3.getAsString());
            }
        }
        catch (JsonParseException jsonParseException) {
            // empty catch block
        }
        return Optional.empty();
    }
}

