/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.util.datafix.ExtraDataFixUtils;
import net.minecraft.util.datafix.LegacyComponentDataFixUtils;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.schemas.NamespacedSchema;

public class BlockEntityCustomNameToComponentFix
extends DataFix {
    private static final Set<String> NAMEABLE_BLOCK_ENTITIES = Set.of("minecraft:beacon", "minecraft:banner", "minecraft:brewing_stand", "minecraft:chest", "minecraft:trapped_chest", "minecraft:dispenser", "minecraft:dropper", "minecraft:enchanting_table", "minecraft:furnace", "minecraft:hopper", "minecraft:shulker_box");

    public BlockEntityCustomNameToComponentFix(Schema var0) {
        super(var0, true);
    }

    public TypeRewriteRule makeRule() {
        OpticFinder var0 = DSL.fieldFinder((String)"id", NamespacedSchema.namespacedString());
        Type var1 = this.getInputSchema().getType(References.BLOCK_ENTITY);
        Type var2 = this.getOutputSchema().getType(References.BLOCK_ENTITY);
        Type<?> var32 = ExtraDataFixUtils.patchSubType(var1, var1, var2);
        return this.fixTypeEverywhereTyped("BlockEntityCustomNameToComponentFix", var1, var2, var3 -> {
            Optional var4 = var3.getOptional(var0);
            if (var4.isPresent() && !NAMEABLE_BLOCK_ENTITIES.contains(var4.get())) {
                return ExtraDataFixUtils.cast(var2, var3);
            }
            return Util.writeAndReadTypedOrThrow(ExtraDataFixUtils.cast(var32, var3), var2, BlockEntityCustomNameToComponentFix::fixTagCustomName);
        });
    }

    public static <T> Dynamic<T> fixTagCustomName(Dynamic<T> var0) {
        String var1 = var0.get("CustomName").asString("");
        if (var1.isEmpty()) {
            return var0.remove("CustomName");
        }
        return var0.set("CustomName", LegacyComponentDataFixUtils.createPlainTextComponent(var0.getOps(), var1));
    }
}

