/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.List;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.util.datafix.PackedBitStorage;
import net.minecraft.util.datafix.fixes.References;

public class LeavesFix
extends DataFix {
    private static final int NORTH_WEST_MASK = 128;
    private static final int WEST_MASK = 64;
    private static final int SOUTH_WEST_MASK = 32;
    private static final int SOUTH_MASK = 16;
    private static final int SOUTH_EAST_MASK = 8;
    private static final int EAST_MASK = 4;
    private static final int NORTH_EAST_MASK = 2;
    private static final int NORTH_MASK = 1;
    private static final int[][] DIRECTIONS = new int[][]{{-1, 0, 0}, {1, 0, 0}, {0, -1, 0}, {0, 1, 0}, {0, 0, -1}, {0, 0, 1}};
    private static final int DECAY_DISTANCE = 7;
    private static final int SIZE_BITS = 12;
    private static final int SIZE = 4096;
    static final Object2IntMap<String> LEAVES = (Object2IntMap)DataFixUtils.make((Object)new Object2IntOpenHashMap(), var0 -> {
        var0.put((Object)"minecraft:acacia_leaves", 0);
        var0.put((Object)"minecraft:birch_leaves", 1);
        var0.put((Object)"minecraft:dark_oak_leaves", 2);
        var0.put((Object)"minecraft:jungle_leaves", 3);
        var0.put((Object)"minecraft:oak_leaves", 4);
        var0.put((Object)"minecraft:spruce_leaves", 5);
    });
    static final Set<String> LOGS = ImmutableSet.of((Object)"minecraft:acacia_bark", (Object)"minecraft:birch_bark", (Object)"minecraft:dark_oak_bark", (Object)"minecraft:jungle_bark", (Object)"minecraft:oak_bark", (Object)"minecraft:spruce_bark", (Object[])new String[]{"minecraft:acacia_log", "minecraft:birch_log", "minecraft:dark_oak_log", "minecraft:jungle_log", "minecraft:oak_log", "minecraft:spruce_log", "minecraft:stripped_acacia_log", "minecraft:stripped_birch_log", "minecraft:stripped_dark_oak_log", "minecraft:stripped_jungle_log", "minecraft:stripped_oak_log", "minecraft:stripped_spruce_log"});

    public LeavesFix(Schema var0, boolean var1) {
        super(var0, var1);
    }

    protected TypeRewriteRule makeRule() {
        Type var0 = this.getInputSchema().getType(References.CHUNK);
        OpticFinder var1 = var0.findField("Level");
        OpticFinder var2 = var1.type().findField("Sections");
        Type var32 = var2.type();
        if (!(var32 instanceof List.ListType)) {
            throw new IllegalStateException("Expecting sections to be a list.");
        }
        Type var4 = ((List.ListType)var32).getElement();
        OpticFinder var5 = DSL.typeFinder((Type)var4);
        return this.fixTypeEverywhereTyped("Leaves fix", var0, var3 -> var3.updateTyped(var1, var22 -> {
            Object var3 = new int[]{0};
            Typed var4 = var22.updateTyped(var2, var2 -> {
                int var10;
                int var9;
                Object var3 = new Int2ObjectOpenHashMap(var2.getAllTyped(var5).stream().map(var0 -> new LeavesSection((Typed<?>)var0, this.getInputSchema())).collect(Collectors.toMap(Section::getIndex, var0 -> var0)));
                if (var3.values().stream().allMatch(Section::isSkippable)) {
                    return var2;
                }
                ArrayList var4 = Lists.newArrayList();
                for (int var5 = 0; var5 < 7; ++var5) {
                    var4.add(new IntOpenHashSet());
                }
                for (LeavesSection var6 : var3.values()) {
                    if (var6.isSkippable()) continue;
                    for (int var7 = 0; var7 < 4096; ++var7) {
                        int var8 = var6.getBlock(var7);
                        if (var6.isLog(var8)) {
                            ((IntSet)var4.get(0)).add(var6.getIndex() << 12 | var7);
                            continue;
                        }
                        if (!var6.isLeaf(var8)) continue;
                        var9 = this.getX(var7);
                        var10 = this.getZ(var7);
                        var1[0] = var3[0] | LeavesFix.getSideMask(var9 == 0, var9 == 15, var10 == 0, var10 == 15);
                    }
                }
                for (int var5 = 1; var5 < 7; ++var5) {
                    LeavesSection var6;
                    var6 = (IntSet)var4.get(var5 - 1);
                    IntSet var7 = (IntSet)var4.get(var5);
                    IntIterator var8 = var6.iterator();
                    while (var8.hasNext()) {
                        var9 = var8.nextInt();
                        var10 = this.getX(var9);
                        int var11 = this.getY(var9);
                        int var12 = this.getZ(var9);
                        for (int[] var16 : DIRECTIONS) {
                            int var23;
                            int var21;
                            int var22;
                            LeavesSection var20;
                            int var17 = var10 + var16[0];
                            int var18 = var11 + var16[1];
                            int var19 = var12 + var16[2];
                            if (var17 < 0 || var17 > 15 || var19 < 0 || var19 > 15 || var18 < 0 || var18 > 255 || (var20 = (LeavesSection)var3.get(var18 >> 4)) == null || var20.isSkippable() || !var20.isLeaf(var22 = var20.getBlock(var21 = LeavesFix.getIndex(var17, var18 & 0xF, var19))) || (var23 = var20.getDistance(var22)) <= var5) continue;
                            var20.setDistance(var21, var22, var5);
                            var7.add(LeavesFix.getIndex(var17, var18, var19));
                        }
                    }
                }
                return var2.updateTyped(var5, arg_0 -> LeavesFix.lambda$makeRule$3((Int2ObjectMap)var3, arg_0));
            });
            if (var3[0] != 0) {
                var4 = var4.update(DSL.remainderFinder(), var1 -> {
                    Dynamic var2 = (Dynamic)DataFixUtils.orElse((Optional)var1.get("UpgradeData").result(), (Object)var1.emptyMap());
                    return var1.set("UpgradeData", var2.set("Sides", var1.createByte((byte)(var2.get("Sides").asByte((byte)0) | var3[0]))));
                });
            }
            return var4;
        }));
    }

    public static int getIndex(int var0, int var1, int var2) {
        return var1 << 8 | var2 << 4 | var0;
    }

    private int getX(int var0) {
        return var0 & 0xF;
    }

    private int getY(int var0) {
        return var0 >> 8 & 0xFF;
    }

    private int getZ(int var0) {
        return var0 >> 4 & 0xF;
    }

    public static int getSideMask(boolean var0, boolean var1, boolean var2, boolean var3) {
        int var4 = 0;
        if (var2) {
            var4 = var1 ? (var4 |= 2) : (var0 ? (var4 |= 0x80) : (var4 |= 1));
        } else if (var3) {
            var4 = var0 ? (var4 |= 0x20) : (var1 ? (var4 |= 8) : (var4 |= 0x10));
        } else if (var1) {
            var4 |= 4;
        } else if (var0) {
            var4 |= 0x40;
        }
        return var4;
    }

    private static /* synthetic */ Typed lambda$makeRule$3(Int2ObjectMap var0, Typed var1) {
        return ((LeavesSection)var0.get(((Dynamic)var1.get(DSL.remainderFinder())).get("Y").asInt(0))).write(var1);
    }

    public static final class LeavesSection
    extends Section {
        private static final String PERSISTENT = "persistent";
        private static final String DECAYABLE = "decayable";
        private static final String DISTANCE = "distance";
        @Nullable
        private IntSet leaveIds;
        @Nullable
        private IntSet logIds;
        @Nullable
        private Int2IntMap stateToIdMap;

        public LeavesSection(Typed<?> var0, Schema var1) {
            super(var0, var1);
        }

        @Override
        protected boolean skippable() {
            this.leaveIds = new IntOpenHashSet();
            this.logIds = new IntOpenHashSet();
            this.stateToIdMap = new Int2IntOpenHashMap();
            for (int var0 = 0; var0 < this.palette.size(); ++var0) {
                Dynamic var1 = (Dynamic)this.palette.get(var0);
                String var2 = var1.get("Name").asString("");
                if (LEAVES.containsKey((Object)var2)) {
                    boolean var3 = Objects.equals(var1.get("Properties").get(DECAYABLE).asString(""), "false");
                    this.leaveIds.add(var0);
                    this.stateToIdMap.put(this.getStateId(var2, var3, 7), var0);
                    this.palette.set(var0, this.makeLeafTag(var1, var2, var3, 7));
                }
                if (!LOGS.contains(var2)) continue;
                this.logIds.add(var0);
            }
            return this.leaveIds.isEmpty() && this.logIds.isEmpty();
        }

        private Dynamic<?> makeLeafTag(Dynamic<?> var0, String var1, boolean var2, int var3) {
            Dynamic var4 = var0.emptyMap();
            var4 = var4.set(PERSISTENT, var4.createString(var2 ? "true" : "false"));
            var4 = var4.set(DISTANCE, var4.createString(Integer.toString(var3)));
            Dynamic var5 = var0.emptyMap();
            var5 = var5.set("Properties", var4);
            var5 = var5.set("Name", var5.createString(var1));
            return var5;
        }

        public boolean isLog(int var0) {
            return this.logIds.contains(var0);
        }

        public boolean isLeaf(int var0) {
            return this.leaveIds.contains(var0);
        }

        int getDistance(int var0) {
            if (this.isLog(var0)) {
                return 0;
            }
            return Integer.parseInt(((Dynamic)this.palette.get(var0)).get("Properties").get(DISTANCE).asString(""));
        }

        void setDistance(int var0, int var1, int var2) {
            int var7;
            boolean var5;
            Dynamic var3 = (Dynamic)this.palette.get(var1);
            String var4 = var3.get("Name").asString("");
            int var6 = this.getStateId(var4, var5 = Objects.equals(var3.get("Properties").get(PERSISTENT).asString(""), "true"), var2);
            if (!this.stateToIdMap.containsKey(var6)) {
                var7 = this.palette.size();
                this.leaveIds.add(var7);
                this.stateToIdMap.put(var6, var7);
                this.palette.add(this.makeLeafTag(var3, var4, var5, var2));
            }
            var7 = this.stateToIdMap.get(var6);
            if (1 << this.storage.getBits() <= var7) {
                PackedBitStorage var8 = new PackedBitStorage(this.storage.getBits() + 1, 4096);
                for (int var9 = 0; var9 < 4096; ++var9) {
                    var8.set(var9, this.storage.get(var9));
                }
                this.storage = var8;
            }
            this.storage.set(var0, var7);
        }
    }

    public static abstract class Section {
        protected static final String BLOCK_STATES_TAG = "BlockStates";
        protected static final String NAME_TAG = "Name";
        protected static final String PROPERTIES_TAG = "Properties";
        private final Type<Pair<String, Dynamic<?>>> blockStateType = DSL.named((String)References.BLOCK_STATE.typeName(), (Type)DSL.remainderType());
        protected final OpticFinder<List<Pair<String, Dynamic<?>>>> paletteFinder = DSL.fieldFinder((String)"Palette", (Type)DSL.list(this.blockStateType));
        protected final List<Dynamic<?>> palette;
        protected final int index;
        @Nullable
        protected PackedBitStorage storage;

        public Section(Typed<?> var02, Schema var1) {
            if (!Objects.equals(var1.getType(References.BLOCK_STATE), this.blockStateType)) {
                throw new IllegalStateException("Block state type is not what was expected.");
            }
            Optional var2 = var02.getOptional(this.paletteFinder);
            this.palette = var2.map(var0 -> var0.stream().map(Pair::getSecond).collect(Collectors.toList())).orElse((List)ImmutableList.of());
            Dynamic var3 = (Dynamic)var02.get(DSL.remainderFinder());
            this.index = var3.get("Y").asInt(0);
            this.readStorage(var3);
        }

        protected void readStorage(Dynamic<?> var0) {
            if (this.skippable()) {
                this.storage = null;
            } else {
                long[] var1 = var0.get(BLOCK_STATES_TAG).asLongStream().toArray();
                int var2 = Math.max(4, DataFixUtils.ceillog2((int)this.palette.size()));
                this.storage = new PackedBitStorage(var2, 4096, var1);
            }
        }

        public Typed<?> write(Typed<?> var02) {
            if (this.isSkippable()) {
                return var02;
            }
            return var02.update(DSL.remainderFinder(), var0 -> var0.set(BLOCK_STATES_TAG, var0.createLongList(Arrays.stream(this.storage.getRaw())))).set(this.paletteFinder, this.palette.stream().map(var0 -> Pair.of((Object)References.BLOCK_STATE.typeName(), (Object)var0)).collect(Collectors.toList()));
        }

        public boolean isSkippable() {
            return this.storage == null;
        }

        public int getBlock(int var0) {
            return this.storage.get(var0);
        }

        protected int getStateId(String var0, boolean var1, int var2) {
            return LEAVES.get((Object)var0) << 5 | (var1 ? 16 : 0) | var2;
        }

        int getIndex() {
            return this.index;
        }

        protected abstract boolean skippable();
    }
}

