/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.Util;
import net.minecraft.util.datafix.ExtraDataFixUtils;
import net.minecraft.util.datafix.fixes.References;

public class ProjectileStoredWeaponFix
extends DataFix {
    public ProjectileStoredWeaponFix(Schema var0) {
        super(var0, true);
    }

    protected TypeRewriteRule makeRule() {
        Type var0 = this.getInputSchema().getType(References.ENTITY);
        Type var1 = this.getOutputSchema().getType(References.ENTITY);
        return this.fixTypeEverywhereTyped("Fix Arrow stored weapon", var0, var1, ExtraDataFixUtils.chainAllFilters(this.fixChoice("minecraft:arrow"), this.fixChoice("minecraft:spectral_arrow")));
    }

    private Function<Typed<?>, Typed<?>> fixChoice(String var0) {
        Type var1 = this.getInputSchema().getChoiceType(References.ENTITY, var0);
        Type var2 = this.getOutputSchema().getChoiceType(References.ENTITY, var0);
        return ProjectileStoredWeaponFix.fixChoiceCap(var0, var1, var2);
    }

    private static <T> Function<Typed<?>, Typed<?>> fixChoiceCap(String var0, Type<?> var1, Type<T> var22) {
        OpticFinder var3 = DSL.namedChoice((String)var0, var1);
        return var2 -> var2.updateTyped(var3, var22, var1 -> Util.writeAndReadTypedOrThrow(var1, var22, UnaryOperator.identity()));
    }
}

