/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.TaggedChoice;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.util.datafix.ExtraDataFixUtils;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.schemas.NamespacedSchema;

public class SaddleEquipmentSlotFix
extends DataFix {
    private static final Set<String> ENTITIES_WITH_SADDLE_ITEM = Set.of("minecraft:horse", "minecraft:skeleton_horse", "minecraft:zombie_horse", "minecraft:donkey", "minecraft:mule", "minecraft:camel", "minecraft:llama", "minecraft:trader_llama");
    private static final Set<String> ENTITIES_WITH_SADDLE_FLAG = Set.of("minecraft:pig", "minecraft:strider");
    private static final String SADDLE_FLAG = "Saddle";
    private static final String NEW_SADDLE = "saddle";

    public SaddleEquipmentSlotFix(Schema var0) {
        super(var0, true);
    }

    protected TypeRewriteRule makeRule() {
        TaggedChoice.TaggedChoiceType var0 = this.getInputSchema().findChoiceType(References.ENTITY);
        OpticFinder var1 = DSL.typeFinder((Type)var0);
        Type var2 = this.getInputSchema().getType(References.ENTITY);
        Type var32 = this.getOutputSchema().getType(References.ENTITY);
        Type<?> var4 = ExtraDataFixUtils.patchSubType(var2, var2, var32);
        return this.fixTypeEverywhereTyped("SaddleEquipmentSlotFix", var2, var32, var3 -> {
            String var4 = var3.getOptional(var1).map(Pair::getFirst).map(NamespacedSchema::ensureNamespaced).orElse("");
            Typed var5 = ExtraDataFixUtils.cast(var4, var3);
            if (ENTITIES_WITH_SADDLE_ITEM.contains(var4)) {
                return Util.writeAndReadTypedOrThrow(var5, var32, SaddleEquipmentSlotFix::fixEntityWithSaddleItem);
            }
            if (ENTITIES_WITH_SADDLE_FLAG.contains(var4)) {
                return Util.writeAndReadTypedOrThrow(var5, var32, SaddleEquipmentSlotFix::fixEntityWithSaddleFlag);
            }
            return ExtraDataFixUtils.cast(var32, var3);
        });
    }

    private static Dynamic<?> fixEntityWithSaddleItem(Dynamic<?> var0) {
        if (var0.get("SaddleItem").result().isEmpty()) {
            return var0;
        }
        return SaddleEquipmentSlotFix.fixDropChances(var0.renameField("SaddleItem", NEW_SADDLE));
    }

    private static Dynamic<?> fixEntityWithSaddleFlag(Dynamic<?> var0) {
        boolean var1 = var0.get(SADDLE_FLAG).asBoolean(false);
        var0 = var0.remove(SADDLE_FLAG);
        if (!var1) {
            return var0;
        }
        Dynamic var2 = var0.emptyMap().set("id", var0.createString("minecraft:saddle")).set("count", var0.createInt(1));
        return SaddleEquipmentSlotFix.fixDropChances(var0.set(NEW_SADDLE, var2));
    }

    private static Dynamic<?> fixDropChances(Dynamic<?> var0) {
        Dynamic var1 = var0.get("drop_chances").orElseEmptyMap().set(NEW_SADDLE, var0.createFloat(2.0f));
        return var0.set("drop_chances", var1);
    }
}

