/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.debugchart;

import com.google.common.collect.Maps;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.network.protocol.game.ClientboundDebugSamplePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.debugchart.RemoteDebugSampleType;

public class DebugSampleSubscriptionTracker {
    public static final int STOP_SENDING_AFTER_TICKS = 200;
    public static final int STOP_SENDING_AFTER_MS = 10000;
    private final PlayerList playerList;
    private final Map<RemoteDebugSampleType, Map<ServerPlayer, SubscriptionStartedAt>> subscriptions;
    private final Queue<SubscriptionRequest> subscriptionRequestQueue = new LinkedList<SubscriptionRequest>();

    public DebugSampleSubscriptionTracker(PlayerList var02) {
        this.playerList = var02;
        this.subscriptions = Util.makeEnumMap(RemoteDebugSampleType.class, var0 -> Maps.newHashMap());
    }

    public boolean shouldLogSamples(RemoteDebugSampleType var0) {
        return !this.subscriptions.get((Object)var0).isEmpty();
    }

    public void broadcast(ClientboundDebugSamplePacket var0) {
        Set<ServerPlayer> var1 = this.subscriptions.get((Object)var0.debugSampleType()).keySet();
        for (ServerPlayer var3 : var1) {
            var3.connection.send(var0);
        }
    }

    public void subscribe(ServerPlayer var0, RemoteDebugSampleType var1) {
        if (this.playerList.isOp(var0.getGameProfile())) {
            this.subscriptionRequestQueue.add(new SubscriptionRequest(var0, var1));
        }
    }

    public void tick(int var0) {
        long var1 = Util.getMillis();
        this.handleSubscriptions(var1, var0);
        this.handleUnsubscriptions(var1, var0);
    }

    private void handleSubscriptions(long var0, int var2) {
        for (SubscriptionRequest var4 : this.subscriptionRequestQueue) {
            this.subscriptions.get((Object)var4.sampleType()).put(var4.player(), new SubscriptionStartedAt(var0, var2));
        }
    }

    private void handleUnsubscriptions(long var0, int var2) {
        for (Map<ServerPlayer, SubscriptionStartedAt> var4 : this.subscriptions.values()) {
            var4.entrySet().removeIf(var3 -> {
                boolean var4 = !this.playerList.isOp(((ServerPlayer)var3.getKey()).getGameProfile());
                SubscriptionStartedAt var5 = (SubscriptionStartedAt)var3.getValue();
                return var4 || var2 > var5.tick() + 200 && var0 > var5.millis() + 10000L;
            });
        }
    }

    record SubscriptionRequest(ServerPlayer player, RemoteDebugSampleType sampleType) {
    }

    record SubscriptionStartedAt(long millis, int tick) {
    }
}

