/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling;

import com.mojang.logging.LogUtils;
import java.io.File;
import java.util.function.LongSupplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.util.profiling.ActiveProfiler;
import net.minecraft.util.profiling.InactiveProfiler;
import net.minecraft.util.profiling.ProfileCollector;
import net.minecraft.util.profiling.ProfileResults;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;

public class SingleTickProfiler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final LongSupplier realTime;
    private final long saveThreshold;
    private int tick;
    private final File location;
    private ProfileCollector profiler = InactiveProfiler.INSTANCE;

    public SingleTickProfiler(LongSupplier var0, String var1, long var2) {
        this.realTime = var0;
        this.location = new File("debug", var1);
        this.saveThreshold = var2;
    }

    public ProfilerFiller startTick() {
        this.profiler = new ActiveProfiler(this.realTime, () -> this.tick, () -> true);
        ++this.tick;
        return this.profiler;
    }

    public void endTick() {
        if (this.profiler == InactiveProfiler.INSTANCE) {
            return;
        }
        ProfileResults var0 = this.profiler.getResults();
        this.profiler = InactiveProfiler.INSTANCE;
        if (var0.getNanoDuration() >= this.saveThreshold) {
            File var1 = new File(this.location, "tick-results-" + Util.getFilenameFormattedDateTime() + ".txt");
            var0.saveResults(var1.toPath());
            LOGGER.info("Recorded long tick -- wrote info to: {}", (Object)var1.getAbsolutePath());
        }
    }

    @Nullable
    public static SingleTickProfiler createTickProfiler(String var0) {
        return null;
    }

    public static ProfilerFiller decorateFiller(ProfilerFiller var0, @Nullable SingleTickProfiler var1) {
        if (var1 != null) {
            return ProfilerFiller.combine(var1.startTick(), var0);
        }
        return var0;
    }
}

