/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling;

import com.mojang.jtracy.Plot;
import com.mojang.jtracy.TracyClient;
import com.mojang.jtracy.Zone;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.SharedConstants;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.profiling.metrics.MetricCategory;
import org.slf4j.Logger;

public class TracyZoneFiller
implements ProfilerFiller {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final StackWalker STACK_WALKER = StackWalker.getInstance(Set.of(StackWalker.Option.RETAIN_CLASS_REFERENCE), 5);
    private final List<Zone> activeZones = new ArrayList<Zone>();
    private final Map<String, PlotAndValue> plots = new HashMap<String, PlotAndValue>();
    private final String name = Thread.currentThread().getName();

    @Override
    public void startTick() {
    }

    @Override
    public void endTick() {
        for (PlotAndValue var1 : this.plots.values()) {
            var1.set(0);
        }
    }

    @Override
    public void push(String var0) {
        Optional var4;
        String var1 = "";
        String var2 = "";
        int var3 = 0;
        if (SharedConstants.IS_RUNNING_IN_IDE && (var4 = STACK_WALKER.walk(var02 -> var02.filter(var0 -> var0.getDeclaringClass() != TracyZoneFiller.class && var0.getDeclaringClass() != ProfilerFiller.CombinedProfileFiller.class).findFirst())).isPresent()) {
            StackWalker.StackFrame var5 = (StackWalker.StackFrame)var4.get();
            var1 = var5.getMethodName();
            var2 = var5.getFileName();
            var3 = var5.getLineNumber();
        }
        var4 = TracyClient.beginZone((String)var0, (String)var1, (String)var2, (int)var3);
        this.activeZones.add((Zone)var4);
    }

    @Override
    public void push(Supplier<String> var0) {
        this.push(var0.get());
    }

    @Override
    public void pop() {
        if (this.activeZones.isEmpty()) {
            LOGGER.error("Tried to pop one too many times! Mismatched push() and pop()?");
            return;
        }
        Zone var0 = this.activeZones.removeLast();
        var0.close();
    }

    @Override
    public void popPush(String var0) {
        this.pop();
        this.push(var0);
    }

    @Override
    public void popPush(Supplier<String> var0) {
        this.pop();
        this.push(var0.get());
    }

    @Override
    public void markForCharting(MetricCategory var0) {
    }

    @Override
    public void incrementCounter(String var0, int var12) {
        this.plots.computeIfAbsent(var0, var1 -> new PlotAndValue(this.name + " " + var0)).add(var12);
    }

    @Override
    public void incrementCounter(Supplier<String> var0, int var1) {
        this.incrementCounter(var0.get(), var1);
    }

    private Zone activeZone() {
        return this.activeZones.getLast();
    }

    @Override
    public void addZoneText(String var0) {
        this.activeZone().addText(var0);
    }

    @Override
    public void addZoneValue(long var0) {
        this.activeZone().addValue(var0);
    }

    @Override
    public void setZoneColor(int var0) {
        this.activeZone().setColor(var0);
    }

    static final class PlotAndValue {
        private final Plot plot;
        private int value;

        PlotAndValue(String var0) {
            this.plot = TracyClient.createPlot((String)var0);
            this.value = 0;
        }

        void set(int var0) {
            this.value = var0;
            this.plot.setValue((double)var0);
        }

        void add(int var0) {
            this.set(this.value + var0);
        }
    }
}

