/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.valueproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.IntProviderType;

public class ClampedNormalInt
extends IntProvider {
    public static final MapCodec<ClampedNormalInt> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)Codec.FLOAT.fieldOf("mean").forGetter(var0 -> Float.valueOf(var0.mean)), (App)Codec.FLOAT.fieldOf("deviation").forGetter(var0 -> Float.valueOf(var0.deviation)), (App)Codec.INT.fieldOf("min_inclusive").forGetter(var0 -> var0.minInclusive), (App)Codec.INT.fieldOf("max_inclusive").forGetter(var0 -> var0.maxInclusive)).apply((Applicative)var02, ClampedNormalInt::new)).validate(var0 -> {
        if (var0.maxInclusive < var0.minInclusive) {
            return DataResult.error(() -> "Max must be larger than min: [" + var0.minInclusive + ", " + var0.maxInclusive + "]");
        }
        return DataResult.success((Object)var0);
    });
    private final float mean;
    private final float deviation;
    private final int minInclusive;
    private final int maxInclusive;

    public static ClampedNormalInt of(float var0, float var1, int var2, int var3) {
        return new ClampedNormalInt(var0, var1, var2, var3);
    }

    private ClampedNormalInt(float var0, float var1, int var2, int var3) {
        this.mean = var0;
        this.deviation = var1;
        this.minInclusive = var2;
        this.maxInclusive = var3;
    }

    @Override
    public int sample(RandomSource var0) {
        return ClampedNormalInt.sample(var0, this.mean, this.deviation, this.minInclusive, this.maxInclusive);
    }

    public static int sample(RandomSource var0, float var1, float var2, float var3, float var4) {
        return (int)Mth.clamp(Mth.normal(var0, var1, var2), var3, var4);
    }

    @Override
    public int getMinValue() {
        return this.minInclusive;
    }

    @Override
    public int getMaxValue() {
        return this.maxInclusive;
    }

    @Override
    public IntProviderType<?> getType() {
        return IntProviderType.CLAMPED_NORMAL;
    }

    public String toString() {
        return "normal(" + this.mean + ", " + this.deviation + ") in [" + this.minInclusive + "-" + this.maxInclusive + "]";
    }
}

