/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.worldupdate;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Reference2FloatMap;
import it.unimi.dsi.fastutil.objects.Reference2FloatMaps;
import it.unimi.dsi.fastutil.objects.Reference2FloatOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.storage.ChunkStorage;
import net.minecraft.world.level.chunk.storage.RecreatingChunkStorage;
import net.minecraft.world.level.chunk.storage.RecreatingSimpleRegionStorage;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.WorldData;
import org.slf4j.Logger;

public class WorldUpgrader
implements AutoCloseable {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactoryBuilder().setDaemon(true).build();
    private static final String NEW_DIRECTORY_PREFIX = "new_";
    static final Component STATUS_UPGRADING_POI = Component.translatable("optimizeWorld.stage.upgrading.poi");
    static final Component STATUS_FINISHED_POI = Component.translatable("optimizeWorld.stage.finished.poi");
    static final Component STATUS_UPGRADING_ENTITIES = Component.translatable("optimizeWorld.stage.upgrading.entities");
    static final Component STATUS_FINISHED_ENTITIES = Component.translatable("optimizeWorld.stage.finished.entities");
    static final Component STATUS_UPGRADING_CHUNKS = Component.translatable("optimizeWorld.stage.upgrading.chunks");
    static final Component STATUS_FINISHED_CHUNKS = Component.translatable("optimizeWorld.stage.finished.chunks");
    final Registry<LevelStem> dimensions;
    final Set<ResourceKey<Level>> levels;
    final boolean eraseCache;
    final boolean recreateRegionFiles;
    final LevelStorageSource.LevelStorageAccess levelStorage;
    private final Thread thread;
    final DataFixer dataFixer;
    volatile boolean running = true;
    private volatile boolean finished;
    volatile float progress;
    volatile int totalChunks;
    volatile int totalFiles;
    volatile int converted;
    volatile int skipped;
    final Reference2FloatMap<ResourceKey<Level>> progressMap = Reference2FloatMaps.synchronize((Reference2FloatMap)new Reference2FloatOpenHashMap());
    volatile Component status = Component.translatable("optimizeWorld.stage.counting");
    static final Pattern REGEX = Pattern.compile("^r\\.(-?[0-9]+)\\.(-?[0-9]+)\\.mca$");
    final DimensionDataStorage overworldDataStorage;

    public WorldUpgrader(LevelStorageSource.LevelStorageAccess convertable_conversionsession, DataFixer datafixer, WorldData savedata, RegistryAccess iregistrycustom, boolean flag, boolean flag1) {
        this.dimensions = iregistrycustom.lookupOrThrow(Registries.LEVEL_STEM);
        this.levels = Stream.of(convertable_conversionsession.dimensionType).map(Registries::levelStemToLevel).collect(Collectors.toUnmodifiableSet());
        this.eraseCache = flag;
        this.dataFixer = datafixer;
        this.levelStorage = convertable_conversionsession;
        SavedData.Context persistentbase_a = new SavedData.Context(null, savedata.worldGenOptions().seed());
        this.overworldDataStorage = new DimensionDataStorage(persistentbase_a, this.levelStorage.getDimensionPath(Level.OVERWORLD).resolve("data"), datafixer, iregistrycustom);
        this.recreateRegionFiles = flag1;
        this.thread = THREAD_FACTORY.newThread(this::work);
        this.thread.setUncaughtExceptionHandler((thread, throwable) -> {
            LOGGER.error("Error upgrading world", throwable);
            this.status = Component.translatable("optimizeWorld.stage.failed");
            this.finished = true;
        });
        this.thread.start();
    }

    public void cancel() {
        this.running = false;
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void work() {
        long i = Util.getMillis();
        LOGGER.info("Upgrading entities");
        new EntityUpgrader(this).upgrade();
        LOGGER.info("Upgrading POIs");
        new PoiUpgrader(this).upgrade();
        LOGGER.info("Upgrading blocks");
        new ChunkUpgrader().upgrade();
        this.overworldDataStorage.saveAndJoin();
        i = Util.getMillis() - i;
        LOGGER.info("World optimizaton finished after {} seconds", (Object)(i / 1000L));
        this.finished = true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public Set<ResourceKey<Level>> levels() {
        return this.levels;
    }

    public float dimensionProgress(ResourceKey<Level> resourcekey) {
        return this.progressMap.getFloat(resourcekey);
    }

    public float getProgress() {
        return this.progress;
    }

    public int getTotalChunks() {
        return this.totalChunks;
    }

    public int getConverted() {
        return this.converted;
    }

    public int getSkipped() {
        return this.skipped;
    }

    public Component getStatus() {
        return this.status;
    }

    @Override
    public void close() {
        this.overworldDataStorage.close();
    }

    static Path resolveRecreateDirectory(Path path) {
        return path.resolveSibling(NEW_DIRECTORY_PREFIX + path.getFileName().toString());
    }

    private class EntityUpgrader
    extends SimpleRegionStorageUpgrader {
        EntityUpgrader(WorldUpgrader worldUpgrader) {
            super(DataFixTypes.ENTITY_CHUNK, "entities", STATUS_UPGRADING_ENTITIES, STATUS_FINISHED_ENTITIES);
        }

        @Override
        protected CompoundTag upgradeTag(SimpleRegionStorage simpleregionstorage, CompoundTag nbttagcompound) {
            return simpleregionstorage.upgradeChunkTag(nbttagcompound, -1);
        }
    }

    private class PoiUpgrader
    extends SimpleRegionStorageUpgrader {
        PoiUpgrader(WorldUpgrader worldUpgrader) {
            super(DataFixTypes.POI_CHUNK, "poi", STATUS_UPGRADING_POI, STATUS_FINISHED_POI);
        }

        @Override
        protected CompoundTag upgradeTag(SimpleRegionStorage simpleregionstorage, CompoundTag nbttagcompound) {
            return simpleregionstorage.upgradeChunkTag(nbttagcompound, 1945);
        }
    }

    private class ChunkUpgrader
    extends AbstractUpgrader<ChunkStorage> {
        ChunkUpgrader() {
            super(DataFixTypes.CHUNK, "chunk", "region", STATUS_UPGRADING_CHUNKS, STATUS_FINISHED_CHUNKS);
        }

        @Override
        protected boolean tryProcessOnePosition(ChunkStorage ichunkloader, ChunkPos chunkcoordintpair, ResourceKey<Level> resourcekey) {
            CompoundTag nbttagcompound = ichunkloader.read(chunkcoordintpair).join().orElse(null);
            if (nbttagcompound != null) {
                boolean flag;
                int i = ChunkStorage.getVersion(nbttagcompound);
                ChunkGenerator chunkgenerator = WorldUpgrader.this.dimensions.getValueOrThrow(Registries.levelToLevelStem(resourcekey)).generator();
                CompoundTag nbttagcompound1 = ichunkloader.upgradeChunkTag(Registries.levelToLevelStem(resourcekey), () -> WorldUpgrader.this.overworldDataStorage, nbttagcompound, chunkgenerator.getTypeNameForDataFixer(), chunkcoordintpair, null);
                ChunkPos chunkcoordintpair1 = new ChunkPos(nbttagcompound1.getIntOr("xPos", 0), nbttagcompound1.getIntOr("zPos", 0));
                if (!chunkcoordintpair1.equals(chunkcoordintpair)) {
                    LOGGER.warn("Chunk {} has invalid position {}", (Object)chunkcoordintpair, (Object)chunkcoordintpair1);
                }
                boolean bl = flag = i < SharedConstants.getCurrentVersion().dataVersion().version();
                if (WorldUpgrader.this.eraseCache) {
                    flag = flag || nbttagcompound1.contains("Heightmaps");
                    nbttagcompound1.remove("Heightmaps");
                    flag = flag || nbttagcompound1.contains("isLightOn");
                    nbttagcompound1.remove("isLightOn");
                    ListTag nbttaglist = nbttagcompound1.getListOrEmpty("sections");
                    for (int j = 0; j < nbttaglist.size(); ++j) {
                        Optional<CompoundTag> optional = nbttaglist.getCompound(j);
                        if (optional.isEmpty()) continue;
                        CompoundTag nbttagcompound2 = optional.get();
                        flag = flag || nbttagcompound2.contains("BlockLight");
                        nbttagcompound2.remove("BlockLight");
                        flag = flag || nbttagcompound2.contains("SkyLight");
                        nbttagcompound2.remove("SkyLight");
                    }
                }
                if (flag || WorldUpgrader.this.recreateRegionFiles) {
                    if (this.previousWriteFuture != null) {
                        this.previousWriteFuture.join();
                    }
                    this.previousWriteFuture = ichunkloader.write(chunkcoordintpair, () -> nbttagcompound1);
                    return true;
                }
            }
            return false;
        }

        @Override
        protected ChunkStorage createStorage(RegionStorageInfo regionstorageinfo, Path path) {
            return WorldUpgrader.this.recreateRegionFiles ? new RecreatingChunkStorage(regionstorageinfo.withTypeSuffix("source"), path, regionstorageinfo.withTypeSuffix("target"), WorldUpgrader.resolveRecreateDirectory(path), WorldUpgrader.this.dataFixer, true) : new ChunkStorage(regionstorageinfo, path, WorldUpgrader.this.dataFixer, true);
        }
    }

    private abstract class SimpleRegionStorageUpgrader
    extends AbstractUpgrader<SimpleRegionStorage> {
        SimpleRegionStorageUpgrader(DataFixTypes datafixtypes, String s, Component ichatbasecomponent, Component ichatbasecomponent1) {
            super(datafixtypes, s, s, ichatbasecomponent, ichatbasecomponent1);
        }

        @Override
        protected SimpleRegionStorage createStorage(RegionStorageInfo regionstorageinfo, Path path) {
            return WorldUpgrader.this.recreateRegionFiles ? new RecreatingSimpleRegionStorage(regionstorageinfo.withTypeSuffix("source"), path, regionstorageinfo.withTypeSuffix("target"), WorldUpgrader.resolveRecreateDirectory(path), WorldUpgrader.this.dataFixer, true, this.dataFixType) : new SimpleRegionStorage(regionstorageinfo, path, WorldUpgrader.this.dataFixer, true, this.dataFixType);
        }

        @Override
        protected boolean tryProcessOnePosition(SimpleRegionStorage simpleregionstorage, ChunkPos chunkcoordintpair, ResourceKey<Level> resourcekey) {
            CompoundTag nbttagcompound = simpleregionstorage.read(chunkcoordintpair).join().orElse(null);
            if (nbttagcompound != null) {
                boolean flag;
                int i = ChunkStorage.getVersion(nbttagcompound);
                CompoundTag nbttagcompound1 = this.upgradeTag(simpleregionstorage, nbttagcompound);
                boolean bl = flag = i < SharedConstants.getCurrentVersion().dataVersion().version();
                if (flag || WorldUpgrader.this.recreateRegionFiles) {
                    if (this.previousWriteFuture != null) {
                        this.previousWriteFuture.join();
                    }
                    this.previousWriteFuture = simpleregionstorage.write(chunkcoordintpair, nbttagcompound1);
                    return true;
                }
            }
            return false;
        }

        protected abstract CompoundTag upgradeTag(SimpleRegionStorage var1, CompoundTag var2);
    }

    private abstract class AbstractUpgrader<T extends AutoCloseable> {
        private final Component upgradingStatus;
        private final Component finishedStatus;
        private final String type;
        private final String folderName;
        @Nullable
        protected CompletableFuture<Void> previousWriteFuture;
        protected final DataFixTypes dataFixType;

        AbstractUpgrader(DataFixTypes datafixtypes, String s, String s1, Component ichatbasecomponent, Component ichatbasecomponent1) {
            this.dataFixType = datafixtypes;
            this.type = s;
            this.folderName = s1;
            this.upgradingStatus = ichatbasecomponent;
            this.finishedStatus = ichatbasecomponent1;
        }

        public void upgrade() {
            WorldUpgrader.this.totalFiles = 0;
            WorldUpgrader.this.totalChunks = 0;
            WorldUpgrader.this.converted = 0;
            WorldUpgrader.this.skipped = 0;
            List<DimensionToUpgrade<T>> list = this.getDimensionsToUpgrade();
            if (WorldUpgrader.this.totalChunks != 0) {
                float f = WorldUpgrader.this.totalFiles;
                WorldUpgrader.this.status = this.upgradingStatus;
                while (WorldUpgrader.this.running) {
                    boolean flag = false;
                    float f1 = 0.0f;
                    for (DimensionToUpgrade<T> worldupgrader_c : list) {
                        ResourceKey<Level> resourcekey = worldupgrader_c.dimensionKey;
                        ListIterator<FileToUpgrade> listiterator = worldupgrader_c.files;
                        AutoCloseable t0 = (AutoCloseable)worldupgrader_c.storage;
                        if (listiterator.hasNext()) {
                            FileToUpgrade worldupgrader_e = listiterator.next();
                            boolean flag1 = true;
                            for (ChunkPos chunkcoordintpair : worldupgrader_e.chunksToUpgrade) {
                                flag1 = flag1 && this.processOnePosition(resourcekey, t0, chunkcoordintpair);
                                flag = true;
                            }
                            if (WorldUpgrader.this.recreateRegionFiles) {
                                if (flag1) {
                                    this.onFileFinished(worldupgrader_e.file);
                                } else {
                                    LOGGER.error("Failed to convert region file {}", (Object)worldupgrader_e.file.getPath());
                                }
                            }
                        }
                        float f2 = (float)listiterator.nextIndex() / f;
                        WorldUpgrader.this.progressMap.put(resourcekey, f2);
                        f1 += f2;
                    }
                    WorldUpgrader.this.progress = f1;
                    if (flag) continue;
                    break;
                }
                WorldUpgrader.this.status = this.finishedStatus;
                for (DimensionToUpgrade<T> worldupgrader_c1 : list) {
                    try {
                        ((AutoCloseable)worldupgrader_c1.storage).close();
                    }
                    catch (Exception exception) {
                        LOGGER.error("Error upgrading chunk", (Throwable)exception);
                    }
                }
            }
        }

        private List<DimensionToUpgrade<T>> getDimensionsToUpgrade() {
            ArrayList list = Lists.newArrayList();
            for (ResourceKey<Level> resourcekey : WorldUpgrader.this.levels) {
                RegionStorageInfo regionstorageinfo = new RegionStorageInfo(WorldUpgrader.this.levelStorage.getLevelId(), resourcekey, this.type);
                Path path = WorldUpgrader.this.levelStorage.getDimensionPath(resourcekey).resolve(this.folderName);
                T t0 = this.createStorage(regionstorageinfo, path);
                ListIterator<FileToUpgrade> listiterator = this.getFilesToProcess(regionstorageinfo, path);
                list.add(new DimensionToUpgrade<T>(resourcekey, t0, listiterator));
            }
            return list;
        }

        protected abstract T createStorage(RegionStorageInfo var1, Path var2);

        private ListIterator<FileToUpgrade> getFilesToProcess(RegionStorageInfo regionstorageinfo, Path path) {
            List<FileToUpgrade> list = AbstractUpgrader.getAllChunkPositions(regionstorageinfo, path);
            WorldUpgrader.this.totalFiles += list.size();
            WorldUpgrader.this.totalChunks += list.stream().mapToInt(worldupgrader_e -> worldupgrader_e.chunksToUpgrade.size()).sum();
            return list.listIterator();
        }

        private static List<FileToUpgrade> getAllChunkPositions(RegionStorageInfo regionstorageinfo, Path path) {
            File[] afile = path.toFile().listFiles((file, s) -> s.endsWith(".mca"));
            if (afile == null) {
                return List.of();
            }
            ArrayList list = Lists.newArrayList();
            for (File file2 : afile) {
                Matcher matcher = REGEX.matcher(file2.getName());
                if (!matcher.matches()) continue;
                int i = Integer.parseInt(matcher.group(1)) << 5;
                int j = Integer.parseInt(matcher.group(2)) << 5;
                ArrayList list1 = Lists.newArrayList();
                try (RegionFile regionfile = new RegionFile(regionstorageinfo, file2.toPath(), path, true);){
                    for (int k = 0; k < 32; ++k) {
                        for (int l = 0; l < 32; ++l) {
                            ChunkPos chunkcoordintpair = new ChunkPos(k + i, l + j);
                            if (!regionfile.doesChunkExist(chunkcoordintpair)) continue;
                            list1.add(chunkcoordintpair);
                        }
                    }
                    if (list1.isEmpty()) continue;
                    list.add(new FileToUpgrade(regionfile, list1));
                }
                catch (Throwable throwable) {
                    LOGGER.error("Failed to read chunks from region file {}", (Object)file2.toPath(), (Object)throwable);
                }
            }
            return list;
        }

        private boolean processOnePosition(ResourceKey<Level> resourcekey, T t0, ChunkPos chunkcoordintpair) {
            boolean flag = false;
            try {
                flag = this.tryProcessOnePosition(t0, chunkcoordintpair, resourcekey);
            }
            catch (CompletionException | ReportedException reportedexception) {
                Throwable throwable = reportedexception.getCause();
                if (!(throwable instanceof IOException)) {
                    throw reportedexception;
                }
                LOGGER.error("Error upgrading chunk {}", (Object)chunkcoordintpair, (Object)throwable);
            }
            if (flag) {
                ++WorldUpgrader.this.converted;
            } else {
                ++WorldUpgrader.this.skipped;
            }
            return flag;
        }

        protected abstract boolean tryProcessOnePosition(T var1, ChunkPos var2, ResourceKey<Level> var3);

        private void onFileFinished(RegionFile regionfile) {
            if (WorldUpgrader.this.recreateRegionFiles) {
                if (this.previousWriteFuture != null) {
                    this.previousWriteFuture.join();
                }
                Path path = regionfile.getPath();
                Path path1 = path.getParent();
                Path path2 = WorldUpgrader.resolveRecreateDirectory(path1).resolve(path.getFileName().toString());
                try {
                    if (path2.toFile().exists()) {
                        Files.delete(path);
                        Files.move(path2, path, new CopyOption[0]);
                    } else {
                        LOGGER.error("Failed to replace an old region file. New file {} does not exist.", (Object)path2);
                    }
                }
                catch (IOException ioexception) {
                    LOGGER.error("Failed to replace an old region file", (Throwable)ioexception);
                }
            }
        }
    }

    record FileToUpgrade(RegionFile file, List<ChunkPos> chunksToUpgrade) {
    }

    record DimensionToUpgrade<T>(ResourceKey<Level> dimensionKey, T storage, ListIterator<FileToUpgrade> files) {
    }
}

